/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistorUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PersistorUtil.class);

    private PersistorUtil() {
    }

    public static void startResolvingOrUpdating(ObjectAdapter objectAdapter) {
        if (objectAdapter.canTransitionToResolving()) {
            PersistorUtil.startResolving(objectAdapter);
        } else {
            PersistorUtil.startUpdating(objectAdapter);
        }
    }

    public static void startResolving(ObjectAdapter adapter) {
        PersistorUtil.changeTo(adapter, ResolveState.RESOLVING);
    }

    public static void startUpdating(ObjectAdapter adapter) {
        PersistorUtil.changeTo(adapter, ResolveState.UPDATING);
    }

    private static void changeTo(ObjectAdapter adapter, ResolveState state) {
        PersistorUtil.changeTo("start ", adapter, state);
    }

    public static void toEndState(ObjectAdapter adapter) {
        PersistorUtil.changeTo("end ", adapter, adapter.getResolveState().getEndState());
    }

    private static void changeTo(String direction, ObjectAdapter adapter, ResolveState state) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(direction + adapter + " as " + state.name());
        }
        adapter.changeState(state);
    }
}

