/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.adaptermanager;

import java.util.Iterator;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.ensure.IsisAssertException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterFactory;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.adapter.oid.AggregatedOid;
import org.apache.isis.core.metamodel.adapter.oid.CollectionOid;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.facets.object.aggregated.ParentedFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.typeof.ElementSpecificationProviderFromTypeOfFacet;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.persistence.adaptermanager.OidAdapterHashMap;
import org.apache.isis.core.runtime.persistence.adaptermanager.PojoAdapterHashMap;
import org.apache.isis.core.runtime.persistence.adaptermanager.PojoRecreator;
import org.apache.isis.core.runtime.persistence.adaptermanager.RootAndCollectionAdapters;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.AdapterManagerSpi;
import org.apache.isis.core.runtime.system.persistence.OidGenerator;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterManagerDefault
implements AdapterManagerSpi {
    private static final Logger LOG = LoggerFactory.getLogger(AdapterManagerDefault.class);
    protected final PojoAdapterHashMap pojoAdapterMap = new PojoAdapterHashMap();
    protected final OidAdapterHashMap oidAdapterMap = new OidAdapterHashMap();
    private final PojoRecreator pojoRecreator;

    public AdapterManagerDefault(PojoRecreator pojoRecreator) {
        this.pojoRecreator = pojoRecreator;
    }

    public void open() {
        this.oidAdapterMap.open();
        this.pojoAdapterMap.open();
    }

    public void close() {
        this.oidAdapterMap.close();
        this.pojoAdapterMap.close();
    }

    public void reset() {
        this.oidAdapterMap.reset();
        this.pojoAdapterMap.reset();
    }

    @Override
    public Iterator<ObjectAdapter> iterator() {
        return this.pojoAdapterMap.iterator();
    }

    public ObjectAdapter getAdapterFor(Object pojo) {
        Ensure.ensureThatArg((Object)pojo, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        return this.pojoAdapterMap.getAdapter(pojo);
    }

    public ObjectAdapter getAdapterFor(Oid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.ensureMapsConsistent(oid);
        return this.oidAdapterMap.getAdapter(oid);
    }

    public ObjectAdapter adapterFor(Object pojo) {
        if (pojo == null) {
            return null;
        }
        ObjectAdapter existingOrValueAdapter = this.existingOrValueAdapter(pojo);
        if (existingOrValueAdapter != null) {
            return existingOrValueAdapter;
        }
        ObjectAdapter newAdapter = this.createTransientOrViewModelRootAdapter(pojo);
        return this.mapAndInjectServices(newAdapter);
    }

    private ObjectAdapter existingOrValueAdapter(Object pojo) {
        ObjectAdapter adapter = this.getAdapterFor(pojo);
        if (adapter != null) {
            return adapter;
        }
        ObjectAdapter lazilyLoadedAdapter = this.pojoRecreator.lazilyLoaded(pojo);
        if (lazilyLoadedAdapter != null) {
            return lazilyLoadedAdapter;
        }
        ObjectSpecification objSpec = this.getSpecificationLoader().loadSpecification(pojo.getClass());
        if (objSpec.containsFacet(ValueFacet.class)) {
            ObjectAdapter valueAdapter = this.createStandaloneAdapterAndSetResolveState(pojo);
            return valueAdapter;
        }
        return null;
    }

    public ObjectAdapter adapterFor(Object pojo, ObjectAdapter parentAdapter) {
        ObjectAdapter newAdapter;
        Ensure.ensureThatArg((Object)parentAdapter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        ObjectAdapter existingOrValueAdapter = this.existingOrValueAdapter(pojo);
        if (existingOrValueAdapter != null) {
            return existingOrValueAdapter;
        }
        ObjectSpecification objSpec = this.getSpecificationLoader().loadSpecification(pojo.getClass());
        if (AdapterManagerDefault.isAggregated(objSpec)) {
            AggregatedOid aggregatedOid = this.getOidGenerator().createAggregateOid(pojo, parentAdapter);
            newAdapter = this.createAggregatedAdapter(pojo, aggregatedOid);
        } else {
            newAdapter = this.createTransientOrViewModelRootAdapter(pojo);
        }
        return this.mapAndInjectServices(newAdapter);
    }

    public ObjectAdapter adapterFor(Object pojo, ObjectAdapter parentAdapter, OneToManyAssociation collection) {
        Ensure.ensureThatArg((Object)parentAdapter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)collection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        ObjectAdapter existingOrValueAdapter = this.existingOrValueAdapter(pojo);
        if (existingOrValueAdapter != null) {
            return existingOrValueAdapter;
        }
        ObjectAdapter newAdapter = this.createCollectionAdapter(pojo, parentAdapter, collection);
        return this.mapAndInjectServices(newAdapter);
    }

    private ObjectAdapter createCollectionAdapter(Object pojo, ObjectAdapter parentAdapter, OneToManyAssociation otma) {
        this.ensureMapsConsistent(parentAdapter);
        Assert.assertNotNull((Object)pojo);
        Oid parentOid = parentAdapter.getOid();
        CollectionOid collectionOid = new CollectionOid((TypedOid)parentOid, otma);
        ObjectAdapter collectionAdapter = this.createCollectionAdapterAndInferResolveState(pojo, collectionOid);
        TypeOfFacet facet = (TypeOfFacet)otma.getFacet(TypeOfFacet.class);
        collectionAdapter.setElementSpecificationProvider(ElementSpecificationProviderFromTypeOfFacet.createFrom((TypeOfFacet)facet));
        return collectionAdapter;
    }

    private static boolean isAggregated(ObjectSpecification objSpec) {
        return objSpec.containsFacet(ParentedFacet.class);
    }

    public ObjectAdapter adapterFor(TypedOid typedOid) {
        return this.adapterFor(typedOid, AdapterManager.ConcurrencyChecking.NO_CHECK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectAdapter adapterFor(TypedOid typedOid, AdapterManager.ConcurrencyChecking concurrencyChecking) {
        Oid adapterOid;
        ObjectAdapter adapter = this.getAdapterFor((Oid)typedOid);
        if (adapter == null) {
            try {
                Object pojo = this.pojoRecreator.recreatePojo(typedOid);
                adapter = this.mapRecreatedPojo((Oid)typedOid, pojo);
            }
            catch (RuntimeException ex) {
                throw new ObjectNotFoundException((Oid)typedOid, (Throwable)ex);
            }
        }
        if ((adapterOid = adapter.getOid()) instanceof RootOid) {
            RootOid recreatedOid = (RootOid)adapterOid;
            RootOid originalOid = (RootOid)typedOid;
            try {
                if (concurrencyChecking.isChecking()) {
                    Version otherVersion = originalOid.getVersion();
                    Version thisVersion = recreatedOid.getVersion();
                    if (thisVersion != null && otherVersion != null && thisVersion.different(otherVersion)) {
                        if (this.isConcurrencyCheckingGloballyEnabled() && AdapterManager.ConcurrencyChecking.isCurrentlyEnabled()) {
                            LOG.info("concurrency conflict detected on " + recreatedOid + " (" + otherVersion + ")");
                            String currentUser = this.getAuthenticationSession().getUserName();
                            throw new ConcurrencyException(currentUser, (Oid)recreatedOid, thisVersion, otherVersion);
                        }
                        LOG.warn("concurrency conflict detected but suppressed, on " + recreatedOid + " (" + otherVersion + ")");
                    }
                }
            }
            finally {
                Version originalVersion = originalOid.getVersion();
                Version recreatedVersion = recreatedOid.getVersion();
                if (recreatedVersion != null && (originalVersion == null || recreatedVersion.different(originalVersion))) {
                    LOG.info("updating version in oid, on " + originalOid + " (" + originalVersion + ") to (" + recreatedVersion + ")");
                    originalOid.setVersion(recreatedVersion);
                }
            }
        }
        return adapter;
    }

    @Override
    public void remapRecreatedPojo(ObjectAdapter adapter, Object pojo) {
        this.removeAdapter(adapter);
        adapter.replacePojo(pojo);
        this.mapAndInjectServices(adapter);
    }

    @Override
    public ObjectAdapter mapRecreatedPojo(Oid oid, Object recreatedPojo) {
        ObjectAdapter adapterLookedUpByPojo = this.getAdapterFor(recreatedPojo);
        if (adapterLookedUpByPojo != null) {
            return adapterLookedUpByPojo;
        }
        ObjectAdapter adapterLookedUpByOid = this.getAdapterFor(oid);
        if (adapterLookedUpByOid != null) {
            return adapterLookedUpByOid;
        }
        ObjectAdapter createdAdapter = this.createRootOrAggregatedAdapter(oid, recreatedPojo);
        return this.mapAndInjectServices(createdAdapter);
    }

    private ObjectAdapter createRootOrAggregatedAdapter(Oid oid, Object pojo) {
        ObjectAdapter createdAdapter;
        if (oid instanceof RootOid) {
            RootOid rootOid = (RootOid)oid;
            createdAdapter = this.createRootAdapterAndInferResolveState(pojo, rootOid);
        } else if (oid instanceof CollectionOid) {
            CollectionOid collectionOid = (CollectionOid)oid;
            createdAdapter = this.createCollectionAdapterAndInferResolveState(pojo, collectionOid);
        } else {
            AggregatedOid aggregatedOid = (AggregatedOid)oid;
            createdAdapter = this.createAggregatedAdapter(pojo, aggregatedOid);
        }
        return createdAdapter;
    }

    private boolean isConcurrencyCheckingGloballyEnabled() {
        boolean disabled = this.getConfiguration().getBoolean("isis.persistor.disableConcurrencyChecking", false);
        return !disabled;
    }

    @Override
    public void removeAdapter(ObjectAdapter adapter) {
        this.ensureMapsConsistent(adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing adapter: " + adapter);
        }
        this.unmap(adapter);
    }

    @Override
    public void remapAsPersistent(ObjectAdapter adapter, RootOid hintRootOid) {
        RootOid persistedRootOid;
        boolean removed;
        ObjectAdapter rootAdapter = adapter.getAggregateRoot();
        RootOid transientRootOid = (RootOid)rootAdapter.getOid();
        Ensure.ensureThatArg((Object)rootAdapter.isTransient(), (Matcher)CoreMatchers.is((Object)true), (String)("root adapter should be transient; oid:" + transientRootOid));
        Ensure.ensureThatArg((Object)transientRootOid.isTransient(), (Matcher)CoreMatchers.is((Object)true), (String)("root adapter's OID should be transient; oid:" + transientRootOid));
        RootAndCollectionAdapters rootAndCollectionAdapters = new RootAndCollectionAdapters(adapter, this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("remapAsPersistent: " + transientRootOid);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing root adapter from oid map");
        }
        if (!(removed = this.oidAdapterMap.remove((Oid)transientRootOid))) {
            LOG.warn("could not remove oid: " + transientRootOid);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing collection adapter(s) from oid map");
        }
        for (ObjectAdapter collectionAdapter : rootAndCollectionAdapters) {
            Oid collectionOid = collectionAdapter.getOid();
            removed = this.oidAdapterMap.remove(collectionOid);
            if (removed) continue;
            LOG.warn("could not remove collectionOid: " + collectionOid);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("updating the Oid");
        }
        if (hintRootOid != null) {
            ObjectSpecId adapterObjectSpecId;
            if (hintRootOid.isTransient()) {
                throw new IsisAssertException("hintRootOid must be persistent");
            }
            ObjectSpecId hintRootOidObjectSpecId = hintRootOid.getObjectSpecId();
            if (!hintRootOidObjectSpecId.equals((Object)(adapterObjectSpecId = adapter.getSpecification().getSpecId()))) {
                throw new IsisAssertException("hintRootOid's objectType must be same as that of adapter (was: '" + hintRootOidObjectSpecId + "'; adapter's is " + adapterObjectSpecId + "'");
            }
            persistedRootOid = hintRootOid;
        } else {
            persistedRootOid = this.getOidGenerator().createPersistentOrViewModelOid(adapter.getObject(), transientRootOid);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("replacing Oid for root adapter and re-adding into maps; oid is now: " + persistedRootOid.enString(this.getOidMarshaller()) + " (was: " + transientRootOid.enString(this.getOidMarshaller()) + ")");
        }
        adapter.replaceOid((Oid)persistedRootOid);
        this.oidAdapterMap.add((Oid)persistedRootOid, adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("replacing Oids for collection adapter(s) and re-adding into maps");
        }
        for (ObjectAdapter collectionAdapter : rootAndCollectionAdapters) {
            CollectionOid previousCollectionOid = (CollectionOid)collectionAdapter.getOid();
            CollectionOid persistedCollectionOid = previousCollectionOid.asPersistent((TypedOid)persistedRootOid);
            this.oidAdapterMap.add((Oid)persistedCollectionOid, collectionAdapter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("synchronizing collection pojos, remapping in pojo map if required");
        }
        for (OneToManyAssociation otma : rootAndCollectionAdapters.getCollections()) {
            ObjectAdapter collectionAdapter = rootAndCollectionAdapters.getCollectionAdapter(otma);
            Object collectionPojoWrappedByAdapter = collectionAdapter.getObject();
            Object collectionPojoActuallyOnPojo = AdapterManagerDefault.getCollectionPojo(otma, adapter);
            if (collectionPojoActuallyOnPojo == collectionPojoWrappedByAdapter) continue;
            this.pojoAdapterMap.remove(collectionAdapter);
            collectionAdapter.replacePojo(collectionPojoActuallyOnPojo);
            this.pojoAdapterMap.add(collectionPojoActuallyOnPojo, collectionAdapter);
        }
        this.remapContainedAggregatedObject(adapter, persistedRootOid);
        adapter.changeState(ResolveState.RESOLVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("made persistent " + adapter + "; was " + transientRootOid);
        }
    }

    private void remapContainedAggregatedObject(ObjectAdapter adapter, RootOid persistedRootOid) {
        for (ObjectAssociation association : adapter.getSpecification().getAssociations(Contributed.EXCLUDED)) {
            ObjectAdapter referencedAdapter;
            if (association.isOneToManyAssociation() && !association.isNotPersisted()) {
                ObjectAdapter collection = association.get(adapter);
                CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)collection);
                for (ObjectAdapter element : facet.iterable(collection)) {
                    this.remapAggregatedObject(element, persistedRootOid);
                }
                continue;
            }
            if (!association.getSpecification().isParented() || (referencedAdapter = association.get(adapter)) == null) continue;
            this.remapAggregatedObject(referencedAdapter, persistedRootOid);
        }
    }

    private void remapAggregatedObject(ObjectAdapter adapter, RootOid persistedRootOid) {
        Oid oid = adapter.getOid();
        if (!(oid instanceof AggregatedOid) || !oid.isTransient()) {
            return;
        }
        AggregatedOid aoid = (AggregatedOid)oid;
        AggregatedOid childOid = new AggregatedOid(aoid.getObjectSpecId(), (TypedOid)persistedRootOid, aoid.getLocalId());
        adapter.replaceOid((Oid)childOid);
        this.remapContainedAggregatedObject(adapter, persistedRootOid);
    }

    private static Object getCollectionPojo(OneToManyAssociation association, ObjectAdapter ownerAdapter) {
        PropertyOrCollectionAccessorFacet accessor = (PropertyOrCollectionAccessorFacet)association.getFacet(PropertyOrCollectionAccessorFacet.class);
        return accessor.getProperty(ownerAdapter);
    }

    protected final ObjectAdapter createTransientOrViewModelRootAdapter(Object pojo) {
        RootOid rootOid = this.getOidGenerator().createTransientOrViewModelOid(pojo);
        return this.createRootAdapterAndInferResolveState(pojo, rootOid);
    }

    private ObjectAdapter createStandaloneAdapterAndSetResolveState(Object pojo) {
        ObjectAdapter adapter = this.getObjectAdapterFactory().createAdapter(pojo, null, (AdapterManager)this);
        adapter.changeState(ResolveState.VALUE);
        return adapter;
    }

    private ObjectAdapter createRootAdapterAndInferResolveState(Object pojo, RootOid rootOid) {
        Ensure.ensureThatArg((Object)rootOid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        ObjectAdapter rootAdapter = this.getObjectAdapterFactory().createAdapter(pojo, (Oid)rootOid, (AdapterManager)this);
        rootAdapter.changeState(rootOid.isTransient() ? ResolveState.TRANSIENT : ResolveState.GHOST);
        this.doPostCreateRootAdapter(rootAdapter);
        return rootAdapter;
    }

    protected void doPostCreateRootAdapter(ObjectAdapter rootAdapter) {
    }

    private ObjectAdapter createCollectionAdapterAndInferResolveState(Object pojo, CollectionOid collectionOid) {
        Ensure.ensureThatArg((Object)collectionOid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        ObjectAdapter collectionAdapter = this.getObjectAdapterFactory().createAdapter(pojo, (Oid)collectionOid, (AdapterManager)this);
        collectionAdapter.changeState(collectionOid.isTransient() ? ResolveState.TRANSIENT : ResolveState.GHOST);
        return collectionAdapter;
    }

    private ObjectAdapter createAggregatedAdapter(Object pojo, AggregatedOid aggregatedOid) {
        Ensure.ensureThatArg((Object)aggregatedOid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        ObjectAdapter aggregatedAdapter = this.getObjectAdapterFactory().createAdapter(pojo, (Oid)aggregatedOid, (AdapterManager)this);
        return aggregatedAdapter;
    }

    private ObjectAdapter mapAndInjectServices(ObjectAdapter adapter) {
        Assert.assertNotNull((Object)adapter);
        Object pojo = adapter.getObject();
        Assert.assertFalse((String)"POJO Map already contains object", (Object)pojo, (boolean)this.pojoAdapterMap.containsPojo(pojo));
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding identity for adapter with oid=" + adapter.getOid());
        }
        if (adapter.isValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not mapping value adapter");
            }
            this.getServicesInjector().injectServicesInto(pojo);
            return adapter;
        }
        ObjectSpecification objSpec = adapter.getSpecification();
        if (!adapter.isParented() || adapter.isParented() && !objSpec.isImmutable()) {
            this.pojoAdapterMap.add(pojo, adapter);
        }
        this.oidAdapterMap.add(adapter.getOid(), adapter);
        this.getServicesInjector().injectServicesInto(pojo);
        return adapter;
    }

    private void unmap(ObjectAdapter adapter) {
        this.ensureMapsConsistent(adapter);
        Oid oid = adapter.getOid();
        if (oid != null) {
            this.oidAdapterMap.remove(oid);
        }
        this.pojoAdapterMap.remove(adapter);
    }

    private void ensureMapsConsistent(ObjectAdapter adapter) {
        if (adapter.isValue()) {
            return;
        }
        if (adapter.isParented()) {
            return;
        }
        this.ensurePojoAdapterMapConsistent(adapter);
        this.ensureOidAdapterMapConsistent(adapter);
    }

    private void ensureMapsConsistent(Oid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ObjectAdapter adapter = this.oidAdapterMap.getAdapter(oid);
        if (adapter == null) {
            return;
        }
        this.ensureOidAdapterMapConsistent(adapter);
        this.ensurePojoAdapterMapConsistent(adapter);
    }

    private void ensurePojoAdapterMapConsistent(ObjectAdapter adapter) {
        Object adapterPojo = adapter.getObject();
        ObjectAdapter adapterAccordingToPojoAdapterMap = this.pojoAdapterMap.getAdapter(adapterPojo);
        Ensure.ensureThatArg((Object)adapter, (Matcher)CoreMatchers.is((Object)adapterAccordingToPojoAdapterMap), (String)("mismatch in PojoAdapterMap: provided adapter's OID: " + adapter.getOid() + "; \n" + " but map's adapter's OID was : " + adapterAccordingToPojoAdapterMap.getOid()));
    }

    private void ensureOidAdapterMapConsistent(ObjectAdapter adapter) {
        Oid adapterOid = adapter.getOid();
        ObjectAdapter adapterAccordingToOidAdapterMap = this.oidAdapterMap.getAdapter(adapterOid);
        Ensure.ensureThatArg((Object)adapter, (Matcher)CoreMatchers.is((Object)adapterAccordingToOidAdapterMap), (String)("mismatch in OidAdapter map: adapter's Oid: " + adapterOid + ", " + "provided adapter's OID: " + adapter.getOid() + "; " + "map's adapter's Oid: " + adapterAccordingToOidAdapterMap.getOid()));
    }

    public String debugTitle() {
        return "Identity map (adapter manager)";
    }

    public void debugData(DebugBuilder debug) {
        debug.appendTitle(this.pojoAdapterMap.debugTitle());
        this.pojoAdapterMap.debugData(debug);
        debug.appendln();
        debug.appendTitle(this.oidAdapterMap.debugTitle());
        this.oidAdapterMap.debugData(debug);
    }

    public void injectInto(Object candidate) {
        if (AdapterManagerAware.class.isAssignableFrom(candidate.getClass())) {
            AdapterManagerAware cast = (AdapterManagerAware)AdapterManagerAware.class.cast(candidate);
            cast.setAdapterManager((AdapterManager)this);
        }
    }

    protected OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }

    public OidGenerator getOidGenerator() {
        return IsisContext.getPersistenceSession().getOidGenerator();
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    protected ObjectAdapterFactory getObjectAdapterFactory() {
        return this.getPersistenceSession().getObjectAdapterFactory();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected ServicesInjector getServicesInjector() {
        return IsisContext.getPersistenceSession().getServicesInjector();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    protected IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }
}

