/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.adaptermanager;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.persistence.adaptermanager.PojoRecreator;
import org.apache.isis.core.runtime.system.context.IsisContext;

public class PojoRecreatorDefault
implements PojoRecreator {
    @Override
    public Object recreatePojo(TypedOid oid) {
        ObjectSpecification spec = this.getSpecificationLoader().lookupBySpecId(oid.getObjectSpecId());
        Object pojo = spec.createObject();
        if (oid.isViewModel()) {
            ViewModelFacet facet = (ViewModelFacet)spec.getFacet(ViewModelFacet.class);
            if (facet == null) {
                throw new IllegalArgumentException("spec does not have ViewModelFacet; " + oid.toString() + "; spec is " + spec.getFullIdentifier());
            }
            if (!(oid instanceof RootOid)) {
                throw new IllegalArgumentException("oid is view model but not a RootOid; " + oid.toString());
            }
            RootOid rootOid = (RootOid)oid;
            String memento = rootOid.getIdentifier();
            facet.initialize(pojo, memento);
        }
        return pojo;
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    @Override
    public ObjectAdapter lazilyLoaded(Object pojo) {
        return null;
    }
}

