/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.container;

import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;

public class DomainObjectContainerResolve {
    public Object lookup(Bookmark bookmark) {
        RootOid oid = RootOidDefault.create((Bookmark)bookmark);
        ObjectAdapter adapter = this.adapterFor(oid);
        if (adapter == null) {
            return null;
        }
        if (adapter.canTransitionToResolving()) {
            this.getPersistenceSession().resolveImmediately(adapter);
        }
        return adapter.getObject();
    }

    public Bookmark bookmarkFor(Object domainObject) {
        ObjectAdapter adapter = this.adapterFor(domainObject);
        Oid oid = adapter.getOid();
        if (oid == null) {
            return null;
        }
        if (!(oid instanceof RootOid)) {
            return null;
        }
        RootOid rootOid = (RootOid)oid;
        return rootOid.asBookmark();
    }

    public Bookmark bookmarkFor(Class<?> cls, String identifier) {
        ObjectSpecification objectSpec = this.getSpecificationLoader().loadSpecification(cls);
        String objectType = objectSpec.getSpecId().asString();
        return new Bookmark(objectType, identifier);
    }

    public void resolve(Object parent) {
        ObjectAdapter adapter = this.adapterFor(parent);
        if (adapter.canTransitionToResolving()) {
            this.getPersistenceSession().resolveImmediately(adapter);
        }
    }

    public void resolve(Object parent, Object field) {
        if (field == null) {
            this.resolve(parent);
        }
    }

    private ObjectAdapter adapterFor(Object object) {
        return this.getAdapterManager().adapterFor(object);
    }

    private ObjectAdapter adapterFor(RootOid oid) {
        return this.getAdapterManager().adapterFor((TypedOid)oid);
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

