/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.internal;

import java.util.List;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAbstract;
import org.apache.isis.core.metamodel.adapter.DomainObjectServices;
import org.apache.isis.core.metamodel.adapter.DomainObjectServicesAbstract;
import org.apache.isis.core.metamodel.adapter.LocalizationProviderAbstract;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectDirtier;
import org.apache.isis.core.metamodel.adapter.ObjectDirtierAbstract;
import org.apache.isis.core.metamodel.adapter.ObjectPersistor;
import org.apache.isis.core.metamodel.adapter.ObjectPersistorAbstract;
import org.apache.isis.core.metamodel.adapter.QuerySubmitter;
import org.apache.isis.core.metamodel.adapter.QuerySubmitterAbstract;
import org.apache.isis.core.metamodel.adapter.ServicesProvider;
import org.apache.isis.core.metamodel.adapter.ServicesProviderAbstract;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContextAbstract;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.ObjectInstantiationException;
import org.apache.isis.core.metamodel.spec.ObjectInstantiator;
import org.apache.isis.core.metamodel.spec.ObjectInstantiatorAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.runtime.persistence.container.DomainObjectContainerObjectChanged;
import org.apache.isis.core.runtime.persistence.container.DomainObjectContainerResolve;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.MessageBroker;
import org.apache.isis.core.runtime.system.transaction.UpdateNotifier;

public class RuntimeContextFromSession
extends RuntimeContextAbstract {
    private final AuthenticationSessionProvider authenticationSessionProvider = new AuthenticationSessionProviderAbstract(){

        public AuthenticationSession getAuthenticationSession() {
            return IsisContext.getAuthenticationSession();
        }
    };
    private final AdapterManager adapterManager = new AdapterManager(){

        public ObjectAdapter getAdapterFor(Oid oid) {
            return null;
        }

        public ObjectAdapter getAdapterFor(Object pojo) {
            return RuntimeContextFromSession.getRuntimeAdapterManager().getAdapterFor(pojo);
        }

        public ObjectAdapter adapterFor(Object pojo) {
            return RuntimeContextFromSession.getRuntimeAdapterManager().adapterFor(pojo);
        }

        public ObjectAdapter adapterFor(Object pojo, ObjectAdapter ownerAdapter) {
            return RuntimeContextFromSession.getRuntimeAdapterManager().adapterFor(pojo, ownerAdapter);
        }

        public ObjectAdapter adapterFor(Object pojo, ObjectAdapter ownerAdapter, OneToManyAssociation collection) {
            return RuntimeContextFromSession.getRuntimeAdapterManager().adapterFor(pojo, ownerAdapter, collection);
        }

        public ObjectAdapter adapterFor(TypedOid oid) {
            return RuntimeContextFromSession.getRuntimeAdapterManager().adapterFor(oid);
        }

        public ObjectAdapter adapterFor(TypedOid oid, AdapterManager.ConcurrencyChecking concurrencyChecking) {
            return RuntimeContextFromSession.getRuntimeAdapterManager().adapterFor(oid, concurrencyChecking);
        }

        public void injectInto(Object candidate) {
            if (AdapterManagerAware.class.isAssignableFrom(candidate.getClass())) {
                AdapterManagerAware cast = (AdapterManagerAware)AdapterManagerAware.class.cast(candidate);
                cast.setAdapterManager((AdapterManager)this);
            }
        }
    };
    private final ObjectDirtier objectDirtier;
    private final ObjectInstantiator objectInstantiator = new ObjectInstantiatorAbstract(){

        public Object instantiate(Class<?> cls) throws ObjectInstantiationException {
            return RuntimeContextFromSession.getPersistenceSession().getObjectFactory().instantiate(cls);
        }
    };
    private final ObjectPersistor objectPersistor;
    private final ServicesProvider servicesProvider;
    private final ServicesInjector servicesInjector;
    private final QuerySubmitter querySubmitter;
    private final DomainObjectServices domainObjectServices;
    private final LocalizationProviderAbstract localizationProvider;

    public RuntimeContextFromSession() {
        this.objectDirtier = new ObjectDirtierAbstract(){

            public void objectChanged(ObjectAdapter adapter) {
                RuntimeContextFromSession.getPersistenceSession().objectChanged(adapter);
            }

            public void objectChanged(Object object) {
                new DomainObjectContainerObjectChanged().objectChanged(object);
            }
        };
        this.objectPersistor = new ObjectPersistorAbstract(){

            public void makePersistent(ObjectAdapter adapter) {
                RuntimeContextFromSession.getPersistenceSession().makePersistent(adapter);
            }

            public void remove(ObjectAdapter adapter) {
                RuntimeContextFromSession.getUpdateNotifier().addDisposedObject(adapter);
                RuntimeContextFromSession.getPersistenceSession().destroyObject(adapter);
            }
        };
        this.servicesProvider = new ServicesProviderAbstract(){

            public List<ObjectAdapter> getServices() {
                return RuntimeContextFromSession.getPersistenceSession().getServices();
            }

            public <T> T lookupService(Class<T> cls) {
                return (T)RuntimeContextFromSession.getPersistenceSession().getServicesInjector().lookupService(cls);
            }
        };
        this.domainObjectServices = new DomainObjectServicesAbstract(){

            public ObjectAdapter createTransientInstance(ObjectSpecification spec) {
                return RuntimeContextFromSession.getPersistenceSession().createTransientInstance(spec);
            }

            public ObjectAdapter createViewModelInstance(ObjectSpecification spec, String memento) {
                return RuntimeContextFromSession.getPersistenceSession().createViewModelInstance(spec, memento);
            }

            public ObjectAdapter createAggregatedInstance(ObjectSpecification spec, ObjectAdapter parent) {
                return RuntimeContextFromSession.getPersistenceSession().createAggregatedInstance(spec, parent);
            }

            public Object lookup(Bookmark bookmark) {
                return new DomainObjectContainerResolve().lookup(bookmark);
            }

            public Bookmark bookmarkFor(Object domainObject) {
                return new DomainObjectContainerResolve().bookmarkFor(domainObject);
            }

            public Bookmark bookmarkFor(Class<?> cls, String identifier) {
                return new DomainObjectContainerResolve().bookmarkFor(cls, identifier);
            }

            public void resolve(Object parent) {
                new DomainObjectContainerResolve().resolve(parent);
            }

            public void resolve(Object parent, Object field) {
                new DomainObjectContainerResolve().resolve(parent, field);
            }

            public boolean flush() {
                return RuntimeContextFromSession.getTransactionManager().flushTransaction();
            }

            public void commit() {
                RuntimeContextFromSession.getTransactionManager().endTransaction();
            }

            public void informUser(String message) {
                RuntimeContextFromSession.getMessageBroker().addMessage(message);
            }

            public void warnUser(String message) {
                RuntimeContextFromSession.getMessageBroker().addWarning(message);
            }

            public void raiseError(String message) {
                throw new RecoverableException(message);
            }

            public String getProperty(String name) {
                return RuntimeContextFromSession.this.getProperty(name);
            }

            public List<String> getPropertyNames() {
                return RuntimeContextFromSession.this.getPropertyNames();
            }
        };
        this.querySubmitter = new QuerySubmitterAbstract(){

            public <T> List<ObjectAdapter> allMatchingQuery(Query<T> query) {
                ObjectAdapter instances = RuntimeContextFromSession.getPersistenceSession().findInstances(query, QueryCardinality.MULTIPLE);
                return CollectionFacetUtils.convertToAdapterList((ObjectAdapter)instances);
            }

            public <T> ObjectAdapter firstMatchingQuery(Query<T> query) {
                ObjectAdapter instances = RuntimeContextFromSession.getPersistenceSession().findInstances(query, QueryCardinality.SINGLE);
                List list = CollectionFacetUtils.convertToAdapterList((ObjectAdapter)instances);
                return list.size() > 0 ? (ObjectAdapter)list.get(0) : null;
            }
        };
        this.servicesInjector = new ServicesInjector(){

            public void injectServicesInto(Object object) {
                RuntimeContextFromSession.getPersistenceSession().getServicesInjector().injectServicesInto(object);
            }

            public void injectServicesInto(List<Object> objects) {
                RuntimeContextFromSession.getPersistenceSession().getServicesInjector().injectServicesInto(objects);
            }

            public <T> T lookupService(Class<T> serviceClass) {
                return (T)RuntimeContextFromSession.getPersistenceSession().getServicesInjector().lookupService(serviceClass);
            }

            public <T> List<T> lookupServices(Class<T> serviceClass) {
                return RuntimeContextFromSession.getPersistenceSession().getServicesInjector().lookupServices(serviceClass);
            }

            public void injectInto(Object candidate) {
                if (ServicesInjectorAware.class.isAssignableFrom(candidate.getClass())) {
                    ServicesInjectorAware cast = (ServicesInjectorAware)ServicesInjectorAware.class.cast(candidate);
                    cast.setServicesInjector((ServicesInjector)this);
                }
            }

            public List<Object> getRegisteredServices() {
                return RuntimeContextFromSession.getPersistenceSession().getServicesInjector().getRegisteredServices();
            }
        };
        this.localizationProvider = new LocalizationProviderAbstract(){

            public Localization getLocalization() {
                return IsisContext.getLocalization();
            }
        };
    }

    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    public ObjectInstantiator getObjectInstantiator() {
        return this.objectInstantiator;
    }

    public DomainObjectServices getDomainObjectServices() {
        return this.domainObjectServices;
    }

    public ServicesProvider getServicesProvider() {
        return this.servicesProvider;
    }

    public LocalizationProviderAbstract getLocalizationProvider() {
        return this.localizationProvider;
    }

    public ObjectDirtier getObjectDirtier() {
        return this.objectDirtier;
    }

    public ObjectPersistor getObjectPersistor() {
        return this.objectPersistor;
    }

    public ServicesInjector getDependencyInjector() {
        return this.servicesInjector;
    }

    public QuerySubmitter getQuerySubmitter() {
        return this.querySubmitter;
    }

    public DeploymentCategory getDeploymentCategory() {
        return IsisContext.getDeploymentType().getDeploymentCategory();
    }

    private static PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    private static AdapterManager getRuntimeAdapterManager() {
        return RuntimeContextFromSession.getPersistenceSession().getAdapterManager();
    }

    private static UpdateNotifier getUpdateNotifier() {
        return IsisContext.getUpdateNotifier();
    }

    private static IsisTransactionManager getTransactionManager() {
        return RuntimeContextFromSession.getPersistenceSession().getTransactionManager();
    }

    private static MessageBroker getMessageBroker() {
        return IsisContext.getMessageBroker();
    }

    public RuntimeContext.TransactionState getTransactionState() {
        IsisTransaction transaction = RuntimeContextFromSession.getTransactionManager().getTransaction();
        if (transaction == null) {
            return RuntimeContext.TransactionState.NONE;
        }
        IsisTransaction.State state = transaction.getState();
        return state.getRuntimeContextState();
    }
}

