/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.objectstore;

import java.util.List;
import org.apache.isis.core.commons.config.IsisConfigurationException;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.factory.InstanceCreationException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.persistence.ObjectPersistenceException;
import org.apache.isis.core.runtime.persistence.UnsupportedFindException;
import org.apache.isis.core.runtime.persistence.objectstore.ObjectStoreSpi;
import org.apache.isis.core.runtime.persistence.objectstore.Slf4jLogger;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;

public class IsisObjectStoreLogger
extends Slf4jLogger
implements ObjectStoreSpi {
    private final ObjectStoreSpi underlying;

    public IsisObjectStoreLogger(ObjectStoreSpi decorated, String level) {
        super(level);
        this.underlying = decorated;
    }

    public IsisObjectStoreLogger(ObjectStoreSpi decorated) {
        this.underlying = decorated;
    }

    @Override
    public CreateObjectCommand createCreateObjectCommand(ObjectAdapter object) {
        this.log("create object " + object);
        return this.underlying.createCreateObjectCommand(object);
    }

    @Override
    public void registerService(RootOid rootOid) {
        this.log("registering service: " + rootOid.enString(this.getOidMarshaller()));
        this.underlying.registerService(rootOid);
    }

    @Override
    public DestroyObjectCommand createDestroyObjectCommand(ObjectAdapter object) {
        this.log("destroy object " + object);
        return this.underlying.createDestroyObjectCommand(object);
    }

    @Override
    public SaveObjectCommand createSaveObjectCommand(ObjectAdapter object) {
        this.log("save object " + object);
        return this.underlying.createSaveObjectCommand(object);
    }

    public void debugData(DebugBuilder debug) {
        this.underlying.debugData(debug);
    }

    public String debugTitle() {
        return this.underlying.debugTitle();
    }

    @Override
    protected Class<?> getDecoratedClass() {
        return this.underlying.getClass();
    }

    @Override
    public List<ObjectAdapter> loadInstancesAndAdapt(PersistenceQuery criteria) throws ObjectPersistenceException, UnsupportedFindException {
        this.log("get instances matching " + criteria);
        return this.underlying.loadInstancesAndAdapt(criteria);
    }

    @Override
    public ObjectAdapter loadInstanceAndAdapt(TypedOid oid) throws ObjectNotFoundException, ObjectPersistenceException {
        ObjectAdapter adapter = this.underlying.loadInstanceAndAdapt(oid);
        this.log("get object for " + oid + " (of type '" + oid.getObjectSpecId() + "')", adapter.getObject());
        return adapter;
    }

    @Override
    public RootOid getOidForService(ObjectSpecification serviceSpec) {
        RootOid serviceOid = this.underlying.getOidForService(serviceSpec);
        if (serviceOid != null) {
            this.log("get OID for service: " + serviceOid.enString(this.getOidMarshaller()));
        } else {
            this.log("get OID for service: null (presumably in the process of being registered for '" + serviceSpec.getSpecId() + "')");
        }
        return serviceOid;
    }

    @Override
    public boolean hasInstances(ObjectSpecification specification) throws ObjectPersistenceException {
        boolean hasInstances = this.underlying.hasInstances(specification);
        this.log("has instances of " + specification.getShortIdentifier(), "" + hasInstances);
        return hasInstances;
    }

    @Override
    public boolean isFixturesInstalled() {
        boolean isInitialized = this.underlying.isFixturesInstalled();
        this.log("is initialized: " + isInitialized);
        return isInitialized;
    }

    public void open() throws IsisConfigurationException, InstanceCreationException, ObjectPersistenceException {
        this.log("opening " + this.name());
        this.underlying.open();
    }

    @Override
    public String name() {
        return this.underlying.name();
    }

    @Override
    public void reset() {
        this.log("reset");
        this.underlying.reset();
    }

    @Override
    public void resolveField(ObjectAdapter object, ObjectAssociation field) throws ObjectPersistenceException {
        this.log("resolve eagerly object in field " + field + " of " + object);
        this.underlying.resolveField(object, field);
    }

    @Override
    public void resolveImmediately(ObjectAdapter object) throws ObjectPersistenceException {
        this.log("resolve immediately: " + object);
        this.underlying.resolveImmediately(object);
    }

    @Override
    public void execute(List<PersistenceCommand> commands) throws ObjectPersistenceException {
        this.log("execute commands");
        int i = 0;
        for (PersistenceCommand command : commands) {
            this.log("  " + i++ + " " + command);
        }
        this.underlying.execute(commands);
    }

    public void close() throws ObjectPersistenceException {
        this.log("closing " + this.underlying);
        this.underlying.close();
    }

    @Override
    public void startTransaction() {
        this.underlying.startTransaction();
    }

    @Override
    public void endTransaction() {
        this.underlying.endTransaction();
    }

    @Override
    public void abortTransaction() {
        this.underlying.abortTransaction();
    }

    protected OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }
}

