/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.objectstore.algorithm;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.persistence.NotPersistableException;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.PersistAlgorithm;

public abstract class PersistAlgorithmAbstract
implements PersistAlgorithm {
    public void init() {
    }

    public void shutdown() {
    }

    protected static boolean alreadyPersistedOrNotPersistableOrServiceOrStandalone(ObjectAdapter adapter) {
        return adapter.isValue() || PersistAlgorithmAbstract.objectSpecIsService(adapter) || PersistAlgorithmAbstract.alreadyPersistedOrNotPersistable(adapter);
    }

    protected static boolean alreadyPersistedOrNotPersistable(ObjectAdapter adapter) {
        return adapter.representsPersistent() || PersistAlgorithmAbstract.objectSpecNotPersistable(adapter);
    }

    protected static void assertObjectNotPersistentAndPersistable(ObjectAdapter object) {
        if (PersistAlgorithmAbstract.alreadyPersistedOrNotPersistable(object)) {
            throw new NotPersistableException("can't make object persistent - either already persistent, or transient only: " + object);
        }
    }

    private static boolean objectSpecNotPersistable(ObjectAdapter adapter) {
        return !adapter.getSpecification().persistability().isPersistable() || adapter.isParented();
    }

    private static boolean objectSpecIsService(ObjectAdapter adapter) {
        return adapter.getSpecification().isService();
    }
}

