/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.runner;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderPrimer;
import org.apache.isis.core.runtime.installerregistry.InstallerLookup;
import org.apache.isis.core.runtime.installers.InstallerLookupDefault;
import org.apache.isis.core.runtime.logging.IsisLoggingConfigurer;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandler;
import org.apache.isis.core.runtime.runner.IsisBootstrapper;
import org.apache.isis.core.runtime.runner.IsisInjectModule;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerAdditionalProperty;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerConfiguration;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerDebug;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerDeploymentType;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerDiagnostics;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerFixture;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerHelp;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerNoSplash;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerPersistor;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerQuiet;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerReflector;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerUserProfileStore;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerVerbose;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerVersion;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerViewer;
import org.apache.isis.core.runtime.runner.opts.OptionValidator;
import org.apache.isis.core.runtime.runner.opts.OptionValidatorForViewers;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisRunner {
    private static final Logger LOG = LoggerFactory.getLogger(IsisRunner.class);
    private final IsisLoggingConfigurer loggingConfigurer = new IsisLoggingConfigurer();
    private final String[] args;
    private final OptionHandlerDeploymentType optionHandlerDeploymentType;
    private final InstallerLookup installerLookup;
    private final OptionHandlerViewer optionHandlerViewer;
    private final List<OptionHandler> optionHandlers = Lists.newArrayList();
    private final List<OptionValidator> validators = Lists.newArrayList();
    private IsisConfigurationBuilder isisConfigurationBuilder;
    private Injector globalInjector;

    public IsisRunner(String[] args, OptionHandlerDeploymentType optionHandlerDeploymentType) {
        this.args = args;
        this.optionHandlerDeploymentType = optionHandlerDeploymentType;
        this.loggingConfigurer.configureLogging(this.determineConfigDirectory(), args);
        this.installerLookup = new InstallerLookupDefault();
        this.optionHandlerViewer = this.addStandardOptionHandlersAndValidators(this.installerLookup);
    }

    private String determineConfigDirectory() {
        if (new File("src/main/webapp/WEB-INF").exists()) {
            return "src/main/webapp/WEB-INF";
        }
        return "config";
    }

    public final boolean addOptionHandler(OptionHandler optionHandler) {
        return this.optionHandlers.add(optionHandler);
    }

    public void addValidator(OptionValidator validator) {
        this.validators.add(validator);
    }

    public void setConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        this.isisConfigurationBuilder = isisConfigurationBuilder;
    }

    public final boolean parseAndValidate() {
        BootPrinter printer;
        Options options = this.createOptions();
        return this.parseOptions(options, printer = new BootPrinter(this.getClass())) && this.validateOptions(options, printer);
    }

    private Options createOptions() {
        Options options = new Options();
        for (OptionHandler optionHandler : this.optionHandlers) {
            optionHandler.addOption(options);
        }
        return options;
    }

    private boolean parseOptions(Options options, BootPrinter printer) {
        BasicParser parser = new BasicParser();
        try {
            CommandLine commandLine = parser.parse(options, this.args);
            for (OptionHandler optionHandler : this.optionHandlers) {
                if (optionHandler.handle(commandLine, printer, options)) continue;
                return false;
            }
        }
        catch (ParseException e) {
            printer.printErrorMessage(e.getMessage());
            printer.printHelp(options);
            return false;
        }
        return true;
    }

    private boolean validateOptions(Options options, BootPrinter printer) {
        DeploymentType deploymentType = this.optionHandlerDeploymentType.getDeploymentType();
        for (OptionValidator validator : this.validators) {
            Optional<String> errorMessage = validator.validate(deploymentType);
            if (!errorMessage.isPresent()) continue;
            printer.printErrorAndHelp(options, (String)errorMessage.get(), new Object[0]);
            return false;
        }
        return true;
    }

    public IsisConfigurationBuilder getStartupConfiguration() {
        return this.isisConfigurationBuilder;
    }

    public void primeConfigurationWithCommandLineOptions() {
        for (IsisConfigurationBuilderPrimer isisConfigurationBuilderPrimer : this.optionHandlers) {
            LOG.debug("priming configurations for " + isisConfigurationBuilderPrimer);
            isisConfigurationBuilderPrimer.primeConfigurationBuilder(this.isisConfigurationBuilder);
        }
    }

    public void loadInitialProperties() {
        this.isisConfigurationBuilder.addDefaultConfigurationResources();
    }

    public final void bootstrap(IsisBootstrapper bootstrapper) {
        DeploymentType deploymentType = this.optionHandlerDeploymentType.getDeploymentType();
        this.globalInjector = this.createGuiceInjector(deploymentType, this.isisConfigurationBuilder, this.installerLookup, this.optionHandlers);
        bootstrapper.bootstrap(this.globalInjector);
        this.isisConfigurationBuilder.lockConfiguration();
        this.isisConfigurationBuilder.dumpResourcesToLog();
    }

    private Injector createGuiceInjector(DeploymentType deploymentType, IsisConfigurationBuilder isisConfigurationBuilder, InstallerLookup installerLookup, List<OptionHandler> optionHandlers) {
        IsisInjectModule isisModule = new IsisInjectModule(deploymentType, isisConfigurationBuilder, installerLookup);
        isisModule.addViewerNames(this.optionHandlerViewer.getViewerNames());
        return Guice.createInjector((Module[])new Module[]{isisModule});
    }

    public final List<OptionHandler> getOptionHandlers() {
        return Collections.unmodifiableList(this.optionHandlers);
    }

    private OptionHandlerViewer addStandardOptionHandlersAndValidators(InstallerLookup installerLookup) {
        this.addOptionHandler((OptionHandler)this.optionHandlerDeploymentType);
        this.addOptionHandler((OptionHandler)new OptionHandlerConfiguration());
        OptionHandlerPersistor optionHandlerPersistor = new OptionHandlerPersistor(installerLookup);
        this.addOptionHandler((OptionHandler)optionHandlerPersistor);
        OptionHandlerViewer optionHandlerViewer = new OptionHandlerViewer(installerLookup);
        this.addOptionHandler((OptionHandler)optionHandlerViewer);
        this.addOptionHandler((OptionHandler)new OptionHandlerReflector(installerLookup));
        this.addOptionHandler((OptionHandler)new OptionHandlerUserProfileStore(installerLookup));
        this.addOptionHandler((OptionHandler)new OptionHandlerFixture());
        this.addOptionHandler((OptionHandler)new OptionHandlerNoSplash());
        this.addOptionHandler((OptionHandler)new OptionHandlerAdditionalProperty());
        this.addOptionHandler((OptionHandler)new OptionHandlerDebug());
        this.addOptionHandler((OptionHandler)new OptionHandlerDiagnostics());
        this.addOptionHandler((OptionHandler)new OptionHandlerQuiet());
        this.addOptionHandler((OptionHandler)new OptionHandlerVerbose());
        this.addOptionHandler((OptionHandler)new OptionHandlerHelp());
        this.addOptionHandler((OptionHandler)new OptionHandlerVersion());
        this.addValidator(new OptionValidatorForViewers(optionHandlerViewer));
        return optionHandlerViewer;
    }
}

