/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.runner.opts;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorInstaller;
import org.apache.isis.core.runtime.installerregistry.InstallerRepository;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandlerAbstract;

public class OptionHandlerReflector
extends OptionHandlerAbstract {
    private final InstallerRepository installerRepository;
    private String reflector;

    public OptionHandlerReflector(InstallerRepository installerRepository) {
        this.installerRepository = installerRepository;
    }

    public void addOption(Options options) {
        Object[] reflectors = this.installerRepository.getInstallers(ObjectReflectorInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"reflector");
        OptionBuilder.withDescription((String)("reflector to use (ignored if type is prototype or client): " + this.availableInstallers(reflectors) + "; or class name"));
        Option option = OptionBuilder.create((String)"l");
        options.addOption(option);
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.reflector = commandLine.getOptionValue("l");
        return true;
    }

    public void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        isisConfigurationBuilder.add("isis.reflector", this.reflector);
    }
}

