/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.runner.opts;

import com.google.common.base.Optional;
import java.util.List;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerViewer;
import org.apache.isis.core.runtime.runner.opts.OptionValidator;
import org.apache.isis.core.runtime.runner.opts.Strings;
import org.apache.isis.core.runtime.system.DeploymentType;

public final class OptionValidatorForViewers
implements OptionValidator {
    private final OptionHandlerViewer optionHandlerViewer;

    public OptionValidatorForViewers(OptionHandlerViewer optionHandlerViewer) {
        this.optionHandlerViewer = optionHandlerViewer;
    }

    @Override
    public Optional<String> validate(DeploymentType deploymentType) {
        List<String> viewerNames = this.optionHandlerViewer.getViewerNames();
        boolean fail = !deploymentType.canSpecifyViewers(viewerNames);
        String failMsg = String.format("Error: cannot specify %s viewer%s for deployment type %s\n", Strings.plural(viewerNames, "more than one", "any"), Strings.plural(viewerNames, "", "s"), deploymentType.nameLowerCase());
        return OptionValidatorForViewers.setIf(fail, failMsg);
    }

    private static Optional<String> setIf(boolean fail, String failMsg) {
        return fail ? Optional.of((Object)failMsg) : Optional.absent();
    }
}

