/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindByTitle;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.core.runtime.system.persistence.Persistor;

public final class RepositoryHelper {
    private RepositoryHelper() {
    }

    public static Object[] allInstances(Class<?> cls) {
        return RepositoryHelper.allInstances(RepositoryHelper.getSpecificationLoader().loadSpecification(cls), cls);
    }

    public static <T> Object[] allInstances(ObjectSpecification spec, Class<T> cls) {
        QueryFindAllInstances query = new QueryFindAllInstances(spec.getFullIdentifier(), new long[0]);
        ObjectAdapter instances = RepositoryHelper.getPersistenceSession().findInstances(query, QueryCardinality.MULTIPLE);
        Object[] array = RepositoryHelper.convertToArray(instances, cls);
        return array;
    }

    public static List<Object> findByPersistenceQuery(PersistenceQuery persistenceQuery, Class<?> cls) {
        ObjectAdapter instances = RepositoryHelper.getPersistenceSession().findInstances(persistenceQuery);
        return RepositoryHelper.convertToList(instances, cls);
    }

    public static List<Object> findByTitle(Class<?> type, String title) {
        ObjectSpecification spec = RepositoryHelper.getSpecificationLoader().loadSpecification(type);
        return RepositoryHelper.findByTitle(spec, type, title);
    }

    public static List<Object> findByTitle(ObjectSpecification spec, Class<?> cls, String title) {
        PersistenceQueryFindByTitle criteria = new PersistenceQueryFindByTitle(spec, title, new long[0]);
        return RepositoryHelper.findByPersistenceQuery(criteria, cls);
    }

    public static boolean hasInstances(Class<?> type) {
        ObjectSpecification spec = RepositoryHelper.getSpecificationLoader().loadSpecification(type);
        return RepositoryHelper.hasInstances(spec);
    }

    public static boolean hasInstances(ObjectSpecification spec) {
        return RepositoryHelper.getPersistenceSession().hasInstances(spec);
    }

    private static List<Object> convertToList(ObjectAdapter instances, Class<?> cls) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)instances);
        ArrayList<Object> list = new ArrayList<Object>();
        for (ObjectAdapter adapter : facet.iterable(instances)) {
            list.add(adapter.getObject());
        }
        return list;
    }

    private static Object[] convertToArray(ObjectAdapter instances, Class<?> cls) {
        return RepositoryHelper.convertToList(instances, cls).toArray();
    }

    private static Persistor getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    private static SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

