/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import java.lang.reflect.Method;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.RequestScoped;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.factory.InstanceCreationClassException;
import org.apache.isis.core.commons.factory.InstanceCreationException;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.JavassistEnhanced;
import org.apache.isis.core.runtime.services.RequestScopedService;

public final class ServiceInstantiator {
    public <T> T createInstance(Class<T> cls) {
        if (cls.isAnnotationPresent(RequestScoped.class)) {
            return this.instantiateRequestScopedProxy(cls);
        }
        return ServiceInstantiator.instantiateSingleton(cls);
    }

    private static <T> T instantiateSingleton(Class<T> cls) {
        return ServiceInstantiator.instantiate(cls);
    }

    private <T> T instantiateRequestScopedProxy(final Class<T> cls) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(cls);
        proxyFactory.setInterfaces((Class[])ArrayExtensions.combine((Object[][])new Class[][]{cls.getInterfaces(), {RequestScopedService.class, JavassistEnhanced.class}}));
        proxyFactory.setFilter(new MethodFilter(){

            public boolean isHandled(Method m) {
                return !m.getName().equals("finalize");
            }
        });
        Class proxySubclass = proxyFactory.createClass();
        try {
            Object newInstance = proxySubclass.newInstance();
            ProxyObject proxyObject = (ProxyObject)newInstance;
            proxyObject.setHandler(new MethodHandler(){
                private ThreadLocal<T> serviceByThread = new ThreadLocal();

                public Object invoke(Object proxied, Method proxyMethod, Method proxiedMethod, Object[] args) throws Throwable {
                    if (proxyMethod.getName().equals("__isis_startRequest")) {
                        Object service = ServiceInstantiator.instantiate(cls);
                        this.serviceByThread.set(service);
                        return null;
                    }
                    if (proxyMethod.getName().equals("__isis_endRequest")) {
                        this.serviceByThread.set(null);
                        return null;
                    }
                    Object service = this.serviceByThread.get();
                    if (service == null) {
                        throw new IllegalStateException("No service found for thread; make sure ((RequestScopedService)service).__isis_startRequest() is called first");
                    }
                    Object proxiedReturn = proxyMethod.invoke(service, args);
                    return proxiedReturn;
                }
            });
            return newInstance;
        }
        catch (InstantiationException e) {
            throw new IsisException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new IsisException((Throwable)e);
        }
    }

    private static <T> T instantiate(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException("Class found '" + cls + "', but is missing a dependent class", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new InstanceCreationException("Could not instantiate an object of class '" + cls.getName() + "'; " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new InstanceCreationException("Could not access the class '" + cls.getName() + "'; " + e.getMessage());
        }
    }
}

