/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.isis.core.commons.config.InstallerAbstract;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.runtime.services.ServicesInstaller;
import org.apache.isis.core.runtime.services.SimpleRepository;
import org.apache.isis.core.runtime.system.DeploymentType;

public abstract class ServicesInstallerAbstract
extends InstallerAbstract
implements ServicesInstaller {
    private final List<Object> services = new ArrayList<Object>();

    public ServicesInstallerAbstract(String name) {
        super("services-installer", name);
    }

    public void addService(Object service) {
        if (service instanceof Collection) {
            Collection services = ObjectExtensions.asCollectionT((Object)service, Object.class);
            for (Object eachService : services) {
                this.addService(eachService);
            }
        } else {
            this.services.add(service);
        }
    }

    public void addSimpleRepository(Class<?> cls) {
        this.addService(new SimpleRepository(cls));
    }

    @Override
    public List<Object> getServices(DeploymentType deploymentType) {
        return this.services;
    }

    public void addServices(List<Object> services) {
        this.addService(services);
    }

    public void removeService(Object service) {
        this.services.remove(service);
    }
}

