/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.core.commons.config.InstallerAbstract;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.fixturedomainservice.ObjectFixtureService;
import org.apache.isis.core.runtime.services.InitialisationException;
import org.apache.isis.core.runtime.services.ServiceInstantiator;
import org.apache.isis.core.runtime.services.ServicesInstaller;
import org.apache.isis.core.runtime.services.SimpleRepository;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesInstallerFromConfiguration
extends InstallerAbstract
implements ServicesInstaller {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesInstallerFromConfiguration.class);
    private static final String SERVICES = "services";
    private static final String EXPLORATION_OBJECTS = "exploration-objects";
    private static final String SERVICES_PREFIX = "services.prefix";
    private static final char DELIMITER = '#';
    private final ServiceInstantiator serviceInstantiator;
    private static final Pattern regex = Pattern.compile("((\\d+):)(.*)");

    public ServicesInstallerFromConfiguration() {
        this(new ServiceInstantiator());
    }

    ServicesInstallerFromConfiguration(ServiceInstantiator serviceInstantiator) {
        super("services-installer", "configuration");
        this.serviceInstantiator = serviceInstantiator;
    }

    @Override
    public List<Object> getServices(DeploymentType deploymentType) {
        LOG.info("installing " + this.getClass().getName());
        ArrayList serviceList = Lists.newArrayList();
        this.appendServices(this.getConfiguration(), null, serviceList);
        this.appendServices(this.getConfiguration(), deploymentType.name(), serviceList);
        if (serviceList.size() == 0) {
            throw new InitialisationException("No services specified");
        }
        return Collections.unmodifiableList(serviceList);
    }

    private void appendServices(IsisConfiguration configuration, String group, List<Object> listOfServices) {
        String root = "isis." + (group == null ? "" : group.toLowerCase() + ".");
        String servicePrefix = configuration.getString(root + SERVICES_PREFIX);
        if (group != null && servicePrefix == null) {
            servicePrefix = configuration.getString("isis.services.prefix");
        }
        String prefix = ServicesInstallerFromConfiguration.servicePrefix(servicePrefix);
        String configuredServices = configuration.getString(root + SERVICES);
        this.appendConfiguredServices(prefix, configuredServices, listOfServices);
        this.appendObjectFixtureService(configuration, root, listOfServices);
    }

    private void appendConfiguredServices(String servicePrefix, String configuredServices, List<Object> serviceList) {
        if (configuredServices == null) {
            return;
        }
        TreeMap positionedServices = Maps.newTreeMap();
        StringTokenizer services = new StringTokenizer(configuredServices, ",");
        if (!services.hasMoreTokens()) {
            throw new InitialisationException("Services specified, but none loaded");
        }
        while (services.hasMoreTokens()) {
            List list;
            String serviceName = services.nextToken().trim();
            if (serviceName.equals("")) continue;
            Matcher matcher = regex.matcher(serviceName);
            Integer order = Integer.MAX_VALUE;
            if (matcher.matches()) {
                order = Integer.parseInt(matcher.group(2));
                serviceName = matcher.group(3);
            }
            if ((list = (List)positionedServices.get(order)) == null) {
                list = Lists.newArrayList();
                positionedServices.put(order, list);
            }
            LOG.info("creating service " + serviceName + (order != Integer.MAX_VALUE ? " at position " + order : ""));
            Object service = this.instantiateService(servicePrefix, serviceName);
            if (service == null) continue;
            list.add(service);
        }
        for (Integer position : positionedServices.keySet()) {
            List list = (List)positionedServices.get(position);
            serviceList.addAll(list);
        }
    }

    private Object instantiateService(String servicePrefix, String serviceName) {
        int pos = serviceName.indexOf(35);
        if (pos == 0) {
            return null;
        }
        if (pos != -1) {
            String type = serviceName.substring(0, pos);
            if ("repository".equals(type)) {
                String className = servicePrefix + serviceName.substring(pos + 1);
                Class<?> underlying = ServicesInstallerFromConfiguration.loadClass(className);
                return new SimpleRepository(underlying);
            }
            Class<?> cls = ServicesInstallerFromConfiguration.loadClass(type);
            return this.serviceInstantiator.createInstance(cls);
        }
        Class<?> cls = ServicesInstallerFromConfiguration.loadClass(servicePrefix + serviceName);
        return this.serviceInstantiator.createInstance(cls);
    }

    private void appendObjectFixtureService(IsisConfiguration configuration, String root, List<Object> serviceList) {
        DeploymentType deploymentType;
        if (configuration.getBoolean(root + EXPLORATION_OBJECTS) && (deploymentType = DeploymentType.lookup(configuration.getString("isis.deploymentType"))).isExploring()) {
            serviceList.add(new ObjectFixtureService());
        }
    }

    private static String servicePrefix(String servicePrefix) {
        String prefix;
        String string = prefix = servicePrefix == null ? "" : servicePrefix.trim();
        if (prefix.length() > 0 && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        return prefix;
    }

    private static Class<?> loadClass(String className) {
        try {
            LOG.debug("loading class for service: " + className);
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new InitialisationException(String.format("Cannot find class '%s' for service", className));
        }
    }

    public List<Class<?>> getTypes() {
        return ServicesInstallerFromConfiguration.listOf((Class[])new Class[]{List.class});
    }
}

