/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.background;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.services.background.ActionInvocationMemento;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.memento.MementoService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.progmodel.facets.actions.invoke.CommandUtil;
import org.apache.isis.core.runtime.services.memento.MementoServiceDefault;
import org.apache.isis.core.runtime.sessiontemplate.AbstractIsisSessionTemplate;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosureAbstract;

public abstract class BackgroundCommandExecution
extends AbstractIsisSessionTemplate {
    private final MementoServiceDefault mementoService = new MementoServiceDefault().withNoEncoding();
    @Inject
    private BookmarkService bookmarkService;
    @Inject
    private CommandContext commandContext;

    @Override
    protected void doExecute(Object context) {
        PersistenceSession persistenceSession = this.getPersistenceSession();
        IsisTransactionManager transactionManager = this.getTransactionManager(persistenceSession);
        final ArrayList commands = Lists.newArrayList();
        transactionManager.executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void execute() {
                commands.addAll(BackgroundCommandExecution.this.findBackgroundCommandsToExecute());
            }
        });
        for (Command command : commands) {
            this.execute(transactionManager, command);
        }
    }

    protected abstract List<? extends Command> findBackgroundCommandsToExecute();

    private void execute(IsisTransactionManager transactionManager, final Command command) {
        this.commandContext.setCommand(command);
        transactionManager.executeWithinTransaction(new TransactionalClosureAbstract(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                try {
                    command.setStartedAt(Clock.getTimeAsJavaSqlTimestamp());
                    command.setExecutor(Command.Executor.BACKGROUND);
                    String memento = command.getMemento();
                    ActionInvocationMemento aim = new ActionInvocationMemento((MementoService)BackgroundCommandExecution.this.mementoService, memento);
                    String actionId = aim.getActionId();
                    Bookmark targetBookmark = aim.getTarget();
                    Object targetObject = BackgroundCommandExecution.this.bookmarkService.lookup(targetBookmark);
                    ObjectAdapter targetAdapter = BackgroundCommandExecution.this.adapterFor(targetObject);
                    ObjectSpecification specification = targetAdapter.getSpecification();
                    ObjectAction objectAction = BackgroundCommandExecution.this.findAction(specification, actionId);
                    if (objectAction == null) {
                        throw new Exception("Unknown action '" + actionId + "'");
                    }
                    ObjectAdapter[] argAdapters = BackgroundCommandExecution.this.argAdaptersFor(aim);
                    ObjectAdapter resultAdapter = objectAction.execute(targetAdapter, argAdapters);
                    if (resultAdapter != null) {
                        Bookmark resultBookmark = CommandUtil.bookmarkFor((ObjectAdapter)resultAdapter);
                        command.setResult(resultBookmark);
                    }
                }
                catch (Exception e) {
                    command.setException(Throwables.getStackTraceAsString((Throwable)e));
                }
                finally {
                    command.setCompletedAt(Clock.getTimeAsJavaSqlTimestamp());
                }
            }
        });
    }

    private ObjectAction findAction(ObjectSpecification specification, String actionId) {
        List objectActions = specification.getObjectActions(Contributed.INCLUDED);
        for (ObjectAction objectAction : objectActions) {
            if (!objectAction.getIdentifier().toClassAndNameIdentityString().equals(actionId)) continue;
            return objectAction;
        }
        return null;
    }

    private ObjectAdapter[] argAdaptersFor(ActionInvocationMemento aim) throws ClassNotFoundException {
        int numArgs = aim.getNumArgs();
        ArrayList argumentAdapters = Lists.newArrayList();
        for (int i = 0; i < numArgs; ++i) {
            ObjectAdapter argAdapter = this.argAdapterFor(aim, i);
            argumentAdapters.add(argAdapter);
        }
        return argumentAdapters.toArray(new ObjectAdapter[0]);
    }

    private ObjectAdapter argAdapterFor(ActionInvocationMemento aim, int num) throws ClassNotFoundException {
        Class argType = aim.getArgType(num);
        Object arg = aim.getArg(num, argType);
        if (arg == null) {
            return null;
        }
        if (Bookmark.class != argType) {
            return this.adapterFor(arg);
        }
        Bookmark argBookmark = (Bookmark)arg;
        RootOid rootOid = RootOidDefault.create((Bookmark)argBookmark);
        return this.adapterFor(rootOid);
    }
}

