/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.background;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.annotation.PostConstruct;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.background.ActionInvocationMemento;
import org.apache.isis.applib.services.background.BackgroundCommandService;
import org.apache.isis.applib.services.background.BackgroundService;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.memento.MementoService;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.JavassistEnhanced;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.core.progmodel.facets.actions.invoke.CommandUtil;
import org.apache.isis.core.runtime.services.memento.MementoServiceDefault;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class BackgroundServiceDefault
implements BackgroundService {
    private final MementoServiceDefault mementoService;
    private BookmarkService bookmarkService;
    private BackgroundCommandService backgroundCommandService;
    private CommandContext commandContext;

    public BackgroundServiceDefault() {
        this(new MementoServiceDefault());
    }

    BackgroundServiceDefault(MementoServiceDefault mementoService) {
        this.mementoService = mementoService.withNoEncoding();
    }

    @Programmatic
    @PostConstruct
    public void init(Map<String, String> props) {
        this.ensureDependenciesInjected();
    }

    private void ensureDependenciesInjected() {
        Ensure.ensureThatState((Object)this.bookmarkService, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"BookmarkService domain service must be configured");
        Ensure.ensureThatState((Object)this.backgroundCommandService, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"BackgroundCommandService domain service must be configured");
        Ensure.ensureThatState((Object)this.commandContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"CommandContext domain service must be configured");
    }

    private ObjectSpecificationDefault getJavaSpecificationOfOwningClass(Method method) {
        return this.getJavaSpecification(method.getDeclaringClass());
    }

    private ObjectSpecificationDefault getJavaSpecification(Class<?> cls) {
        ObjectSpecification objectSpec = this.getSpecification(cls);
        if (!(objectSpec instanceof ObjectSpecificationDefault)) {
            throw new UnsupportedOperationException("Only Java is supported (specification is '" + objectSpec.getClass().getCanonicalName() + "')");
        }
        return (ObjectSpecificationDefault)objectSpec;
    }

    private ObjectSpecification getSpecification(Class<?> type) {
        return this.getSpecificationLoader().loadSpecification(type);
    }

    @Programmatic
    public <T> T execute(T domainObject) {
        Class<?> cls = domainObject.getClass();
        MethodHandler methodHandler = this.newMethodHandler(domainObject);
        return this.newProxy(cls, methodHandler);
    }

    private <T> T newProxy(Class<? extends Object> cls, MethodHandler methodHandler) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(cls);
        proxyFactory.setInterfaces((Class[])ArrayExtensions.combine((Object[][])new Class[][]{cls.getInterfaces(), {JavassistEnhanced.class}}));
        proxyFactory.setFilter(new MethodFilter(){

            public boolean isHandled(Method m) {
                return !m.getName().equals("finalize");
            }
        });
        Class proxySubclass = proxyFactory.createClass();
        try {
            Object newInstance = proxySubclass.newInstance();
            ProxyObject proxyObject = (ProxyObject)newInstance;
            proxyObject.setHandler(methodHandler);
            return newInstance;
        }
        catch (InstantiationException e) {
            throw new IsisException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new IsisException((Throwable)e);
        }
    }

    private <T> MethodHandler newMethodHandler(final T domainObject) {
        return new MethodHandler(){

            public Object invoke(Object proxied, Method proxyMethod, Method proxiedMethod, Object[] args) throws Throwable {
                boolean inheritedFromObject = proxyMethod.getDeclaringClass().equals(Object.class);
                if (inheritedFromObject) {
                    return proxyMethod.invoke(domainObject, args);
                }
                ObjectAdapter targetAdapter = BackgroundServiceDefault.this.getAdapterManager().adapterFor(domainObject);
                ObjectSpecificationDefault targetObjSpec = BackgroundServiceDefault.this.getJavaSpecificationOfOwningClass(proxyMethod);
                ObjectMember member = targetObjSpec.getMember(proxyMethod);
                if (member == null) {
                    return proxyMethod.invoke(domainObject, args);
                }
                if (!(member instanceof ObjectAction)) {
                    throw new UnsupportedOperationException("Only actions can be executed in the background (method " + proxiedMethod.getName() + " represents a " + member.getFeatureType().name() + "')");
                }
                ObjectAction action = (ObjectAction)member;
                String actionIdentifier = CommandUtil.actionIdentifierFor((ObjectAction)action);
                String targetClassName = CommandUtil.targetClassNameFor((ObjectAdapter)targetAdapter);
                String targetActionName = CommandUtil.targetActionNameFor((ObjectAction)action);
                String targetArgs = CommandUtil.argDescriptionFor((ObjectAction)action, (ObjectAdapter[])this.adaptersFor(args));
                Bookmark domainObjectBookmark = BackgroundServiceDefault.this.bookmarkService.bookmarkFor(domainObject);
                ArrayList argTypes = Lists.newArrayList();
                ArrayList argObjs = Lists.newArrayList();
                CommandUtil.buildMementoArgLists((MementoService)BackgroundServiceDefault.this.mementoService, (BookmarkService)BackgroundServiceDefault.this.bookmarkService, (Method)proxiedMethod, (Object[])args, (List)argTypes, (List)argObjs);
                Command command = BackgroundServiceDefault.this.commandContext.getCommand();
                ActionInvocationMemento aim = new ActionInvocationMemento((MementoService)BackgroundServiceDefault.this.mementoService, actionIdentifier, domainObjectBookmark, (List)argTypes, (List)argObjs);
                BackgroundServiceDefault.this.backgroundCommandService.schedule(aim, command, targetClassName, targetActionName, targetArgs);
                return null;
            }

            ObjectAdapter[] adaptersFor(Object[] args) {
                AdapterManager adapterManager = BackgroundServiceDefault.this.getAdapterManager();
                return CommandUtil.adaptersFor((Object[])args, (AdapterManager)adapterManager);
            }
        };
    }

    public ActionInvocationMemento asActionInvocationMemento(Method method, Object domainObject, Object[] args) {
        ObjectSpecificationDefault targetObjSpec = this.getJavaSpecificationOfOwningClass(method);
        ObjectMember member = targetObjSpec.getMember(method);
        if (member == null) {
            return null;
        }
        if (!(member instanceof ObjectAction)) {
            return null;
        }
        ObjectAction action = (ObjectAction)member;
        String actionIdentifier = CommandUtil.actionIdentifierFor((ObjectAction)action);
        Bookmark domainObjectBookmark = this.bookmarkService.bookmarkFor(domainObject);
        ArrayList argTypes = Lists.newArrayList();
        ArrayList argObjs = Lists.newArrayList();
        CommandUtil.buildMementoArgLists((MementoService)this.mementoService, (BookmarkService)this.bookmarkService, (Method)method, (Object[])args, (List)argTypes, (List)argObjs);
        ActionInvocationMemento aim = new ActionInvocationMemento((MementoService)this.mementoService, actionIdentifier, domainObjectBookmark, (List)argTypes, (List)argObjs);
        return aim;
    }

    ActionInvocationMemento newActionInvocationMemento(String mementoStr) {
        return new ActionInvocationMemento((MementoService)this.mementoService, mementoStr);
    }

    public void injectBookmarkService(BookmarkService bookmarkService) {
        this.bookmarkService = bookmarkService;
    }

    public void injectBackgroundCommandService(BackgroundCommandService backgroundCommandService) {
        this.backgroundCommandService = backgroundCommandService;
    }

    public void injectCommandContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    protected AdapterManager getAdapterManager() {
        return IsisContext.getPersistenceSession().getAdapterManager();
    }
}

