/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.eventbus;

import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.Set;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.core.runtime.system.context.IsisContext;

public class EventBusServiceDefault
extends EventBusService {
    private final Set<Object> objectsToRegister = Sets.newHashSet();

    protected EventBus getEventBus() {
        return IsisContext.getSession().getEventBus();
    }

    public void register(Object domainObject) {
        this.objectsToRegister.add(domainObject);
    }

    public void unregister(Object domainObject) {
        if (IsisContext.inSession()) {
            this.getEventBus().unregister(domainObject);
        }
        this.objectsToRegister.remove(domainObject);
    }

    public void open() {
        for (Object object : this.objectsToRegister) {
            this.getEventBus().register(object);
        }
    }

    public void close() {
        for (Object object : this.objectsToRegister) {
            this.getEventBus().unregister(object);
        }
    }
}

