/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.memento;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.joda.time.LocalDate;

class Dom4jUtil {
    private static final String NULL_MARKER = "$$_isis_null_value_$$";

    private Dom4jUtil() {
    }

    static void addChild(Element el, String name, Object value) {
        el.addElement(name).setText(Dom4jUtil.encodeForNulls(value));
    }

    static boolean isSupportedClass(Class<?> cls) {
        return Parseable.isSupported(cls);
    }

    static <T> T getChild(Element el, String name, Class<T> cls) {
        Parseable.assertSupported(cls);
        Element child = el.element(name);
        if (child == null) {
            return null;
        }
        String str = Dom4jUtil.decodeForNulls(child.getText());
        if (str == null) {
            return null;
        }
        return Parseable.parse(str, cls);
    }

    static Document parse(String xmlStr) {
        try {
            SAXReader saxReader = new SAXReader();
            Document doc = saxReader.read((Reader)new StringReader(xmlStr));
            return doc;
        }
        catch (DocumentException e) {
            throw new IsisException((Throwable)e);
        }
    }

    static String asString(Document doc) {
        XMLWriter writer = null;
        StringWriter sw = new StringWriter();
        try {
            writer = new XMLWriter((Writer)sw);
            writer.write(doc);
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw new IsisException((Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static String encodeForNulls(Object value) {
        return value != null ? value.toString() : NULL_MARKER;
    }

    private static String decodeForNulls(String valueStr) {
        return NULL_MARKER.equals(valueStr) ? null : valueStr;
    }

    static enum Parseable {
        STRING(new Class[]{String.class}){

            @Override
            public <T> T parseStr(String str, Class<T> cls) {
                return (T)str;
            }
        }
        ,
        BOOLEAN(new Class[]{Boolean.class, Boolean.TYPE}){

            @Override
            public <T> T parseStr(String str, Class<T> cls) {
                return (T)new Boolean(str);
            }
        }
        ,
        BYTE(new Class[]{Byte.class, Byte.TYPE}){

            @Override
            public <T> T parseStr(String str, Class<T> cls) {
                return (T)new Byte(str);
            }
        }
        ,
        SHORT(new Class[]{Short.class, Short.TYPE}){

            @Override
            <T> T parseStr(String str, Class<T> cls) {
                return (T)new Short(str);
            }
        }
        ,
        INTEGER(new Class[]{Integer.class, Integer.TYPE}){

            @Override
            <T> T parseStr(String str, Class<T> cls) {
                return (T)new Integer(str);
            }
        }
        ,
        LONG(new Class[]{Long.class, Long.TYPE}){

            @Override
            <T> T parseStr(String str, Class<T> cls) {
                return (T)new Long(str);
            }
        }
        ,
        FLOAT(new Class[]{Float.class, Float.TYPE}){

            @Override
            <T> T parseStr(String str, Class<T> cls) {
                return (T)new Float(str);
            }
        }
        ,
        DOUBLE(new Class[]{Double.class, Double.TYPE}){

            @Override
            <T> T parseStr(String str, Class<T> cls) {
                return (T)new Double(str);
            }
        }
        ,
        BIG_DECIMAL(new Class[]{BigDecimal.class}){

            @Override
            <T> T parseStr(String str, Class<T> cls) {
                return (T)new BigDecimal(str);
            }
        }
        ,
        BIG_INTEGER(new Class[]{BigInteger.class}){

            @Override
            <T> T parseStr(String str, Class<T> cls) {
                return (T)new BigInteger(str);
            }
        }
        ,
        LOCAL_DATE(new Class[]{LocalDate.class}){

            @Override
            <T> T parseStr(String str, Class<T> cls) {
                return (T)new LocalDate((Object)str);
            }
        }
        ,
        ENUM(new Class[]{Enum.class}){

            @Override
            <T> T parseStr(String str, Class<T> cls) {
                Class<T> rawCls = cls;
                return this.valueOf(str, rawCls);
            }

            private <E extends Enum<E>> E valueOf(String name, Class<E> cls) {
                return Enum.valueOf(cls, name);
            }
        }
        ,
        BOOKMARK(new Class[]{Bookmark.class}){

            @Override
            <T> T parseStr(String str, Class<T> cls) {
                return (T)new Bookmark(str);
            }
        };

        private final Class<?>[] classes;

        private Parseable(Class<?> ... classes) {
            this.classes = classes;
        }

        public Class<?>[] getClasses() {
            return this.classes;
        }

        abstract <T> T parseStr(String var1, Class<T> var2);

        static <T> T parse(String str, Class<?> cls) {
            Parseable.assertSupported(cls);
            for (Parseable sc : Parseable.values()) {
                for (Class<?> eachCls : sc.getClasses()) {
                    if (!eachCls.isAssignableFrom(cls) || eachCls.isPrimitive() && str == null) continue;
                    return (T)sc.parseStr(str, cls);
                }
            }
            return null;
        }

        static boolean isSupported(Class<?> cls) {
            for (Parseable sc : Parseable.values()) {
                for (Class<?> eachCls : sc.getClasses()) {
                    if (!eachCls.isAssignableFrom(cls)) continue;
                    return true;
                }
            }
            return false;
        }

        static void assertSupported(Class<?> cls) {
            if (!Parseable.isSupported(cls)) {
                throw new IllegalArgumentException("Parsing string to type " + cls.getName() + " is not supported");
            }
        }
    }
}

