/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.memento;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.memento.MementoService;
import org.apache.isis.core.runtime.services.memento.Dom4jUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MementoServiceDefault
implements MementoService {
    private boolean noEncoding = false;

    @Programmatic
    public MementoServiceDefault withNoEncoding() {
        this.noEncoding = true;
        return this;
    }

    public MementoService.Memento create() {
        return new MementoDefault(this.noEncoding);
    }

    public MementoService.Memento parse(String str) {
        String xmlStr = this.noEncoding ? str : MementoServiceDefault.base64UrlDecode(str);
        Document doc = Dom4jUtil.parse(xmlStr);
        return new MementoDefault(doc, this.noEncoding);
    }

    public boolean canSet(Object input) {
        return input != null ? Dom4jUtil.isSupportedClass(input.getClass()) : true;
    }

    private static String base64UrlDecode(String str) {
        byte[] bytes = BaseEncoding.base64Url().decode((CharSequence)str);
        return new String(bytes, Charset.forName("UTF-8"));
    }

    private static String base64UrlEncode(String xmlStr) {
        byte[] bytes = xmlStr.getBytes(Charset.forName("UTF-8"));
        return BaseEncoding.base64Url().encode(bytes);
    }

    static class MementoDefault
    implements MementoService.Memento {
        private final boolean noEncoding;
        private final Document doc;
        private static final Function<Element, String> ELEMENT_NAME = new Function<Element, String>(){

            public String apply(Element input) {
                return input.getName();
            }
        };

        MementoDefault(boolean noEncoding) {
            this(DocumentHelper.createDocument(), noEncoding);
            this.doc.addElement("memento");
        }

        MementoDefault(Document doc, boolean noEncoding) {
            this.doc = doc;
            this.noEncoding = noEncoding;
        }

        public MementoService.Memento set(String name, Object value) {
            Element el = this.doc.getRootElement();
            Dom4jUtil.addChild(el, name, value);
            return this;
        }

        public <T> T get(String name, Class<T> cls) {
            Element el = this.doc.getRootElement();
            return Dom4jUtil.getChild(el, name, cls);
        }

        public String asString() {
            String xmlStr = Dom4jUtil.asString(this.doc);
            return this.encode(xmlStr);
        }

        protected String encode(String xmlStr) {
            return this.noEncoding ? xmlStr : MementoServiceDefault.base64UrlEncode(xmlStr);
        }

        public Set<String> keySet() {
            Element element = this.doc.getRootElement();
            List elements = element.elements();
            return Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)elements, ELEMENT_NAME));
        }
    }
}

