/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.sessiontemplate;

import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;

public abstract class AbstractIsisSessionTemplate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AuthenticationSession authSession, Object context) {
        try {
            IsisContext.openSession(authSession);
            PersistenceSession persistenceSession = this.getPersistenceSession();
            persistenceSession.getServicesInjector().injectServicesInto((Object)this);
            this.doExecute(context);
        }
        finally {
            IsisContext.closeSession();
        }
    }

    protected abstract void doExecute(Object var1);

    protected ObjectAdapter adapterFor(Object targetObject) {
        return this.getAdapterManager().adapterFor(targetObject);
    }

    protected ObjectAdapter adapterFor(RootOid rootOid) {
        return this.getAdapterManager().adapterFor((TypedOid)rootOid);
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected IsisTransactionManager getTransactionManager(PersistenceSession persistenceSession) {
        return persistenceSession.getTransactionManager();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }
}

