/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.facetapi.ClassSubstitutorFactory;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.services.ServicesInjectorDefault;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.ServiceInitializer;
import org.apache.isis.core.runtime.about.AboutIsis;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.imageloader.TemplateImageLoader;
import org.apache.isis.core.runtime.imageloader.awt.TemplateImageLoaderAwt;
import org.apache.isis.core.runtime.persistence.PersistenceConstants;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.IsisSystem;
import org.apache.isis.core.runtime.system.IsisSystemException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.internal.InitialisationSession;
import org.apache.isis.core.runtime.system.internal.IsisLocaleInitializer;
import org.apache.isis.core.runtime.system.internal.IsisTimeZoneInitializer;
import org.apache.isis.core.runtime.system.internal.SplashWindow;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManagerException;
import org.apache.isis.core.runtime.userprofile.UserProfileStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IsisSystemFixturesHookAbstract
implements IsisSystem {
    public static final Logger LOG = LoggerFactory.getLogger(IsisSystemFixturesHookAbstract.class);
    private static final int SPLASH_DELAY_DEFAULT = 6;
    private final IsisLocaleInitializer localeInitializer;
    private final IsisTimeZoneInitializer timeZoneInitializer;
    private final DeploymentType deploymentType;
    private SplashWindow splashWindow;
    private boolean initialized = false;
    private IsisSessionFactory sessionFactory;
    private ServiceInitializer serviceInitializer;

    public IsisSystemFixturesHookAbstract(DeploymentType deploymentType) {
        this(deploymentType, new IsisLocaleInitializer(), new IsisTimeZoneInitializer());
    }

    public IsisSystemFixturesHookAbstract(DeploymentType deploymentType, IsisLocaleInitializer localeInitializer, IsisTimeZoneInitializer timeZoneInitializer) {
        this.deploymentType = deploymentType;
        this.localeInitializer = localeInitializer;
        this.timeZoneInitializer = timeZoneInitializer;
    }

    @Override
    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public void init() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialized = true;
        LOG.info("initialising Isis System");
        LOG.info("working directory: " + new File(".").getAbsolutePath());
        LOG.info("resource stream source: " + this.getConfiguration().getResourceStreamSource());
        this.localeInitializer.initLocale(this.getConfiguration());
        this.timeZoneInitializer.initTimeZone(this.getConfiguration());
        int splashDelay = 6;
        try {
            TemplateImageLoader splashLoader = this.obtainTemplateImageLoader();
            splashLoader.init();
            this.showSplash(splashLoader);
            this.sessionFactory = this.doCreateSessionFactory(this.deploymentType);
            IsisContext.setConfiguration(this.getConfiguration());
            this.initContext(this.sessionFactory);
            this.sessionFactory.init();
            this.serviceInitializer = this.initializeServices();
            this.installFixturesIfRequired();
        }
        catch (IsisSystemException ex) {
            LOG.error("failed to initialise", (Throwable)ex);
            splashDelay = 0;
            throw new RuntimeException(ex);
        }
        finally {
            this.removeSplash(splashDelay);
        }
    }

    private void initContext(IsisSessionFactory sessionFactory) {
        this.getDeploymentType().initContext(sessionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ServiceInitializer initializeServices() {
        DomainObjectContainer container = this.sessionFactory.getContainer();
        List<Object> services = this.sessionFactory.getServices();
        ServicesInjectorDefault servicesInjector = new ServicesInjectorDefault();
        servicesInjector.setContainer(container);
        servicesInjector.setServices(services);
        servicesInjector.init();
        ServiceInitializer serviceInitializer = new ServiceInitializer();
        serviceInitializer.validate(this.getConfiguration(), container, services);
        IsisContext.openSession((AuthenticationSession)new InitialisationSession());
        try {
            ServiceInitializer serviceInitializer2;
            IsisContext.getTransactionManager().startTransaction();
            try {
                serviceInitializer.postConstruct();
                serviceInitializer2 = serviceInitializer;
            }
            catch (RuntimeException ex) {
                IsisContext.getTransactionManager().getTransaction().setAbortCause(new IsisTransactionManagerException(ex));
                ServiceInitializer serviceInitializer3 = serviceInitializer;
                IsisContext.getTransactionManager().endTransaction();
                IsisContext.closeSession();
                return serviceInitializer3;
                {
                    catch (Throwable throwable) {
                        IsisContext.getTransactionManager().endTransaction();
                        throw throwable;
                    }
                }
            }
            IsisContext.getTransactionManager().endTransaction();
            return serviceInitializer2;
        }
        finally {
            IsisContext.closeSession();
        }
    }

    public void shutdown() {
        LOG.info("shutting down system");
        this.shutdownServices(this.serviceInitializer);
        IsisContext.closeAllSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownServices(ServiceInitializer serviceInitializer) {
        IsisContext.openSession((AuthenticationSession)new InitialisationSession());
        try {
            IsisContext.getTransactionManager().startTransaction();
            try {
                serviceInitializer.preDestroy();
            }
            catch (RuntimeException ex) {
                IsisContext.getTransactionManager().getTransaction().setAbortCause(new IsisTransactionManagerException(ex));
            }
            finally {
                IsisContext.getTransactionManager().endTransaction();
            }
        }
        finally {
            IsisContext.closeSession();
        }
    }

    protected abstract IsisSessionFactory doCreateSessionFactory(DeploymentType var1) throws IsisSystemException;

    @Override
    public IsisSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public abstract IsisConfiguration getConfiguration();

    protected TemplateImageLoader obtainTemplateImageLoader() {
        return new TemplateImageLoaderAwt(this.getConfiguration());
    }

    protected OidMarshaller obtainOidMarshaller() {
        return new OidMarshaller();
    }

    protected abstract SpecificationLoaderSpi obtainSpecificationLoaderSpi(DeploymentType var1, ClassSubstitutorFactory var2, Collection<MetaModelRefiner> var3) throws IsisSystemException;

    protected abstract PersistenceSessionFactory obtainPersistenceSessionFactory(DeploymentType var1) throws IsisSystemException;

    protected void appendFixturesInstallerDebug(DebugBuilder debug) {
    }

    @Override
    public LogonFixture getLogonFixture() {
        return null;
    }

    protected void installFixturesIfRequired() throws IsisSystemException {
    }

    protected abstract AuthenticationManager obtainAuthenticationManager(DeploymentType var1) throws IsisSystemException;

    protected abstract AuthorizationManager obtainAuthorizationManager(DeploymentType var1);

    protected abstract UserProfileStore obtainUserProfileStore();

    protected DomainObjectContainer obtainContainer() {
        return this.createContainer(this.getConfiguration());
    }

    private DomainObjectContainer createContainer(IsisConfiguration configuration) {
        String configuredClassName = configuration.getString("isis.persistor.domain-object-container", PersistenceConstants.DOMAIN_OBJECT_CONTAINER_NAME_DEFAULT);
        return (DomainObjectContainer)InstanceUtil.createInstance((String)configuredClassName, (String)PersistenceConstants.DOMAIN_OBJECT_CONTAINER_NAME_DEFAULT, DomainObjectContainer.class);
    }

    protected abstract List<Object> obtainServices();

    private void showSplash(TemplateImageLoader imageLoader) {
        boolean vetoSplashFromConfig = this.getConfiguration().getBoolean("isis.nosplash", false);
        if (!vetoSplashFromConfig && this.getDeploymentType().shouldShowSplash()) {
            this.splashWindow = new SplashWindow(imageLoader);
        }
    }

    private void removeSplash(int delay) {
        if (this.splashWindow != null) {
            if (delay == 0) {
                this.splashWindow.removeImmediately();
            } else {
                this.splashWindow.toFront();
                this.splashWindow.removeAfterDelay(delay);
            }
        }
    }

    private void debug(DebugBuilder debug, Object object) {
        if (object instanceof DebuggableWithTitle) {
            DebuggableWithTitle d = (DebuggableWithTitle)object;
            debug.appendTitle(d.debugTitle());
            d.debugData(debug);
        } else {
            debug.appendln(object.toString());
            debug.appendln("... no further debug information");
        }
    }

    @Override
    public DebuggableWithTitle debugSection(String selectionName) {
        if (selectionName.equals("Configuration")) {
            return this.getConfiguration();
        }
        return null;
    }

    private void debugDisplayContext(String selector, DebugBuilder debug) {
        IsisSession d = IsisContext.getSession(selector);
        if (d != null) {
            d.debugAll(debug);
        } else {
            debug.appendln("No context: " + selector);
        }
    }

    private void debugListContexts(DebugBuilder debug) {
        String[] contextIds;
        for (String contextId : contextIds = IsisContext.getInstance().allSessionIds()) {
            debug.appendln(contextId);
            debug.appendln("-----");
            IsisSession d = IsisContext.getSession(contextId);
            d.debug(debug);
            debug.appendln();
        }
    }

    @Override
    public String[] debugSectionNames() {
        String[] general = new String[]{"Overview", "Authenticator", "Configuration", "Reflector", "Requests", "Contexts"};
        String[] contextIds = IsisContext.getInstance().allSessionIds();
        String[] combined = new String[general.length + contextIds.length];
        System.arraycopy(general, 0, combined, 0, general.length);
        System.arraycopy(contextIds, 0, combined, general.length, contextIds.length);
        return combined;
    }

    private void debugOverview(DebugBuilder debug) {
        try {
            DebuggableWithTitle[] inf;
            debug.appendln(AboutIsis.getFrameworkName());
            debug.appendln(AboutIsis.getFrameworkVersion());
            if (AboutIsis.getApplicationName() != null) {
                debug.appendln("application: " + AboutIsis.getApplicationName());
            }
            if (AboutIsis.getApplicationVersion() != null) {
                debug.appendln("version" + AboutIsis.getApplicationVersion());
            }
            String user = System.getProperty("user.name");
            String system = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") " + System.getProperty("os.version");
            String java = System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
            debug.appendln("user: " + user);
            debug.appendln("os: " + system);
            debug.appendln("java: " + java);
            debug.appendln("working directory: " + new File(".").getAbsolutePath());
            debug.appendTitle("System Installer");
            this.appendFixturesInstallerDebug(debug);
            debug.appendTitle("System Components");
            debug.appendln("Authentication manager", (Object)IsisContext.getAuthenticationManager().getClass().getName());
            debug.appendln("Configuration", (Object)this.getConfiguration().getClass().getName());
            for (DebuggableWithTitle element : inf = IsisContext.debugSystem()) {
                if (element == null) continue;
                element.debugData(debug);
            }
        }
        catch (RuntimeException e) {
            debug.appendException((Throwable)e);
        }
    }
}

