/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.context;

import java.util.List;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationException;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebugList;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.imageloader.TemplateImageLoader;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.MessageBroker;
import org.apache.isis.core.runtime.system.transaction.UpdateNotifier;
import org.apache.isis.core.runtime.userprofile.UserProfile;
import org.apache.isis.core.runtime.userprofile.UserProfileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IsisContext
implements DebuggableWithTitle {
    private static final Logger LOG = LoggerFactory.getLogger(IsisContext.class);
    private static IsisContext singleton;
    private final IsisSessionFactory sessionFactory;
    private final ContextReplacePolicy replacePolicy;
    private final SessionClosePolicy sessionClosePolicy;
    private static IsisConfiguration configuration;

    public static IsisContext getInstance() {
        return singleton;
    }

    public static boolean exists() {
        return singleton != null;
    }

    public static void testReset() {
        singleton = null;
    }

    protected IsisContext(ContextReplacePolicy replacePolicy, SessionClosePolicy sessionClosePolicy, IsisSessionFactory sessionFactory) {
        if (singleton != null && !singleton.isContextReplaceable()) {
            throw new IsisException("Isis Context already set up and cannot be replaced");
        }
        singleton = this;
        this.sessionFactory = sessionFactory;
        this.sessionClosePolicy = sessionClosePolicy;
        this.replacePolicy = replacePolicy;
    }

    protected void shutdownInstance() {
        this.sessionFactory.shutdown();
    }

    public static void shutdown() {
        IsisContext.getInstance().shutdownInstance();
    }

    public final IsisSessionFactory getSessionFactoryInstance() {
        return this.sessionFactory;
    }

    public final boolean isContextReplaceable() {
        return this.replacePolicy == ContextReplacePolicy.REPLACEABLE;
    }

    public final boolean isSessionAutocloseable() {
        return this.sessionClosePolicy == SessionClosePolicy.AUTO_CLOSE;
    }

    protected void applySessionClosePolicy() {
        if (this.getSessionInstance() == null) {
            return;
        }
        if (!this.isSessionAutocloseable()) {
            throw new IllegalStateException("Session already open and context not configured for autoclose");
        }
        this.closeSessionInstance();
    }

    public abstract IsisSession openSessionInstance(AuthenticationSession var1);

    public void closeSessionInstance() {
        if (this.getSessionInstance() != null) {
            this.getSessionInstance().close();
            this.doClose();
        }
    }

    protected void doClose() {
    }

    protected abstract void closeAllSessionsInstance();

    public abstract IsisSession getSessionInstance();

    protected abstract IsisSession getSessionInstance(String var1);

    public abstract String[] allSessionIds();

    public static IsisSession openSession(AuthenticationSession authenticationSession) {
        return IsisContext.getInstance().openSessionInstance(authenticationSession);
    }

    public static void closeSession() {
        IsisContext.getInstance().closeSessionInstance();
    }

    public static IsisSession getSession(String sessionId) {
        return IsisContext.getInstance().getSessionInstance(sessionId);
    }

    public static void closeAllSessions() {
        LOG.info("closing all instances");
        IsisContext instance = IsisContext.getInstance();
        if (instance != null) {
            instance.closeAllSessionsInstance();
        }
    }

    public static IsisSessionFactory getSessionFactory() {
        return IsisContext.getInstance().getSessionFactoryInstance();
    }

    public static IsisConfiguration getConfiguration() {
        if (configuration == null) {
            throw new IsisConfigurationException("No configuration available");
        }
        return configuration;
    }

    public static void setConfiguration(IsisConfiguration configuration) {
        IsisContext.configuration = configuration;
    }

    public static DeploymentType getDeploymentType() {
        return IsisContext.getSessionFactory().getDeploymentType();
    }

    public static SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSessionFactory().getSpecificationLoader();
    }

    public static AuthenticationManager getAuthenticationManager() {
        return IsisContext.getSessionFactory().getAuthenticationManager();
    }

    public static AuthorizationManager getAuthorizationManager() {
        return IsisContext.getSessionFactory().getAuthorizationManager();
    }

    public static TemplateImageLoader getTemplateImageLoader() {
        return IsisContext.getSessionFactory().getTemplateImageLoader();
    }

    public static UserProfileLoader getUserProfileLoader() {
        return IsisContext.getSessionFactory().getUserProfileLoader();
    }

    public static List<Object> getServices() {
        return IsisContext.getSessionFactory().getServices();
    }

    public static OidMarshaller getOidMarshaller() {
        return IsisContext.getSessionFactory().getOidMarshaller();
    }

    public static boolean inSession() {
        IsisSession session = IsisContext.getInstance().getSessionInstance();
        return session != null;
    }

    public static IsisSession getSession() {
        IsisSession session = IsisContext.getInstance().getSessionInstance();
        if (session == null) {
            throw new IllegalStateException("No Session opened for this thread");
        }
        return session;
    }

    public static String getSessionId() {
        return IsisContext.getSession().getId();
    }

    public static AuthenticationSession getAuthenticationSession() {
        return IsisContext.getSession().getAuthenticationSession();
    }

    public static PersistenceSession getPersistenceSession() {
        return IsisContext.getSession().getPersistenceSession();
    }

    public static UserProfile getUserProfile() {
        return IsisContext.getSession().getUserProfile();
    }

    public static Localization getLocalization() {
        return IsisContext.getUserProfile().getLocalization();
    }

    public static IsisTransactionManager getTransactionManager() {
        return IsisContext.getPersistenceSession().getTransactionManager();
    }

    public static boolean inTransaction() {
        return IsisContext.inSession() && IsisContext.getCurrentTransaction() != null && !IsisContext.getCurrentTransaction().getState().isComplete();
    }

    public static IsisTransaction getCurrentTransaction() {
        return IsisContext.getSession().getCurrentTransaction();
    }

    public static MessageBroker getMessageBroker() {
        return IsisContext.getCurrentTransaction().getMessageBroker();
    }

    public static UpdateNotifier getUpdateNotifier() {
        return IsisContext.getCurrentTransaction().getUpdateNotifier();
    }

    public static DebuggableWithTitle[] debugSystem() {
        DebugList debugList = new DebugList("Apache Isis System");
        debugList.add("Context", (Object)IsisContext.getInstance());
        debugList.add("Apache Isis session factory", (Object)IsisContext.getSessionFactory());
        debugList.add("  Authentication manager", (Object)IsisContext.getSessionFactory().getAuthenticationManager());
        debugList.add("  Authorization manager", (Object)IsisContext.getSessionFactory().getAuthorizationManager());
        debugList.add("  Persistence session factory", (Object)IsisContext.getSessionFactory().getPersistenceSessionFactory());
        debugList.add("User profile loader", (Object)IsisContext.getUserProfileLoader());
        debugList.add("Reflector", (Object)IsisContext.getSpecificationLoader());
        debugList.add("Template image loader", (Object)IsisContext.getTemplateImageLoader());
        debugList.add("Deployment type", (Object)IsisContext.getDeploymentType().getDebug());
        debugList.add("Configuration", (Object)IsisContext.getConfiguration());
        debugList.add("Services", IsisContext.getServices());
        return debugList.debug();
    }

    public static DebuggableWithTitle[] debugSession() {
        DebugList debugList = new DebugList("Apache Isis Session");
        debugList.add("Apache Isis session", (Object)IsisContext.getSession());
        debugList.add("Authentication session", (Object)IsisContext.getAuthenticationSession());
        debugList.add("User profile", (Object)IsisContext.getUserProfile());
        debugList.add("Persistence Session", (Object)IsisContext.getPersistenceSession());
        debugList.add("Transaction Manager", (Object)IsisContext.getTransactionManager());
        debugList.add("Service injector", (Object)IsisContext.getPersistenceSession().getServicesInjector());
        debugList.add("Adapter factory", (Object)IsisContext.getPersistenceSession().getObjectAdapterFactory());
        debugList.add("Object factory", (Object)IsisContext.getPersistenceSession().getObjectFactory());
        debugList.add("OID generator", (Object)IsisContext.getPersistenceSession().getOidGenerator());
        debugList.add("Adapter manager", (Object)IsisContext.getPersistenceSession().getAdapterManager());
        debugList.add("Services", IsisContext.getPersistenceSession().getServices());
        return debugList.debug();
    }

    public void debugData(DebugBuilder debug) {
        debug.appendln("context ", (Object)this);
    }

    protected static enum ContextReplacePolicy {
        NOT_REPLACEABLE,
        REPLACEABLE;

    }

    protected static enum SessionClosePolicy {
        EXPLICIT_CLOSE,
        AUTO_CLOSE;

    }
}

