/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryDefault;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.command.CommandDefault;
import org.apache.isis.applib.services.command.spi.CommandService;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterFactory;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackUtils;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacetUtils;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.services.container.query.QueryFindByPattern;
import org.apache.isis.core.metamodel.services.container.query.QueryFindByTitle;
import org.apache.isis.core.metamodel.spec.FreeStandingList;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.persistence.FixturesInstalledFlag;
import org.apache.isis.core.runtime.persistence.NotPersistableException;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.PersistAlgorithm;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindAllInstances;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindByPattern;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindByTitle;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindUsingApplibQueryDefault;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindUsingApplibQuerySerializable;
import org.apache.isis.core.runtime.services.RequestScopedService;
import org.apache.isis.core.runtime.services.eventbus.EventBusServiceDefault;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.AdapterLifecycleTransitioner;
import org.apache.isis.core.runtime.system.persistence.AdapterManagerSpi;
import org.apache.isis.core.runtime.system.persistence.IdentifierGenerator;
import org.apache.isis.core.runtime.system.persistence.ObjectFactory;
import org.apache.isis.core.runtime.system.persistence.ObjectStore;
import org.apache.isis.core.runtime.system.persistence.OidGenerator;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.system.persistence.Persistor;
import org.apache.isis.core.runtime.system.persistence.RecreatedPojoRemapper;
import org.apache.isis.core.runtime.system.transaction.EnlistedObjectDirtying;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosureAbstract;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosureWithReturnAbstract;
import org.apache.isis.core.runtime.system.transaction.UpdateNotifier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceSession
implements Persistor,
EnlistedObjectDirtying,
ToPersistObjectSet,
RecreatedPojoRemapper,
AdapterLifecycleTransitioner,
SessionScopedComponent,
DebuggableWithTitle {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceSession.class);
    private final PersistenceSessionFactory persistenceSessionFactory;
    private final ObjectAdapterFactory objectAdapterFactory;
    private final ObjectFactory objectFactory;
    private final ServicesInjectorSpi servicesInjector;
    private final OidGenerator oidGenerator;
    private final AdapterManagerSpi adapterManager;
    private final PersistAlgorithm persistAlgorithm;
    private final ObjectStore objectStore;
    private final Map<ObjectSpecId, RootOid> servicesByObjectType = Maps.newHashMap();
    private boolean dirtiableSupport;
    private IsisTransactionManager transactionManager;
    private State state;
    private Map<Oid, Oid> persistentByTransient = Maps.newHashMap();

    public PersistenceSession(PersistenceSessionFactory persistenceSessionFactory, ObjectAdapterFactory adapterFactory, ObjectFactory objectFactory, ServicesInjectorSpi servicesInjector, IdentifierGenerator identifierGenerator, AdapterManagerSpi adapterManager, PersistAlgorithm persistAlgorithm, ObjectStore objectStore) {
        this(persistenceSessionFactory, adapterFactory, objectFactory, servicesInjector, new OidGenerator(identifierGenerator), adapterManager, persistAlgorithm, objectStore);
    }

    public PersistenceSession(PersistenceSessionFactory persistenceSessionFactory, ObjectAdapterFactory adapterFactory, ObjectFactory objectFactory, ServicesInjectorSpi servicesInjector, OidGenerator oidGenerator, AdapterManagerSpi adapterManager, PersistAlgorithm persistAlgorithm, ObjectStore objectStore) {
        Ensure.ensureThatArg((Object)persistenceSessionFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persistence session factory required");
        Ensure.ensureThatArg((Object)adapterFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"adapter factory required");
        Ensure.ensureThatArg((Object)objectFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"object factory required");
        Ensure.ensureThatArg((Object)servicesInjector, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"services injector required");
        Ensure.ensureThatArg((Object)oidGenerator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"OID generator required");
        Ensure.ensureThatArg((Object)adapterManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"adapter manager required");
        this.persistenceSessionFactory = persistenceSessionFactory;
        this.objectAdapterFactory = adapterFactory;
        this.objectFactory = objectFactory;
        this.servicesInjector = servicesInjector;
        this.oidGenerator = oidGenerator;
        this.adapterManager = adapterManager;
        this.setState(State.NOT_INITIALIZED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating " + this);
        }
        Ensure.ensureThatArg((Object)persistAlgorithm, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persist algorithm required");
        Ensure.ensureThatArg((Object)objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"object store required");
        this.persistAlgorithm = persistAlgorithm;
        this.objectStore = objectStore;
    }

    public PersistenceSessionFactory getPersistenceSessionFactory() {
        return this.persistenceSessionFactory;
    }

    public void open() {
        this.ensureNotOpened();
        if (LOG.isDebugEnabled()) {
            LOG.debug("opening " + this);
        }
        Ensure.ensureThatState((Object)this.transactionManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"TransactionManager missing");
        this.servicesInjector.injectInto((Object)this.objectFactory);
        this.servicesInjector.injectInto((Object)this.adapterManager);
        this.objectFactory.open();
        this.adapterManager.open();
        Ensure.ensureThatState((Object)this.objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"object store required");
        Ensure.ensureThatState((Object)this.getTransactionManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"transaction manager required");
        Ensure.ensureThatState((Object)this.persistAlgorithm, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"persist algorithm required");
        this.getAdapterManager().injectInto((Object)this.objectStore);
        this.getSpecificationLoader().injectInto((Object)this.objectStore);
        this.objectStore.open();
        this.initServices();
        this.setState(State.OPEN);
    }

    private void initServices() {
        List registeredServices = this.servicesInjector.getRegisteredServices();
        this.startRequestOnRequestScopedServices(registeredServices);
        this.createCommandIfConfigured();
        this.createServiceAdapters(registeredServices);
        this.initOtherApplibServicesIfConfigured(registeredServices);
    }

    private void createServiceAdapters(List<Object> registeredServices) {
        this.getTransactionManager().startTransaction();
        for (Object service : registeredServices) {
            ObjectSpecification serviceSpecification = this.getSpecificationLoader().loadSpecification(service.getClass());
            serviceSpecification.markAsService();
            RootOid existingOid = this.getOidForService(serviceSpecification);
            ObjectAdapter serviceAdapter = existingOid == null ? this.getAdapterManager().adapterFor(service) : this.mapRecreatedPojo((Oid)existingOid, service);
            if (serviceAdapter.getOid().isTransient()) {
                this.adapterManager.remapAsPersistent(serviceAdapter, null);
            }
            serviceAdapter.markAsResolvedIfPossible();
            if (existingOid != null) continue;
            RootOid persistentOid = (RootOid)serviceAdapter.getOid();
            this.registerService(persistentOid);
        }
        this.getTransactionManager().endTransaction();
    }

    private void initOtherApplibServicesIfConfigured(List<Object> registeredServices) {
        Bulk.InteractionContext bic;
        EventBusServiceDefault ebsd = this.getServiceOrNull(EventBusServiceDefault.class);
        if (ebsd != null) {
            ebsd.open();
        }
        if ((bic = this.getServiceOrNull(Bulk.InteractionContext.class)) != null) {
            Bulk.InteractionContext.current.set(bic);
        }
    }

    private void startRequestOnRequestScopedServices(List<Object> registeredServices) {
        for (Object service : registeredServices) {
            if (!(service instanceof RequestScopedService)) continue;
            ((RequestScopedService)service).__isis_startRequest();
        }
    }

    private void createCommandIfConfigured() {
        CommandContext commandContext = this.getServiceOrNull(CommandContext.class);
        if (commandContext == null) {
            return;
        }
        CommandService commandService = this.getServiceOrNull(CommandService.class);
        Command command = commandService != null ? commandService.create() : new CommandDefault();
        commandContext.setCommand(command);
        if (command.getTimestamp() == null) {
            command.setTimestamp(Clock.getTimeAsJavaSqlTimestamp());
        }
        if (command.getUser() == null) {
            command.setUser(this.getAuthenticationSession().getUserName());
        }
    }

    public void startTransactionOnCommandIfConfigured(UUID transactionId) {
        CommandContext commandContext = this.getServiceOrNull(CommandContext.class);
        if (commandContext == null) {
            return;
        }
        CommandService commandService = this.getServiceOrNull(CommandService.class);
        if (commandService == null) {
            return;
        }
        Command command = commandContext.getCommand();
        commandService.startTransaction(command, transactionId);
    }

    public <T> T getServiceOrNull(Class<T> serviceType) {
        return (T)this.servicesInjector.lookupService(serviceType);
    }

    public void close() {
        if (this.getState() == State.CLOSED) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("closing " + this);
        }
        this.closeServices();
        try {
            this.objectStore.close();
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.adapterManager.close();
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.objectFactory.close();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.setState(State.CLOSED);
    }

    private void closeServices() {
        this.closeOtherApplibServicesIfConfigured();
        this.completeCommandIfConfigured();
        this.endRequestOnRequestScopeServices();
    }

    private void closeOtherApplibServicesIfConfigured() {
        EventBusServiceDefault ebs;
        Bulk.InteractionContext bic = this.getServiceOrNull(Bulk.InteractionContext.class);
        if (bic != null) {
            Bulk.InteractionContext.current.set(null);
        }
        if ((ebs = this.getServiceOrNull(EventBusServiceDefault.class)) != null) {
            ebs.close();
        }
    }

    private void completeCommandIfConfigured() {
        CommandService commandService;
        CommandContext commandContext = this.getServiceOrNull(CommandContext.class);
        if (commandContext != null && (commandService = this.getServiceOrNull(CommandService.class)) != null) {
            Command command = commandContext.getCommand();
            commandService.complete(command);
        }
    }

    private void endRequestOnRequestScopeServices() {
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            if (!(service instanceof RequestScopedService)) continue;
            ((RequestScopedService)service).__isis_endRequest();
        }
    }

    private State getState() {
        return this.state;
    }

    private void setState(State state) {
        this.state = state;
    }

    protected void ensureNotOpened() {
        if (this.getState() != State.NOT_INITIALIZED) {
            throw new IllegalStateException("Persistence session has already been initialized");
        }
    }

    protected void ensureOpen() {
        if (this.getState() != State.OPEN) {
            throw new IllegalStateException("Persistence session is not open");
        }
    }

    @Override
    public ObjectAdapter createTransientInstance(ObjectSpecification objectSpec) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating transient instance of " + objectSpec);
        }
        Object pojo = objectSpec.createObject();
        ObjectAdapter adapter = this.getAdapterManager().adapterFor(pojo);
        return objectSpec.initialize(adapter);
    }

    public ObjectAdapter createViewModelInstance(ObjectSpecification objectSpec, String memento) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating view model instance of " + objectSpec);
        }
        Object pojo = objectSpec.createObject();
        ViewModelFacet facet = (ViewModelFacet)objectSpec.getFacet(ViewModelFacet.class);
        facet.initialize(pojo, memento);
        ObjectAdapter adapter = this.getAdapterManager().adapterFor(pojo);
        return objectSpec.initialize(adapter);
    }

    @Override
    public ObjectAdapter createAggregatedInstance(ObjectSpecification objectSpec, ObjectAdapter parentAdapter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating aggregated instance of " + objectSpec);
        }
        Object pojo = objectSpec.createObject();
        ObjectAdapter adapter = this.getAdapterManager().adapterFor(pojo, parentAdapter);
        objectSpec.initialize(adapter);
        if (adapter.isGhost()) {
            adapter.changeState(ResolveState.RESOLVING);
            adapter.changeState(ResolveState.RESOLVED);
        }
        return adapter;
    }

    @Override
    public <T> ObjectAdapter findInstances(Query<T> query, QueryCardinality cardinality) {
        PersistenceQuery persistenceQuery = this.createPersistenceQueryFor(query, cardinality);
        if (persistenceQuery == null) {
            throw new IllegalArgumentException("Unknown query type: " + query.getDescription());
        }
        return this.findInstances(persistenceQuery);
    }

    @Override
    public ObjectAdapter findInstances(PersistenceQuery persistenceQuery) {
        List<ObjectAdapter> instances = this.getInstances(persistenceQuery);
        ObjectSpecification specification = persistenceQuery.getSpecification();
        FreeStandingList results = new FreeStandingList(specification, instances);
        return this.getAdapterManager().adapterFor((Object)results);
    }

    protected final PersistenceQuery createPersistenceQueryFor(Query<?> query, QueryCardinality cardinality) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("createPersistenceQueryFor: " + query.getDescription());
        }
        ObjectSpecification noSpec = this.specFor(query);
        if (query instanceof QueryFindAllInstances) {
            QueryFindAllInstances queryFindAllInstances = (QueryFindAllInstances)query;
            return new PersistenceQueryFindAllInstances(noSpec, queryFindAllInstances.getStart(), queryFindAllInstances.getCount());
        }
        if (query instanceof QueryFindByTitle) {
            QueryFindByTitle queryByTitle = (QueryFindByTitle)query;
            String title = queryByTitle.getTitle();
            return new PersistenceQueryFindByTitle(noSpec, title, queryByTitle.getStart(), queryByTitle.getCount());
        }
        if (query instanceof QueryFindByPattern) {
            QueryFindByPattern queryByPattern = (QueryFindByPattern)query;
            Object pattern = queryByPattern.getPattern();
            ObjectAdapter patternAdapter = this.getAdapterManager().adapterFor(pattern);
            return new PersistenceQueryFindByPattern(noSpec, patternAdapter, queryByPattern.getStart(), queryByPattern.getCount());
        }
        if (query instanceof QueryDefault) {
            QueryDefault queryDefault = (QueryDefault)query;
            String queryName = queryDefault.getQueryName();
            Map<String, ObjectAdapter> argumentsAdaptersByParameterName = this.wrap(queryDefault.getArgumentsByParameterName());
            return new PersistenceQueryFindUsingApplibQueryDefault(noSpec, queryName, argumentsAdaptersByParameterName, cardinality, queryDefault.getStart(), queryDefault.getCount());
        }
        return new PersistenceQueryFindUsingApplibQuerySerializable(noSpec, query, cardinality);
    }

    private ObjectSpecification specFor(Query<?> query) {
        return this.getSpecificationLoader().loadSpecification(query.getResultType());
    }

    private Map<String, ObjectAdapter> wrap(Map<String, Object> argumentsByParameterName) {
        HashMap<String, ObjectAdapter> argumentsAdaptersByParameterName = new HashMap<String, ObjectAdapter>();
        for (Map.Entry<String, Object> entry : argumentsByParameterName.entrySet()) {
            String parameterName = entry.getKey();
            Object argument = argumentsByParameterName.get(parameterName);
            ObjectAdapter argumentAdapter = argument != null ? this.getAdapterManager().adapterFor(argument) : null;
            argumentsAdaptersByParameterName.put(parameterName, argumentAdapter);
        }
        return argumentsAdaptersByParameterName;
    }

    protected List<ObjectAdapter> getInstances(PersistenceQuery persistenceQuery) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getInstances matching " + persistenceQuery);
        }
        return this.getInstancesFromPersistenceLayer(persistenceQuery);
    }

    private List<ObjectAdapter> getInstancesFromPersistenceLayer(final PersistenceQuery persistenceQuery) {
        return this.getTransactionManager().executeWithinTransaction(new TransactionalClosureWithReturnAbstract<List<ObjectAdapter>>(){

            @Override
            public List<ObjectAdapter> execute() {
                return PersistenceSession.this.objectStore.loadInstancesAndAdapt(persistenceQuery);
            }

            @Override
            public void onSuccess() {
                PersistenceSession.this.clearAllDirty();
            }
        });
    }

    public boolean isCheckObjectsForDirtyFlag() {
        return this.dirtiableSupport;
    }

    public void setDirtiableSupport(boolean checkObjectsForDirtyFlag) {
        this.dirtiableSupport = checkObjectsForDirtyFlag;
    }

    @Override
    public void objectChangedAllDirty() {
        if (!this.dirtiableSupport) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("marking as changed any objects that have been manually set as dirty");
        }
        for (ObjectAdapter adapter : this.adapterManager) {
            if (!adapter.getSpecification().isDirty(adapter)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("  found dirty object " + adapter);
            }
            this.objectChanged(adapter);
            adapter.getSpecification().clearDirty(adapter);
        }
    }

    @Override
    public synchronized void clearAllDirty() {
        if (!this.isCheckObjectsForDirtyFlag()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("cleaning any manually dirtied objects");
        }
        for (ObjectAdapter object : this.adapterManager) {
            if (!object.getSpecification().isDirty(object)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("  found dirty object " + object);
            }
            object.getSpecification().clearDirty(object);
        }
    }

    protected RootOid getOidForService(ObjectSpecification serviceSpec) {
        return this.getOidForServiceFromPersistenceLayer(serviceSpec);
    }

    protected void registerService(RootOid rootOid) {
        this.objectStore.registerService(rootOid);
    }

    public ObjectAdapter getService(String id) {
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            if (!id.equals(ServiceUtil.id(service))) continue;
            return this.getService(service);
        }
        return null;
    }

    public List<ObjectAdapter> getServices() {
        List services = this.servicesInjector.getRegisteredServices();
        ArrayList serviceAdapters = Lists.newArrayList();
        for (Object servicePojo : services) {
            serviceAdapters.add(this.getService(servicePojo));
        }
        return serviceAdapters;
    }

    private ObjectAdapter getService(Object servicePojo) {
        ObjectSpecification serviceSpecification = this.getSpecificationLoader().loadSpecification(servicePojo.getClass());
        RootOid oid = this.getOidForService(serviceSpecification);
        ObjectAdapter serviceAdapter = this.mapRecreatedPojo((Oid)oid, servicePojo);
        serviceAdapter.markAsResolvedIfPossible();
        return serviceAdapter;
    }

    public boolean hasServices() {
        return this.servicesInjector.getRegisteredServices().size() > 0;
    }

    private RootOid getOidForServiceFromPersistenceLayer(ObjectSpecification serviceSpecification) {
        ObjectSpecId objectSpecId = serviceSpecification.getSpecId();
        RootOid oid = this.servicesByObjectType.get(objectSpecId);
        if (oid == null) {
            oid = this.objectStore.getOidForService(serviceSpecification);
            this.servicesByObjectType.put(objectSpecId, oid);
        }
        return oid;
    }

    public boolean isFixturesInstalled() {
        PersistenceSessionFactory persistenceSessionFactory = this.getPersistenceSessionFactory();
        if (persistenceSessionFactory instanceof FixturesInstalledFlag) {
            FixturesInstalledFlag fixturesInstalledFlag = (FixturesInstalledFlag)((Object)persistenceSessionFactory);
            if (fixturesInstalledFlag.isFixturesInstalled() == null) {
                fixturesInstalledFlag.setFixturesInstalled(this.objectStore.isFixturesInstalled());
            }
            return fixturesInstalledFlag.isFixturesInstalled();
        }
        return this.objectStore.isFixturesInstalled();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.debug("finalizing persistence session");
    }

    @Override
    public ObjectAdapter loadObject(TypedOid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ObjectAdapter adapter = this.getAdapterManager().getAdapterFor((Oid)oid);
        if (adapter != null) {
            return adapter;
        }
        return this.loadMappedObjectFromObjectStore(oid);
    }

    private ObjectAdapter loadMappedObjectFromObjectStore(final TypedOid oid) {
        ObjectAdapter adapter = this.getTransactionManager().executeWithinTransaction(new TransactionalClosureWithReturnAbstract<ObjectAdapter>(){

            @Override
            public ObjectAdapter execute() {
                return PersistenceSession.this.objectStore.loadInstanceAndAdapt(oid);
            }
        });
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveImmediately(ObjectAdapter adapter) {
        AuthenticationSession authenticationSession = this.getAuthenticationSession();
        synchronized (authenticationSession) {
            if (!adapter.canTransitionToResolving()) {
                return;
            }
            Assert.assertFalse((String)"only resolve object that is not yet resolved", (Object)adapter, (boolean)adapter.isResolved());
            Assert.assertTrue((String)"only resolve object that is persistent", (Object)adapter, (boolean)adapter.representsPersistent());
            this.resolveImmediatelyFromPersistenceLayer(adapter);
            if (LOG.isDebugEnabled()) {
                LOG.debug("resolved: " + adapter.getSpecification().getShortIdentifier() + " " + adapter.getResolveState().code() + " " + adapter.getOid());
            }
        }
    }

    private void resolveImmediatelyFromPersistenceLayer(final ObjectAdapter adapter) {
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, LoadingCallbackFacet.class);
            }

            @Override
            public void execute() {
                PersistenceSession.this.objectStore.resolveImmediately(adapter);
            }

            @Override
            public void onSuccess() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, LoadedCallbackFacet.class);
            }

            @Override
            public void onFailure() {
            }
        });
    }

    @Override
    public void resolveField(ObjectAdapter objectAdapter, ObjectAssociation field) {
        if (field.isNotPersisted()) {
            return;
        }
        if (field.isOneToManyAssociation()) {
            return;
        }
        if (field.getSpecification().isParented()) {
            return;
        }
        if (field.getSpecification().isValue()) {
            return;
        }
        ObjectAdapter referenceAdapter = field.get(objectAdapter);
        if (referenceAdapter == null || referenceAdapter.isResolved()) {
            return;
        }
        if (!referenceAdapter.representsPersistent()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("resolve field " + objectAdapter.getSpecification().getShortIdentifier() + "." + field.getId() + ": " + referenceAdapter.getSpecification().getShortIdentifier() + " " + referenceAdapter.getResolveState().code() + " " + referenceAdapter.getOid());
        }
        this.resolveFieldFromPersistenceLayer(objectAdapter, field);
    }

    private void resolveFieldFromPersistenceLayer(final ObjectAdapter objectAdapter, final ObjectAssociation field) {
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void execute() {
                PersistenceSession.this.objectStore.resolveField(objectAdapter, field);
            }
        });
    }

    @Override
    public void makePersistent(ObjectAdapter adapter) {
        if (adapter.representsPersistent()) {
            throw new NotPersistableException("Object already persistent: " + adapter);
        }
        if (!adapter.getSpecification().persistability().isPersistable()) {
            throw new NotPersistableException("Object is not persistable: " + adapter);
        }
        ObjectSpecification specification = adapter.getSpecification();
        if (specification.isService()) {
            throw new NotPersistableException("Cannot persist services: " + adapter);
        }
        this.makePersistentInPersistenceLayer(adapter);
    }

    protected void makePersistentInPersistenceLayer(final ObjectAdapter adapter) {
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
            }

            @Override
            public void execute() {
                PersistenceSession.this.persistAlgorithm.makePersistent(adapter, PersistenceSession.this);
                PersistenceSession.this.persistentByTransient.clear();
            }

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure() {
            }
        });
    }

    @Override
    public void objectChanged(ObjectAdapter adapter) {
        if (adapter.isTransient() || adapter.isParented() && adapter.getAggregateRoot().isTransient()) {
            this.addObjectChangedForPresentationLayer(adapter);
            return;
        }
        if (adapter.respondToChangesInPersistentObjects()) {
            if (this.isImmutable(adapter)) {
                return;
            }
            this.addObjectChangedForPersistenceLayer(adapter);
            this.addObjectChangedForPresentationLayer(adapter);
        }
        if (adapter.respondToChangesInPersistentObjects() || adapter.isTransient()) {
            this.addObjectChangedForPresentationLayer(adapter);
        }
    }

    private void addObjectChangedForPresentationLayer(ObjectAdapter adapter) {
        LOG.debug("object change to update presentation layer " + adapter.getOid());
        adapter.fireChangedEvent();
        this.getUpdateNotifier().addChangedObject(adapter);
    }

    private void addObjectChangedForPersistenceLayer(final ObjectAdapter adapter) {
        LOG.debug("object change to be persisted " + adapter.getOid());
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, UpdatingCallbackFacet.class);
            }

            @Override
            public void execute() {
                SaveObjectCommand saveObjectCommand = PersistenceSession.this.objectStore.createSaveObjectCommand(adapter);
                PersistenceSession.this.getTransactionManager().addCommand(saveObjectCommand);
            }

            @Override
            public void onSuccess() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, UpdatedCallbackFacet.class);
            }

            @Override
            public void onFailure() {
            }
        });
        this.getUpdateNotifier().addChangedObject(adapter);
    }

    @Override
    public void destroyObject(ObjectAdapter adapter) {
        ObjectSpecification spec = adapter.getSpecification();
        if (spec.isParented()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("destroyObject " + adapter);
        }
        this.destroyObjectInPersistenceLayer(adapter);
    }

    private void destroyObjectInPersistenceLayer(final ObjectAdapter adapter) {
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, RemovingCallbackFacet.class);
            }

            @Override
            public void execute() {
                DestroyObjectCommand command = PersistenceSession.this.objectStore.createDestroyObjectCommand(adapter);
                PersistenceSession.this.getTransactionManager().addCommand(command);
            }

            @Override
            public void onSuccess() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, RemovedCallbackFacet.class);
            }

            @Override
            public void onFailure() {
            }
        });
    }

    @Override
    public boolean hasInstances(ObjectSpecification specification) {
        if (LOG.isInfoEnabled()) {
            LOG.info("hasInstances of " + specification.getShortIdentifier());
        }
        return this.hasInstancesFromPersistenceLayer(specification);
    }

    private boolean hasInstancesFromPersistenceLayer(final ObjectSpecification specification) {
        return this.getTransactionManager().executeWithinTransaction(new TransactionalClosureWithReturnAbstract<Boolean>(){

            @Override
            public Boolean execute() {
                return PersistenceSession.this.objectStore.hasInstances(specification);
            }
        });
    }

    @Override
    public ObjectAdapter mapRecreatedPojo(Oid oid, Object recreatedPojo) {
        return this.adapterManager.mapRecreatedPojo(oid, recreatedPojo);
    }

    @Override
    public void remapRecreatedPojo(ObjectAdapter adapter, Object recreatedPojo) {
        this.adapterManager.remapRecreatedPojo(adapter, recreatedPojo);
    }

    @Override
    public void remapAsPersistent(ObjectAdapter adapter, RootOid hintRootOid) {
        this.adapterManager.remapAsPersistent(adapter, hintRootOid);
    }

    @Override
    public void removeAdapter(ObjectAdapter adapter) {
        this.adapterManager.removeAdapter(adapter);
    }

    @Override
    public void remapAsPersistent(ObjectAdapter adapter) {
        Oid transientOid = adapter.getOid();
        this.adapterManager.remapAsPersistent(adapter, null);
        Oid persistentOid = adapter.getOid();
        this.persistentByTransient.put(transientOid, persistentOid);
    }

    @Override
    public Oid remappedFrom(Oid transientOid) {
        return this.persistentByTransient.get(transientOid);
    }

    @Override
    public void addCreateObjectCommand(ObjectAdapter object) {
        this.getTransactionManager().addCommand(this.objectStore.createCreateObjectCommand(object));
    }

    public String debugTitle() {
        return "Object Store Persistor";
    }

    public void debugData(DebugBuilder debug) {
        debug.appendTitle(this.getClass().getName());
        debug.appendln("container", (Object)this.servicesInjector);
        debug.appendln();
        this.adapterManager.debugData(debug);
        debug.appendln();
        debug.appendln("manually dirtiable support (isDirty flag)?", this.dirtiableSupport);
        debug.appendTitle("OID Generator");
        this.oidGenerator.debugData(debug);
        debug.appendln();
        debug.appendTitle("Services");
        for (Object servicePojo : this.servicesInjector.getRegisteredServices()) {
            String id = ServiceUtil.id(servicePojo);
            Class<?> serviceClass = servicePojo.getClass();
            ObjectSpecification serviceSpecification = this.getSpecificationLoader().loadSpecification(serviceClass);
            String serviceClassName = serviceClass.getName();
            RootOid oidForService = this.getOidForService(serviceSpecification);
            String serviceId = id + (id.equals(serviceClassName) ? "" : " (" + serviceClassName + ")");
            debug.appendln(oidForService != null ? oidForService.toString() : "[NULL]", (Object)serviceId);
        }
        debug.appendln();
        debug.appendTitle("Persistor");
        this.getTransactionManager().debugData(debug);
        debug.appendln("Persist Algorithm", (Object)this.persistAlgorithm);
        debug.appendln("Object Store", (Object)this.objectStore);
        debug.appendln();
        this.objectStore.debugData(debug);
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        if (this.objectStore != null) {
            toString.append("objectStore", this.objectStore.name());
        }
        if (this.persistAlgorithm != null) {
            toString.append("persistAlgorithm", this.persistAlgorithm.name());
        }
        return toString.toString();
    }

    protected boolean isImmutable(ObjectAdapter adapter) {
        ObjectSpecification noSpec = adapter.getSpecification();
        return ImmutableFacetUtils.isAlwaysImmutable((ObjectSpecification)noSpec) || ImmutableFacetUtils.isImmutableOncePersisted((ObjectSpecification)noSpec) && adapter.representsPersistent();
    }

    public void testReset() {
        this.objectStore.reset();
        this.adapterManager.reset();
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public PersistAlgorithm getPersistAlgorithm() {
        return this.persistAlgorithm;
    }

    private UpdateNotifier getUpdateNotifier() {
        return this.getTransactionManager().getTransaction().getUpdateNotifier();
    }

    public final ObjectAdapterFactory getObjectAdapterFactory() {
        return this.objectAdapterFactory;
    }

    public final OidGenerator getOidGenerator() {
        return this.oidGenerator;
    }

    @Override
    public final AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    public ServicesInjectorSpi getServicesInjector() {
        return this.servicesInjector;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setTransactionManager(IsisTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public IsisTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    private static enum State {
        NOT_INITIALIZED,
        OPEN,
        CLOSED;

    }
}

