/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.session;

import com.google.common.collect.ArrayListMultimap;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.imageloader.TemplateImageLoader;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionDefault;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.userprofile.UserProfile;
import org.apache.isis.core.runtime.userprofile.UserProfileLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisSessionFactoryDefault
implements IsisSessionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IsisSessionFactoryDefault.class);
    private final DeploymentType deploymentType;
    private final IsisConfiguration configuration;
    private final TemplateImageLoader templateImageLoader;
    private final SpecificationLoaderSpi specificationLoaderSpi;
    private final AuthenticationManager authenticationManager;
    private final AuthorizationManager authorizationManager;
    private final PersistenceSessionFactory persistenceSessionFactory;
    private final UserProfileLoader userProfileLoader;
    private final DomainObjectContainer container;
    private final List<Object> serviceList;
    private final OidMarshaller oidMarshaller;

    public IsisSessionFactoryDefault(DeploymentType deploymentType, IsisConfiguration configuration, SpecificationLoaderSpi specificationLoader, TemplateImageLoader templateImageLoader, AuthenticationManager authenticationManager, AuthorizationManager authorizationManager, UserProfileLoader userProfileLoader, PersistenceSessionFactory persistenceSessionFactory, DomainObjectContainer container, List<Object> serviceList, OidMarshaller oidMarshaller) {
        Ensure.ensureThatArg((Object)deploymentType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)configuration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)specificationLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)templateImageLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)authenticationManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)authorizationManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)userProfileLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)persistenceSessionFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg(serviceList, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.deploymentType = deploymentType;
        this.configuration = configuration;
        this.templateImageLoader = templateImageLoader;
        this.specificationLoaderSpi = specificationLoader;
        this.authenticationManager = authenticationManager;
        this.authorizationManager = authorizationManager;
        this.userProfileLoader = userProfileLoader;
        this.persistenceSessionFactory = persistenceSessionFactory;
        this.container = container;
        this.serviceList = serviceList;
        this.oidMarshaller = oidMarshaller;
        this.validateServices(serviceList);
    }

    private void validateServices(List<Object> serviceList) {
        for (Object service : serviceList) {
            Method[] methodArray;
            for (Method method : methodArray = service.getClass().getMethods()) {
                this.validatePostConstructMethods(service, method);
                this.validatePreDestroyMethods(service, method);
            }
        }
        ArrayListMultimap servicesById = ArrayListMultimap.create();
        for (Object object : serviceList) {
            String id = ServiceUtil.id((Object)object);
            servicesById.put((Object)id, object);
        }
        for (Map.Entry entry : servicesById.asMap().entrySet()) {
            String serviceId = (String)entry.getKey();
            Collection services = (Collection)entry.getValue();
            if (services.size() <= 1) continue;
            throw new IllegalStateException("Service ids must be unique; serviceId '" + serviceId + "' is declared by domain services " + IsisSessionFactoryDefault.classNamesFor(services));
        }
    }

    private static String classNamesFor(Collection<Object> services) {
        StringBuilder buf = new StringBuilder();
        for (Object service : services) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(service.getClass().getName());
        }
        return buf.toString();
    }

    private void validatePostConstructMethods(Object service, Method method) {
        PostConstruct postConstruct = method.getAnnotation(PostConstruct.class);
        if (postConstruct == null) {
            return;
        }
        int numParams = method.getParameterTypes().length;
        if (numParams == 0) {
            return;
        }
        if (numParams == 1 && method.getParameterTypes()[0].isAssignableFrom(Map.class)) {
            return;
        }
        throw new IllegalStateException("Domain service " + service.getClass().getName() + " has @PostConstruct method " + method.getName() + "; such methods must take either no argument or 1 argument of type Map<String,String>");
    }

    private void validatePreDestroyMethods(Object service, Method method) {
        PreDestroy preDestroy = method.getAnnotation(PreDestroy.class);
        if (preDestroy == null) {
            return;
        }
        int numParams = method.getParameterTypes().length;
        if (numParams == 0) {
            return;
        }
        throw new IllegalStateException("Domain service " + service.getClass().getName() + " has @PreDestroy method " + method.getName() + "; such methods must take no arguments");
    }

    public void init() {
        this.templateImageLoader.init();
        this.specificationLoaderSpi.setContainer(this.container);
        this.specificationLoaderSpi.setServices(this.serviceList);
        this.specificationLoaderSpi.init();
        this.specificationLoaderSpi.injectInto((Object)this.persistenceSessionFactory);
        this.persistenceSessionFactory.setContainer(this.container);
        this.persistenceSessionFactory.setServices(this.serviceList);
        this.userProfileLoader.setServices(this.serviceList);
        this.authenticationManager.init();
        this.authorizationManager.init();
        this.persistenceSessionFactory.init();
    }

    public void shutdown() {
        this.persistenceSessionFactory.shutdown();
        this.authenticationManager.shutdown();
        this.specificationLoaderSpi.shutdown();
        this.templateImageLoader.shutdown();
        this.userProfileLoader.shutdown();
    }

    @Override
    public IsisSession openSession(AuthenticationSession authenticationSession) {
        PersistenceSession persistenceSession = this.persistenceSessionFactory.createPersistenceSession();
        Ensure.ensureThatArg((Object)persistenceSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        UserProfile userProfile = this.userProfileLoader.getProfile(authenticationSession);
        Ensure.ensureThatArg((Object)userProfile, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.getSpecificationLoader().injectInto((Object)persistenceSession);
        IsisSessionDefault isisSessionDefault = new IsisSessionDefault(this, authenticationSession, persistenceSession, userProfile);
        return isisSessionDefault;
    }

    @Override
    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public SpecificationLoaderSpi getSpecificationLoader() {
        return this.specificationLoaderSpi;
    }

    @Override
    public TemplateImageLoader getTemplateImageLoader() {
        return this.templateImageLoader;
    }

    @Override
    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    @Override
    public PersistenceSessionFactory getPersistenceSessionFactory() {
        return this.persistenceSessionFactory;
    }

    @Override
    public UserProfileLoader getUserProfileLoader() {
        return this.userProfileLoader;
    }

    @Override
    public DomainObjectContainer getContainer() {
        return this.container;
    }

    @Override
    public List<Object> getServices() {
        return this.serviceList;
    }

    @Override
    public OidMarshaller getOidMarshaller() {
        return this.oidMarshaller;
    }
}

