/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.transaction;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.PublishedAction;
import org.apache.isis.applib.annotation.PublishedObject;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.services.audit.AuditingService3;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.publish.EventMetadata;
import org.apache.isis.applib.services.publish.EventType;
import org.apache.isis.applib.services.publish.ObjectStringifier;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.TransactionScopedComponent;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacet;
import org.apache.isis.core.metamodel.facets.object.audit.AuditableFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.publish.PublishedObjectFacet;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.progmodel.facets.actions.invoke.CommandUtil;
import org.apache.isis.core.runtime.persistence.ObjectPersistenceException;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PublishingServiceWithDefaultPayloadFactories;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.TransactionalResource;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionFlushException;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManagerException;
import org.apache.isis.core.runtime.system.transaction.MessageBroker;
import org.apache.isis.core.runtime.system.transaction.UpdateNotifier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisTransaction
implements TransactionScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(IsisTransaction.class);
    private final TransactionalResource objectStore;
    private final List<PersistenceCommand> commands = Lists.newArrayList();
    private final IsisTransactionManager transactionManager;
    private final org.apache.isis.core.commons.authentication.MessageBroker messageBroker;
    private final UpdateNotifier updateNotifier;
    private final Command command;
    private final AuditingService3 auditingService3;
    private final PublishingServiceWithDefaultPayloadFactories publishingService;
    private final UUID transactionId;
    private State state;
    private IsisException abortCause;
    private static final int MAX_FLUSH_ATTEMPTS = 10;
    private final Map<ObjectAdapter, PublishedObject.ChangeKind> changeKindByEnlistedAdapter = Maps.newLinkedHashMap();
    private final Map<AdapterAndProperty, PreAndPostValues> changedObjectProperties = Maps.newLinkedHashMap();
    private ObjectStringifier objectStringifier;

    public IsisTransaction(IsisTransactionManager transactionManager, org.apache.isis.core.commons.authentication.MessageBroker messageBroker, UpdateNotifier updateNotifier, TransactionalResource objectStore, CommandContext commandContext, AuditingService3 auditingService3, PublishingServiceWithDefaultPayloadFactories publishingService) {
        Ensure.ensureThatArg((Object)transactionManager, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)CoreMatchers.nullValue())), (String)"transaction manager is required");
        Ensure.ensureThatArg((Object)messageBroker, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)CoreMatchers.nullValue())), (String)"message broker is required");
        Ensure.ensureThatArg((Object)updateNotifier, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)CoreMatchers.nullValue())), (String)"update notifier is required");
        this.transactionManager = transactionManager;
        this.messageBroker = messageBroker;
        this.updateNotifier = updateNotifier;
        this.auditingService3 = auditingService3;
        this.publishingService = publishingService;
        UUID previousTransactionId = null;
        if (commandContext != null) {
            this.command = commandContext.getCommand();
            previousTransactionId = this.command.getTransactionId();
        } else {
            this.command = null;
        }
        this.transactionId = previousTransactionId != null ? previousTransactionId : UUID.randomUUID();
        this.state = State.IN_PROGRESS;
        this.objectStore = objectStore;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new transaction " + this);
        }
    }

    public final UUID getTransactionId() {
        return this.transactionId;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        this.state = state;
    }

    public void addCommand(PersistenceCommand command) {
        if (command == null) {
            return;
        }
        ObjectAdapter onObject = command.onAdapter();
        if (command instanceof SaveObjectCommand) {
            if (this.alreadyHasCreate(onObject) || this.alreadyHasSave(onObject)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored command as object already created/saved" + command);
                }
                return;
            }
            if (this.alreadyHasDestroy(onObject)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored command " + command + " as object no longer exists");
                }
                return;
            }
        }
        if (command instanceof DestroyObjectCommand) {
            if (this.alreadyHasCreate(onObject)) {
                this.removeCreate(onObject);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored both create and destroy command " + command);
                }
                return;
            }
            if (this.alreadyHasSave(onObject)) {
                this.removeSave(onObject);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("removed prior save command " + command);
                }
            }
            if (this.alreadyHasDestroy(onObject)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored command " + command + " as command already recorded");
                }
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("add command " + command);
        }
        this.commands.add(command);
    }

    public final synchronized void flush() {
        Ensure.ensureThatState((Object)this.getState().canFlush(), (Matcher)Matchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        if (LOG.isDebugEnabled()) {
            LOG.debug("flush transaction " + this);
        }
        try {
            this.doFlush();
        }
        catch (RuntimeException ex) {
            this.setAbortCause(new IsisTransactionFlushException(ex));
            throw ex;
        }
    }

    private void doFlush() {
        int i = 0;
        do {
            List<PersistenceCommand> commandsPrior = Collections.unmodifiableList(Lists.newArrayList(this.commands));
            try {
                this.objectStore.execute(commandsPrior);
                for (PersistenceCommand command : commandsPrior) {
                    if (!(command instanceof DestroyObjectCommand)) continue;
                    ObjectAdapter adapter = command.onAdapter();
                    adapter.setVersion(null);
                    if (adapter.isDestroyed()) continue;
                    adapter.changeState(ResolveState.DESTROYED);
                }
                this.commands.removeAll(commandsPrior);
            }
            catch (RuntimeException ex) {
                this.commands.clear();
                throw ex;
            }
        } while (!this.commands.isEmpty() && i++ < 10);
        if (!this.commands.isEmpty()) {
            List commandsStillToFlush = Collections.unmodifiableList(Lists.newArrayList(this.commands));
            this.commands.clear();
            throw new ObjectPersistenceException("Failed to flush transaction after 10 attempts; commands still to flush:\n " + commandsStillToFlush.toString());
        }
    }

    protected void doAudit(Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> changedObjectProperties) {
        if (this.auditingService3 == null) {
            return;
        }
        String currentUser = this.getTransactionManager().getAuthenticationSession().getUserName();
        Timestamp currentTime = Clock.getTimeAsJavaSqlTimestamp();
        for (Map.Entry<AdapterAndProperty, PreAndPostValues> auditEntry : changedObjectProperties) {
            this.auditChangedProperty(currentTime, currentUser, auditEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishActionIfRequired(String currentUser, Timestamp timestamp) {
        if (this.publishingService == null) {
            return;
        }
        try {
            ActionInvocationFacet.CurrentInvocation currentInvocation = (ActionInvocationFacet.CurrentInvocation)ActionInvocationFacet.currentInvocation.get();
            if (currentInvocation == null) {
                return;
            }
            IdentifiedHolder action = currentInvocation.getAction();
            PublishedActionFacet publishedActionFacet = (PublishedActionFacet)action.getFacet(PublishedActionFacet.class);
            if (publishedActionFacet == null) {
                return;
            }
            PublishedAction.PayloadFactory payloadFactory = (PublishedAction.PayloadFactory)publishedActionFacet.value();
            RootOid adapterOid = (RootOid)currentInvocation.getTarget().getOid();
            String oidStr = this.getOidMarshaller().marshal(adapterOid);
            Identifier actionIdentifier = action.getIdentifier();
            String title = oidStr + ": " + actionIdentifier.toNameParmsIdentityString();
            Command command = currentInvocation.getCommand();
            String targetClass = command.getTargetClass();
            String targetAction = command.getTargetAction();
            Bookmark target = command.getTarget();
            String memberIdentifier = command.getMemberIdentifier();
            EventMetadata metadata = this.newEventMetadata(EventType.ACTION_INVOCATION, currentUser, timestamp, title, targetClass, targetAction, target, memberIdentifier);
            this.publishingService.publishAction(payloadFactory, metadata, currentInvocation, this.objectStringifier());
        }
        finally {
            ActionInvocationFacet.currentInvocation.set(null);
        }
    }

    protected List<ObjectAdapter> publishedChangedObjectsIfRequired(String currentUser, Timestamp timestamp) {
        if (this.publishingService == null) {
            return Collections.emptyList();
        }
        ArrayList enlistedAdapters = Lists.newArrayList(this.changeKindByEnlistedAdapter.keySet());
        for (ObjectAdapter enlistedAdapter : enlistedAdapters) {
            String oidStr;
            PublishedObject.ChangeKind changeKind = this.changeKindByEnlistedAdapter.get(enlistedAdapter);
            PublishedObjectFacet publishedObjectFacet = (PublishedObjectFacet)enlistedAdapter.getSpecification().getFacet(PublishedObjectFacet.class);
            if (publishedObjectFacet == null) continue;
            PublishedObject.PayloadFactory payloadFactory = (PublishedObject.PayloadFactory)publishedObjectFacet.value();
            RootOid enlistedAdapterOid = (RootOid)enlistedAdapter.getOid();
            String title = oidStr = this.getOidMarshaller().marshal(enlistedAdapterOid);
            EventType eventTypeFor = IsisTransaction.eventTypeFor(changeKind);
            String enlistedAdapterClass = CommandUtil.targetClassNameFor((ObjectAdapter)enlistedAdapter);
            Bookmark enlistedTarget = enlistedAdapterOid.asBookmark();
            EventMetadata metadata = this.newEventMetadata(eventTypeFor, currentUser, timestamp, title, enlistedAdapterClass, null, enlistedTarget, null);
            this.publishingService.publishObject(payloadFactory, metadata, enlistedAdapter, changeKind, this.objectStringifier());
        }
        return enlistedAdapters;
    }

    private static EventType eventTypeFor(PublishedObject.ChangeKind changeKind) {
        if (changeKind == PublishedObject.ChangeKind.UPDATE) {
            return EventType.OBJECT_UPDATED;
        }
        if (changeKind == PublishedObject.ChangeKind.CREATE) {
            return EventType.OBJECT_CREATED;
        }
        if (changeKind == PublishedObject.ChangeKind.DELETE) {
            return EventType.OBJECT_DELETED;
        }
        throw new IllegalArgumentException("unknown ChangeKind '" + changeKind + "'");
    }

    protected ObjectStringifier objectStringifier() {
        if (this.objectStringifier == null) {
            this.objectStringifier = new ObjectStringifier(){

                public String toString(Object object) {
                    if (object == null) {
                        return null;
                    }
                    ObjectAdapter adapter = IsisTransaction.this.getAdapterManager().adapterFor(object);
                    Oid oid = adapter.getOid();
                    return oid != null ? oid.enString(IsisTransaction.this.getOidMarshaller()) : this.encodedValueOf(adapter);
                }

                private String encodedValueOf(ObjectAdapter adapter) {
                    EncodableFacet facet = (EncodableFacet)adapter.getSpecification().getFacet(EncodableFacet.class);
                    return facet != null ? facet.toEncodedString(adapter) : adapter.toString();
                }

                public String classNameOf(Object object) {
                    ObjectAdapter adapter = IsisTransaction.this.getAdapterManager().adapterFor(object);
                    String className = adapter.getSpecification().getFullIdentifier();
                    return className;
                }
            };
        }
        return this.objectStringifier;
    }

    private EventMetadata newEventMetadata(EventType eventType, String currentUser, Timestamp timestampEpoch, String title, String targetClass, String targetAction, Bookmark target, String memberIdentifier) {
        int nextEventSequence = this.nextEventSequence();
        return new EventMetadata(this.getTransactionId(), nextEventSequence, eventType, currentUser, timestampEpoch, title, targetClass, targetAction, target, memberIdentifier);
    }

    private int nextEventSequence() {
        if (this.command == null) {
            throw new IllegalStateException("CommandContext service is required to support Publishing.");
        }
        return this.command.next("publishedEvent");
    }

    public void auditChangedProperty(Timestamp timestamp, String user, Map.Entry<AdapterAndProperty, PreAndPostValues> auditEntry) {
        AdapterAndProperty aap = auditEntry.getKey();
        ObjectAdapter adapter = aap.getAdapter();
        AuditableFacet auditableFacet = (AuditableFacet)adapter.getSpecification().getFacet(AuditableFacet.class);
        if (auditableFacet == null || auditableFacet.isDisabled()) {
            return;
        }
        RootOid oid = (RootOid)adapter.getOid();
        String objectType = oid.getObjectSpecId().asString();
        String identifier = oid.getIdentifier();
        PreAndPostValues papv = auditEntry.getValue();
        String preValue = IsisTransaction.asString(papv.getPre());
        String postValue = IsisTransaction.asString(papv.getPost());
        ObjectAssociation property = aap.getProperty();
        String memberId = property.getIdentifier().toClassAndNameIdentityString();
        String propertyId = property.getId();
        String targetClass = CommandUtil.targetClassNameFor((ObjectAdapter)adapter);
        Bookmark target = new Bookmark(objectType, identifier);
        this.auditingService3.audit(this.getTransactionId(), targetClass, target, memberId, propertyId, preValue, postValue, user, timestamp);
    }

    private static String asString(Object object) {
        return object != null ? object.toString() : null;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    public final synchronized void commit() {
        Ensure.ensureThatState((Object)this.getState().canCommit(), (Matcher)Matchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        Ensure.ensureThatState((Object)this.abortCause, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()), (String)"cannot commit: an abort cause has been set");
        if (LOG.isDebugEnabled()) {
            LOG.debug("commit transaction " + this);
        }
        if (this.getState() == State.COMMITTED) {
            if (LOG.isInfoEnabled()) {
                LOG.info("already committed; ignoring");
            }
            return;
        }
        try {
            this.doAudit(this.getChangedObjectProperties());
            String currentUser = this.getTransactionManager().getAuthenticationSession().getUserName();
            Timestamp endTimestamp = Clock.getTimeAsJavaSqlTimestamp();
            this.publishActionIfRequired(currentUser, endTimestamp);
            this.doFlush();
            this.publishedChangedObjectsIfRequired(currentUser, endTimestamp);
            this.doFlush();
            this.setState(State.COMMITTED);
        }
        catch (RuntimeException ex) {
            this.setAbortCause(new IsisTransactionManagerException(ex));
            throw ex;
        }
    }

    public final synchronized void markAsAborted() {
        Ensure.ensureThatState((Object)this.getState().canAbort(), (Matcher)Matchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        if (LOG.isInfoEnabled()) {
            LOG.info("abort transaction " + this);
        }
        this.setState(State.ABORTED);
    }

    @Deprecated
    public void ensureNoAbortCause() {
        Ensure.ensureThatArg((Object)this.abortCause, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()), (String)"abort cause has been set");
    }

    public void setAbortCause(IsisException abortCause) {
        this.setState(State.MUST_ABORT);
        this.abortCause = abortCause;
    }

    public IsisException getAbortCause() {
        return this.abortCause;
    }

    public void clearAbortCause() {
        this.abortCause = null;
    }

    private boolean alreadyHasCommand(Class<?> commandClass, ObjectAdapter onObject) {
        return this.getCommand(commandClass, onObject) != null;
    }

    private boolean alreadyHasCreate(ObjectAdapter onObject) {
        return this.alreadyHasCommand(CreateObjectCommand.class, onObject);
    }

    private boolean alreadyHasDestroy(ObjectAdapter onObject) {
        return this.alreadyHasCommand(DestroyObjectCommand.class, onObject);
    }

    private boolean alreadyHasSave(ObjectAdapter onObject) {
        return this.alreadyHasCommand(SaveObjectCommand.class, onObject);
    }

    private PersistenceCommand getCommand(Class<?> commandClass, ObjectAdapter onObject) {
        for (PersistenceCommand command : this.commands) {
            if (!command.onAdapter().equals(onObject) || !commandClass.isAssignableFrom(command.getClass())) continue;
            return command;
        }
        return null;
    }

    private void removeCommand(Class<?> commandClass, ObjectAdapter onObject) {
        PersistenceCommand toDelete = this.getCommand(commandClass, onObject);
        this.commands.remove(toDelete);
    }

    private void removeCreate(ObjectAdapter onObject) {
        this.removeCommand(CreateObjectCommand.class, onObject);
    }

    private void removeSave(ObjectAdapter onObject) {
        this.removeCommand(SaveObjectCommand.class, onObject);
    }

    public String toString() {
        return this.appendTo(new ToString((Object)this)).toString();
    }

    protected ToString appendTo(ToString str) {
        str.append("state", (Object)this.state);
        str.append("commands", this.commands.size());
        return str;
    }

    public IsisTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Deprecated
    public MessageBroker getMessageBroker() {
        return (MessageBroker)this.messageBroker;
    }

    public UpdateNotifier getUpdateNotifier() {
        return this.updateNotifier;
    }

    public void enlistCreated(ObjectAdapter adapter) {
        this.enlist(adapter, PublishedObject.ChangeKind.CREATE);
        for (ObjectAssociation property : adapter.getSpecification().getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES)) {
            AdapterAndProperty aap = AdapterAndProperty.of(adapter, property);
            if (property.isNotPersisted()) continue;
            PreAndPostValues papv = PreAndPostValues.pre("[NEW]");
            this.changedObjectProperties.put(aap, papv);
        }
    }

    public void enlistUpdating(ObjectAdapter adapter) {
        this.enlist(adapter, PublishedObject.ChangeKind.UPDATE);
        for (ObjectAssociation property : adapter.getSpecification().getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES)) {
            AdapterAndProperty aap = AdapterAndProperty.of(adapter, property);
            if (property.isNotPersisted()) continue;
            PreAndPostValues papv = PreAndPostValues.pre(aap.getPropertyValue());
            this.changedObjectProperties.put(aap, papv);
        }
    }

    public void enlistDeleting(ObjectAdapter adapter) {
        this.enlist(adapter, PublishedObject.ChangeKind.DELETE);
        for (ObjectAssociation property : adapter.getSpecification().getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES)) {
            AdapterAndProperty aap = AdapterAndProperty.of(adapter, property);
            if (property.isNotPersisted()) continue;
            PreAndPostValues papv = PreAndPostValues.pre(aap.getPropertyValue());
            this.changedObjectProperties.put(aap, papv);
        }
    }

    private void enlist(ObjectAdapter adapter, PublishedObject.ChangeKind changeKind) {
        this.changeKindByEnlistedAdapter.put(adapter, changeKind);
    }

    private Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> getChangedObjectProperties() {
        IsisTransaction.updatePostValues(this.changedObjectProperties.entrySet());
        return Collections.unmodifiableSet(Sets.filter(this.changedObjectProperties.entrySet(), (Predicate)PreAndPostValues.CHANGED));
    }

    private static void updatePostValues(Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> entrySet) {
        for (Map.Entry<AdapterAndProperty, PreAndPostValues> entry : entrySet) {
            AdapterAndProperty aap = entry.getKey();
            PreAndPostValues papv = entry.getValue();
            ObjectAdapter adapter = aap.getAdapter();
            if (adapter.isDestroyed()) {
                papv.setPost("[DELETED]");
                continue;
            }
            papv.setPost(aap.getPropertyValue());
        }
    }

    protected AdapterManager getAdapterManager() {
        return IsisContext.getPersistenceSession().getAdapterManager();
    }

    protected OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }

    public static class PreAndPostValues {
        private static final Predicate<Map.Entry<?, PreAndPostValues>> CHANGED = new Predicate<Map.Entry<?, PreAndPostValues>>(){

            public boolean apply(Map.Entry<?, PreAndPostValues> input) {
                PreAndPostValues papv = input.getValue();
                return papv.differ();
            }
        };
        private final Object pre;
        private Object post;

        public static PreAndPostValues pre(Object preValue) {
            return new PreAndPostValues(preValue, null);
        }

        private PreAndPostValues(Object pre, Object post) {
            this.pre = pre;
            this.post = post;
        }

        public Object getPre() {
            return this.pre;
        }

        public Object getPost() {
            return this.post;
        }

        public void setPost(Object post) {
            this.post = post;
        }

        public String toString() {
            return this.getPre() + " -> " + this.getPost();
        }

        public boolean differ() {
            return !Objects.equal((Object)this.getPre(), (Object)this.getPost());
        }
    }

    public static class AdapterAndProperty {
        private final ObjectAdapter objectAdapter;
        private final ObjectAssociation property;

        public static AdapterAndProperty of(ObjectAdapter adapter, ObjectAssociation property) {
            return new AdapterAndProperty(adapter, property);
        }

        private AdapterAndProperty(ObjectAdapter adapter, ObjectAssociation property) {
            this.objectAdapter = adapter;
            this.property = property;
        }

        public ObjectAdapter getAdapter() {
            return this.objectAdapter;
        }

        public ObjectAssociation getProperty() {
            return this.property;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.objectAdapter == null ? 0 : this.objectAdapter.hashCode());
            result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AdapterAndProperty other = (AdapterAndProperty)obj;
            if (this.objectAdapter == null ? other.objectAdapter != null : !this.objectAdapter.equals(other.objectAdapter)) {
                return false;
            }
            return !(this.property == null ? other.property != null : !this.property.equals(other.property));
        }

        public String toString() {
            return this.getAdapter().getOid().enStringNoVersion(this.getMarshaller()) + " , " + this.getProperty().getId();
        }

        protected OidMarshaller getMarshaller() {
            return new OidMarshaller();
        }

        private Object getPropertyValue() {
            ObjectAdapter referencedAdapter = this.property.get(this.objectAdapter);
            return referencedAdapter == null ? null : referencedAdapter.getObject();
        }
    }

    public static enum State {
        IN_PROGRESS(RuntimeContext.TransactionState.IN_PROGRESS),
        MUST_ABORT(RuntimeContext.TransactionState.MUST_ABORT),
        COMMITTED(RuntimeContext.TransactionState.COMMITTED),
        ABORTED(RuntimeContext.TransactionState.ABORTED);

        public final RuntimeContext.TransactionState transactionState;

        private State(RuntimeContext.TransactionState transactionState) {
            this.transactionState = transactionState;
        }

        public boolean canFlush() {
            return this == IN_PROGRESS;
        }

        public boolean canCommit() {
            return this == IN_PROGRESS;
        }

        public boolean canAbort() {
            return this == IN_PROGRESS || this == MUST_ABORT;
        }

        public boolean isComplete() {
            return this == COMMITTED || this == ABORTED;
        }

        public boolean mustAbort() {
            return this == MUST_ABORT;
        }

        public RuntimeContext.TransactionState getRuntimeContextState() {
            return this.transactionState;
        }
    }
}

