/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.transaction;

import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.PublishedAction;
import org.apache.isis.applib.annotation.PublishedObject;
import org.apache.isis.applib.services.audit.AuditingService3;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.publish.EventPayload;
import org.apache.isis.applib.services.publish.EventPayloadForActionInvocation;
import org.apache.isis.applib.services.publish.EventPayloadForObjectChanged;
import org.apache.isis.applib.services.publish.EventSerializer;
import org.apache.isis.applib.services.publish.PublishingService;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PublishingServiceWithDefaultPayloadFactories;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.TransactionalResource;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManagerException;
import org.apache.isis.core.runtime.system.transaction.MessageBrokerDefault;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosure;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosureWithReturn;
import org.apache.isis.core.runtime.system.transaction.UpdateNotifier;
import org.apache.isis.core.runtime.system.transaction.UpdateNotifierDefault;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisTransactionManager
implements SessionScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(IsisTransactionManager.class);
    private final PersistenceSession persistenceSession;
    private int transactionLevel;
    private final CommandContext commandContext;
    private final AuditingService3 auditingService3;
    private final PublishingServiceWithDefaultPayloadFactories publishingService;
    private IsisSession session;
    private IsisTransaction transaction;
    private final TransactionalResource transactionalResource;

    public IsisTransactionManager(PersistenceSession persistenceSession, TransactionalResource transactionalResource, ServicesInjectorSpi servicesInjectorSpi) {
        this.persistenceSession = persistenceSession;
        this.transactionalResource = transactionalResource;
        this.commandContext = (CommandContext)servicesInjectorSpi.lookupService(CommandContext.class);
        this.auditingService3 = (AuditingService3)servicesInjectorSpi.lookupService(AuditingService3.class);
        this.publishingService = this.getPublishingServiceIfAny(servicesInjectorSpi);
    }

    public void open() {
        Ensure.ensureThatState((Object)this.session, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"session is required");
    }

    public void close() {
        if (this.getTransaction() != null) {
            try {
                this.abortTransaction();
            }
            catch (Exception e2) {
                LOG.error("failure during abort", (Throwable)e2);
            }
        }
        this.session = null;
    }

    public IsisTransaction getTransaction() {
        return this.transaction;
    }

    public int getTransactionLevel() {
        return this.transactionLevel;
    }

    protected UpdateNotifier getUpdateNotifier() {
        return this.getTransaction().getUpdateNotifier();
    }

    protected MessageBroker getMessageBroker() {
        return this.getTransaction().getMessageBroker();
    }

    public void executeWithinTransaction(TransactionalClosure closure) {
        boolean initiallyInTransaction = this.inTransaction();
        if (!initiallyInTransaction) {
            this.startTransaction();
        }
        try {
            closure.preExecute();
            closure.execute();
            closure.onSuccess();
            if (!initiallyInTransaction) {
                this.endTransaction();
            }
        }
        catch (RuntimeException ex) {
            closure.onFailure();
            if (!initiallyInTransaction) {
                try {
                    this.abortTransaction();
                }
                catch (Exception e) {
                    LOG.error("Abort failure after exception", (Throwable)e);
                    throw new IsisTransactionManagerException("Abort failure: " + e.getMessage(), ex);
                }
            }
            throw ex;
        }
    }

    public <Q> Q executeWithinTransaction(TransactionalClosureWithReturn<Q> closure) {
        boolean initiallyInTransaction = this.inTransaction();
        if (!initiallyInTransaction) {
            this.startTransaction();
        }
        try {
            closure.preExecute();
            Q retVal = closure.execute();
            closure.onSuccess();
            if (!initiallyInTransaction) {
                this.endTransaction();
            }
            return retVal;
        }
        catch (RuntimeException ex) {
            closure.onFailure();
            if (!initiallyInTransaction) {
                this.abortTransaction();
            }
            throw ex;
        }
    }

    public boolean inTransaction() {
        return this.getTransaction() != null && !this.getTransaction().getState().isComplete();
    }

    protected final IsisTransaction createTransaction() {
        MessageBroker messageBroker = this.createMessageBroker();
        UpdateNotifier updateNotifier = this.createUpdateNotifier();
        this.transaction = this.createTransaction(messageBroker, updateNotifier, this.transactionalResource);
        return this.transaction;
    }

    private IsisTransaction createTransaction(MessageBroker messageBroker, UpdateNotifier updateNotifier, TransactionalResource transactionalResource) {
        Ensure.ensureThatArg((Object)messageBroker, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)updateNotifier, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        return new IsisTransaction(this, messageBroker, updateNotifier, transactionalResource, this.commandContext, this.auditingService3, this.publishingService);
    }

    public synchronized void startTransaction() {
        boolean noneInProgress = false;
        if (this.getTransaction() == null || this.getTransaction().getState().isComplete()) {
            noneInProgress = true;
            IsisTransaction isisTransaction = this.createTransaction();
            this.transactionLevel = 0;
            this.transactionalResource.startTransaction();
            this.persistenceSession.startTransactionOnCommandIfConfigured(isisTransaction.getTransactionId());
        }
        ++this.transactionLevel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("startTransaction: level " + (this.transactionLevel - 1) + "->" + this.transactionLevel + (noneInProgress ? " (no transaction in progress or was previously completed; transaction created)" : ""));
        }
    }

    public synchronized boolean flushTransaction() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushTransaction");
        }
        if (this.getTransaction() != null) {
            this.persistenceSession.objectChangedAllDirty();
            this.getTransaction().flush();
        }
        return false;
    }

    public synchronized void endTransaction() {
        IsisTransaction transaction;
        if (LOG.isDebugEnabled()) {
            LOG.debug("endTransaction: level " + this.transactionLevel + "->" + (this.transactionLevel - 1));
        }
        if ((transaction = this.getTransaction()) == null || transaction.getState().isComplete()) {
            return;
        }
        Object abortCause = this.getTransaction().getAbortCause();
        if (transaction.getState().mustAbort()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("endTransaction: aborting instead [EARLY TERMINATION], abort cause '" + ((Throwable)abortCause).getMessage() + "' has been set");
            }
            try {
                this.abortTransaction();
                abortCause = this.getTransaction().getAbortCause();
            }
            catch (RuntimeException ex) {
                abortCause = ex;
            }
            if (abortCause != null) {
                throw abortCause;
            }
            return;
        }
        --this.transactionLevel;
        if (this.transactionLevel == 0) {
            if (abortCause == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("endTransaction: committing");
                }
                try {
                    this.persistenceSession.objectChangedAllDirty();
                }
                catch (RuntimeException ex) {
                    abortCause = ex;
                    this.transactionLevel = 1;
                }
            }
            if (abortCause == null) {
                try {
                    this.getTransaction().commit();
                }
                catch (RuntimeException ex) {
                    abortCause = ex;
                    this.transactionLevel = 1;
                }
            }
            if (abortCause == null) {
                try {
                    this.transactionalResource.endTransaction();
                }
                catch (RuntimeException ex) {
                    abortCause = ex;
                    this.transactionLevel = 1;
                    this.getTransaction().setAbortCause(new IsisTransactionManagerException(ex));
                }
            }
            if (abortCause != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("endTransaction: aborting instead, abort cause has been set");
                }
                try {
                    this.abortTransaction();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                throw abortCause;
            }
        } else if (this.transactionLevel < 0) {
            LOG.error("endTransaction: transactionLevel=" + this.transactionLevel);
            this.transactionLevel = 0;
            throw new IllegalStateException(" no transaction running to end (transactionLevel < 0)");
        }
    }

    public synchronized void abortTransaction() {
        if (this.getTransaction() != null) {
            this.getTransaction().markAsAborted();
            this.transactionLevel = 0;
            this.transactionalResource.abortTransaction();
        }
    }

    public void addCommand(PersistenceCommand command) {
        this.getTransaction().addCommand(command);
    }

    public PublishingServiceWithDefaultPayloadFactories getPublishingServiceIfAny(ServicesInjectorSpi servicesInjectorSpi) {
        PublishedAction.PayloadFactory actionPayloadFactory;
        PublishedObject.PayloadFactory objectPayloadFactory;
        PublishingService publishingService = (PublishingService)servicesInjectorSpi.lookupService(PublishingService.class);
        if (publishingService == null) {
            return null;
        }
        EventSerializer eventSerializer = (EventSerializer)servicesInjectorSpi.lookupService(EventSerializer.class);
        if (eventSerializer == null) {
            eventSerializer = this.newSimpleEventSerializer();
        }
        if ((objectPayloadFactory = (PublishedObject.PayloadFactory)servicesInjectorSpi.lookupService(PublishedObject.PayloadFactory.class)) == null) {
            objectPayloadFactory = this.newDefaultObjectPayloadFactory();
        }
        if ((actionPayloadFactory = (PublishedAction.PayloadFactory)servicesInjectorSpi.lookupService(PublishedAction.PayloadFactory.class)) == null) {
            actionPayloadFactory = this.newDefaultActionPayloadFactory();
        }
        return new PublishingServiceWithDefaultPayloadFactories(publishingService, objectPayloadFactory, actionPayloadFactory);
    }

    protected EventSerializer newSimpleEventSerializer() {
        return new EventSerializer.Simple();
    }

    protected PublishedObject.PayloadFactory newDefaultObjectPayloadFactory() {
        return new PublishedObject.PayloadFactory(){

            public EventPayload payloadFor(Object changedObject, PublishedObject.ChangeKind changeKind) {
                return new EventPayloadForObjectChanged(changedObject);
            }
        };
    }

    protected PublishedAction.PayloadFactory newDefaultActionPayloadFactory() {
        return new PublishedAction.PayloadFactory(){

            public EventPayload payloadFor(Identifier actionIdentifier, Object target, List<Object> arguments, Object result) {
                return new EventPayloadForActionInvocation(actionIdentifier, target, arguments, result);
            }
        };
    }

    protected MessageBroker createMessageBroker() {
        return MessageBrokerDefault.acquire(this.getAuthenticationSession());
    }

    protected UpdateNotifier createUpdateNotifier() {
        return new UpdateNotifierDefault();
    }

    protected void ensureTransactionInProgress() {
        Ensure.ensureThatState((Object)(this.getTransaction() != null && !this.getTransaction().getState().isComplete() ? 1 : 0), (Matcher)CoreMatchers.is((Object)true), (String)"No transaction in progress");
    }

    protected void ensureTransactionNotInProgress() {
        Ensure.ensureThatState((Object)(this.getTransaction() != null && !this.getTransaction().getState().isComplete() ? 1 : 0), (Matcher)CoreMatchers.is((Object)false), (String)"Transaction in progress");
    }

    public void debugData(DebugBuilder debug) {
        debug.appendln("Transaction", (Object)this.getTransaction());
    }

    public IsisSession getSession() {
        return this.session;
    }

    public void setSession(IsisSession session) {
        this.session = session;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    protected AdapterManager getAdapterManager() {
        return IsisContext.getPersistenceSession().getAdapterManager();
    }

    protected OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }
}

