/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.transaction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.runtime.system.transaction.MessageBroker;

public class MessageBrokerDefault
implements MessageBroker,
DebuggableWithTitle {
    private static final long serialVersionUID = 1L;
    private final List<String> messages = Lists.newArrayList();
    private final List<String> warnings = Lists.newArrayList();
    private String applicationError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static org.apache.isis.core.commons.authentication.MessageBroker acquire(AuthenticationSession authenticationSession) {
        org.apache.isis.core.commons.authentication.MessageBroker messageBroker;
        AuthenticationSession authenticationSession2 = authenticationSession;
        synchronized (authenticationSession2) {
            messageBroker = authenticationSession.getMessageBroker();
            if (messageBroker == null) {
                messageBroker = new MessageBrokerDefault();
                authenticationSession.setMessageBroker(messageBroker);
            }
        }
        return messageBroker;
    }

    @Deprecated
    public MessageBrokerDefault() {
    }

    public void reset() {
        this.warnings.clear();
        this.messages.clear();
    }

    public void ensureEmpty() {
        if (this.warnings.size() > 0) {
            throw new IsisException("Message broker still has warnings");
        }
        if (this.messages.size() > 0) {
            throw new IsisException("Message broker still has messages");
        }
    }

    public List<String> getMessages() {
        return this.copyAndClear(this.messages);
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }

    public String getMessagesCombined() {
        List<String> x = this.messages;
        String string = ArrayExtensions.asSemicolonDelimitedStr(x);
        return string;
    }

    public List<String> getWarnings() {
        return this.copyAndClear(this.warnings);
    }

    public void addWarning(String message) {
        this.warnings.add(message);
    }

    public String getWarningsCombined() {
        List<String> x = this.warnings;
        String string = ArrayExtensions.asSemicolonDelimitedStr(x);
        return string;
    }

    public void setApplicationError(String error) {
        this.applicationError = error;
    }

    public String getApplicationError() {
        String error = this.applicationError;
        this.setApplicationError(null);
        return error;
    }

    public void debugData(DebugBuilder debug) {
        this.debugArray(debug, "Messages", this.messages);
        this.debugArray(debug, "Warnings", this.messages);
    }

    private void debugArray(DebugBuilder debug, String title, List<String> vector) {
        debug.appendln(title);
        debug.indent();
        if (vector.size() == 0) {
            debug.appendln("none");
        } else {
            for (String text : vector) {
                debug.appendln(text);
            }
        }
        debug.unindent();
    }

    public String debugTitle() {
        return "Simple Message Broker";
    }

    private List<String> copyAndClear(List<String> messages) {
        List<String> copy = Collections.unmodifiableList(new ArrayList<String>(messages));
        messages.clear();
        return copy;
    }
}

