/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.systemusinginstallers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.Noop;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.fixtures.FixturesInstaller;
import org.apache.isis.core.runtime.imageloader.TemplateImageLoader;
import org.apache.isis.core.runtime.persistence.internal.RuntimeContextFromSession;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.IsisSystemException;
import org.apache.isis.core.runtime.system.IsisSystemFixturesHookAbstract;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.internal.InitialisationSession;
import org.apache.isis.core.runtime.system.internal.IsisLocaleInitializer;
import org.apache.isis.core.runtime.system.internal.IsisTimeZoneInitializer;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSessionFactoryDefault;
import org.apache.isis.core.runtime.userprofile.UserProfileLoader;
import org.apache.isis.core.runtime.userprofile.UserProfileLoaderDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IsisSystemAbstract
extends IsisSystemFixturesHookAbstract {
    public static final Logger LOG = LoggerFactory.getLogger(IsisSystemAbstract.class);
    private FixturesInstaller fixtureInstaller;
    private LogonFixture logonFixture;

    public IsisSystemAbstract(DeploymentType deploymentType) {
        super(deploymentType, new IsisLocaleInitializer(), new IsisTimeZoneInitializer());
    }

    public IsisSystemAbstract(DeploymentType deploymentType, IsisLocaleInitializer localeInitializer, IsisTimeZoneInitializer timeZoneInitializer) {
        super(deploymentType, localeInitializer, timeZoneInitializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installFixturesIfRequired() throws IsisSystemException {
        this.fixtureInstaller = this.obtainFixturesInstaller();
        if (this.isNoop(this.fixtureInstaller)) {
            return;
        }
        IsisContext.openSession((AuthenticationSession)new InitialisationSession());
        this.fixtureInstaller.installFixtures();
        try {
            if (!this.getDeploymentType().isProduction()) {
                this.logonFixture = this.fixtureInstaller.getLogonFixture();
            }
        }
        finally {
            IsisContext.closeSession();
        }
    }

    private boolean isNoop(FixturesInstaller candidate) {
        return candidate == null || this.fixtureInstaller instanceof Noop;
    }

    protected abstract FixturesInstaller obtainFixturesInstaller() throws IsisSystemException;

    public FixturesInstaller getFixturesInstaller() {
        return this.fixtureInstaller;
    }

    @Override
    public LogonFixture getLogonFixture() {
        return this.logonFixture;
    }

    @Override
    protected void appendFixturesInstallerDebug(DebugBuilder debug) {
        debug.appendln("Fixture Installer", (Object)(this.fixtureInstaller == null ? "none" : this.fixtureInstaller.getClass().getName()));
    }

    @Override
    public IsisSessionFactory doCreateSessionFactory(DeploymentType deploymentType) throws IsisSystemException {
        PersistenceSessionFactory persistenceSessionFactory = this.obtainPersistenceSessionFactory(deploymentType);
        UserProfileLoaderDefault userProfileLoader = new UserProfileLoaderDefault(this.obtainUserProfileStore());
        return this.createSessionFactory(deploymentType, userProfileLoader, persistenceSessionFactory);
    }

    protected final IsisSessionFactory createSessionFactory(DeploymentType deploymentType, UserProfileLoader userProfileLoader, PersistenceSessionFactory persistenceSessionFactory) throws IsisSystemException {
        IsisConfiguration configuration = this.getConfiguration();
        AuthenticationManager authenticationManager = this.obtainAuthenticationManager(deploymentType);
        AuthorizationManager authorizationManager = this.obtainAuthorizationManager(deploymentType);
        TemplateImageLoader templateImageLoader = this.obtainTemplateImageLoader();
        OidMarshaller oidMarshaller = this.obtainOidMarshaller();
        Collection<MetaModelRefiner> metaModelRefiners = IsisSystemAbstract.refiners(authenticationManager, authorizationManager, templateImageLoader, persistenceSessionFactory);
        SpecificationLoaderSpi reflector = this.obtainSpecificationLoaderSpi(deploymentType, persistenceSessionFactory, metaModelRefiners);
        DomainObjectContainer container = this.obtainContainer();
        List<Object> services = this.obtainServices();
        RuntimeContextFromSession runtimeContext = new RuntimeContextFromSession();
        runtimeContext.injectInto(reflector);
        return new IsisSessionFactoryDefault(deploymentType, configuration, reflector, templateImageLoader, authenticationManager, authorizationManager, userProfileLoader, persistenceSessionFactory, container, services, oidMarshaller);
    }

    private static Collection<MetaModelRefiner> refiners(Object ... possibleRefiners) {
        return ListExtensions.filtered(Arrays.asList(possibleRefiners), MetaModelRefiner.class);
    }
}

