/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.systemusinginstallers;

import java.util.Collection;
import java.util.List;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.facetapi.ClassSubstitutorFactory;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.FacetDecoratorInstaller;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorInstaller;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationManagerInstaller;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManagerInstaller;
import org.apache.isis.core.runtime.fixtures.FixturesInstaller;
import org.apache.isis.core.runtime.imageloader.TemplateImageLoader;
import org.apache.isis.core.runtime.imageloader.TemplateImageLoaderInstaller;
import org.apache.isis.core.runtime.installerregistry.InstallerLookup;
import org.apache.isis.core.runtime.installerregistry.installerapi.PersistenceMechanismInstaller;
import org.apache.isis.core.runtime.services.ServicesInstaller;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.IsisSystemException;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.systemdependencyinjector.SystemDependencyInjector;
import org.apache.isis.core.runtime.systemusinginstallers.IsisSystemAbstract;
import org.apache.isis.core.runtime.transaction.facetdecorator.standard.TransactionFacetDecoratorInstaller;
import org.apache.isis.core.runtime.userprofile.UserProfileStore;
import org.apache.isis.core.runtime.userprofile.UserProfileStoreInstaller;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisSystemUsingInstallers
extends IsisSystemAbstract {
    public static final Logger LOG = LoggerFactory.getLogger(IsisSystemUsingInstallers.class);
    private final InstallerLookup installerLookup;
    private AuthenticationManagerInstaller authenticationInstaller;
    private AuthorizationManagerInstaller authorizationInstaller;
    private ObjectReflectorInstaller reflectorInstaller;
    private ServicesInstaller servicesInstaller;
    private UserProfileStoreInstaller userProfileStoreInstaller;
    private PersistenceMechanismInstaller persistenceMechanismInstaller;
    private FixturesInstaller fixtureInstaller;

    public IsisSystemUsingInstallers(DeploymentType deploymentType, InstallerLookup installerLookup) {
        super(deploymentType);
        Ensure.ensureThatArg((Object)installerLookup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.installerLookup = installerLookup;
    }

    public SystemDependencyInjector getInstallerLookup() {
        return this.installerLookup;
    }

    @Override
    public IsisConfiguration getConfiguration() {
        return this.installerLookup.getConfiguration();
    }

    public void lookupAndSetAuthenticatorAndAuthorization(DeploymentType deploymentType) {
        String authorizationManagerKey;
        AuthorizationManagerInstaller authorizationInstaller;
        String authenticationManagerKey = this.getConfiguration().getString("isis.authentication");
        AuthenticationManagerInstaller authenticationInstaller = this.installerLookup.authenticationManagerInstaller(authenticationManagerKey, deploymentType);
        if (authenticationInstaller != null) {
            this.setAuthenticationInstaller(authenticationInstaller);
        }
        if ((authorizationInstaller = this.installerLookup.authorizationManagerInstaller(authorizationManagerKey = this.getConfiguration().getString("isis.authorization"), deploymentType)) != null) {
            this.setAuthorizationInstaller(authorizationInstaller);
        }
    }

    public void setAuthenticationInstaller(AuthenticationManagerInstaller authenticationManagerInstaller) {
        this.authenticationInstaller = authenticationManagerInstaller;
    }

    public void setAuthorizationInstaller(AuthorizationManagerInstaller authorizationManagerInstaller) {
        this.authorizationInstaller = authorizationManagerInstaller;
    }

    @Override
    protected AuthenticationManager obtainAuthenticationManager(DeploymentType deploymentType) {
        return this.authenticationInstaller.createAuthenticationManager();
    }

    @Override
    protected AuthorizationManager obtainAuthorizationManager(DeploymentType deploymentType) {
        return this.authorizationInstaller.createAuthorizationManager();
    }

    public void lookupAndSetFixturesInstaller() {
        IsisConfiguration configuration = this.installerLookup.getConfiguration();
        String fixture = configuration.getString("isis.fixtures-installer");
        FixturesInstaller fixturesInstaller = this.installerLookup.fixturesInstaller(fixture);
        if (fixturesInstaller != null) {
            this.fixtureInstaller = fixturesInstaller;
        }
    }

    public void setFixtureInstaller(FixturesInstaller fixtureInstaller) {
        this.fixtureInstaller = fixtureInstaller;
    }

    @Override
    protected FixturesInstaller obtainFixturesInstaller() throws IsisSystemException {
        return this.fixtureInstaller;
    }

    @Override
    protected TemplateImageLoader obtainTemplateImageLoader() {
        TemplateImageLoaderInstaller templateImageLoaderInstaller = this.installerLookup.templateImageLoaderInstaller(null);
        if (templateImageLoaderInstaller != null) {
            return templateImageLoaderInstaller.createLoader();
        }
        return super.obtainTemplateImageLoader();
    }

    public void setReflectorInstaller(ObjectReflectorInstaller reflectorInstaller) {
        this.reflectorInstaller = reflectorInstaller;
    }

    @Override
    protected SpecificationLoaderSpi obtainSpecificationLoaderSpi(DeploymentType deploymentType, ClassSubstitutorFactory classSubstitutorFactory, Collection<MetaModelRefiner> metaModelRefiners) throws IsisSystemException {
        if (this.reflectorInstaller == null) {
            String fromCmdLine = this.getConfiguration().getString("isis.reflector");
            this.reflectorInstaller = this.installerLookup.reflectorInstaller(fromCmdLine);
        }
        Ensure.ensureThatState((Object)this.reflectorInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"reflector installer has not been injected and could not be looked up");
        this.reflectorInstaller.addFacetDecoratorInstaller((FacetDecoratorInstaller)this.installerLookup.getInstaller(TransactionFacetDecoratorInstaller.class));
        return this.reflectorInstaller.createReflector(classSubstitutorFactory, metaModelRefiners);
    }

    public void setServicesInstaller(ServicesInstaller servicesInstaller) {
        this.servicesInstaller = servicesInstaller;
    }

    @Override
    protected List<Object> obtainServices() {
        if (this.servicesInstaller == null) {
            this.servicesInstaller = this.installerLookup.servicesInstaller(null);
        }
        Ensure.ensureThatState((Object)this.servicesInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"services installer has not been injected and could not be looked up");
        return this.servicesInstaller.getServices(this.getDeploymentType());
    }

    public void lookupAndSetUserProfileFactoryInstaller() {
        IsisConfiguration configuration = this.getConfiguration();
        String persistor = configuration.getString("isis.user-profile-store");
        UserProfileStoreInstaller userProfilePersistenceMechanismInstaller = this.installerLookup.userProfilePersistenceMechanismInstaller(persistor, this.getDeploymentType());
        if (userProfilePersistenceMechanismInstaller != null) {
            this.setUserProfileStoreInstaller(userProfilePersistenceMechanismInstaller);
        }
    }

    public void setUserProfileStoreInstaller(UserProfileStoreInstaller userProfilestoreInstaller) {
        this.userProfileStoreInstaller = userProfilestoreInstaller;
    }

    @Override
    protected UserProfileStore obtainUserProfileStore() {
        return this.userProfileStoreInstaller.createUserProfileStore(this.getConfiguration());
    }

    public void setPersistenceMechanismInstaller(PersistenceMechanismInstaller persistenceMechanismInstaller) {
        this.persistenceMechanismInstaller = persistenceMechanismInstaller;
    }

    @Override
    protected PersistenceSessionFactory obtainPersistenceSessionFactory(DeploymentType deploymentType) throws IsisSystemException {
        if (this.persistenceMechanismInstaller == null) {
            String persistenceMechanism = this.getConfiguration().getString("isis.persistor");
            this.persistenceMechanismInstaller = this.installerLookup.persistenceMechanismInstaller(persistenceMechanism, deploymentType);
        }
        Ensure.ensureThatState((Object)this.persistenceMechanismInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persistor installer has not been injected and could not be looked up");
        return this.persistenceMechanismInstaller.createPersistenceSessionFactory(deploymentType);
    }
}

