/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.transaction.facetdecorator.standard;

import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertyClearFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertySetterFacet;
import org.apache.isis.core.runtime.transaction.facetdecorator.TransactionFacetDecoratorAbstract;
import org.apache.isis.core.runtime.transaction.facets.ActionInvocationFacetWrapTransaction;
import org.apache.isis.core.runtime.transaction.facets.CollectionAddToFacetWrapTransaction;
import org.apache.isis.core.runtime.transaction.facets.CollectionClearFacetWrapTransaction;
import org.apache.isis.core.runtime.transaction.facets.CollectionRemoveFromFacetWrapTransaction;
import org.apache.isis.core.runtime.transaction.facets.PropertyClearFacetWrapTransaction;
import org.apache.isis.core.runtime.transaction.facets.PropertySetterFacetWrapTransaction;

public class StandardTransactionFacetDecorator
extends TransactionFacetDecoratorAbstract {
    public StandardTransactionFacetDecorator(IsisConfiguration configuration) {
        super(configuration);
    }

    public Facet decorate(Facet facet, FacetHolder requiredHolder) {
        Class facetType = facet.facetType();
        if (facetType == ActionInvocationFacet.class) {
            ActionInvocationFacet decoratedFacet = (ActionInvocationFacet)facet;
            ActionInvocationFacetWrapTransaction decoratingFacet = new ActionInvocationFacetWrapTransaction(decoratedFacet);
            requiredHolder.addFacet((Facet)decoratingFacet);
            return decoratingFacet;
        }
        if (facetType == CollectionAddToFacet.class) {
            CollectionAddToFacet decoratedFacet = (CollectionAddToFacet)facet;
            CollectionAddToFacetWrapTransaction decoratingFacet = new CollectionAddToFacetWrapTransaction(decoratedFacet);
            requiredHolder.addFacet((Facet)decoratingFacet);
            return decoratingFacet;
        }
        if (facetType == CollectionClearFacet.class) {
            CollectionClearFacet decoratedFacet = (CollectionClearFacet)facet;
            CollectionClearFacetWrapTransaction decoratingFacet = new CollectionClearFacetWrapTransaction(decoratedFacet);
            requiredHolder.addFacet((Facet)decoratingFacet);
            return decoratingFacet;
        }
        if (facetType == CollectionRemoveFromFacet.class) {
            CollectionRemoveFromFacet decoratedFacet = (CollectionRemoveFromFacet)facet;
            CollectionRemoveFromFacetWrapTransaction decoratingFacet = new CollectionRemoveFromFacetWrapTransaction(decoratedFacet);
            requiredHolder.addFacet((Facet)decoratingFacet);
            return decoratingFacet;
        }
        if (facetType == PropertyClearFacet.class) {
            PropertyClearFacet decoratedFacet = (PropertyClearFacet)facet;
            PropertyClearFacetWrapTransaction decoratingFacet = new PropertyClearFacetWrapTransaction(decoratedFacet);
            requiredHolder.addFacet((Facet)decoratingFacet);
            return decoratingFacet;
        }
        if (facetType == PropertySetterFacet.class) {
            PropertySetterFacet decoratedFacet = (PropertySetterFacet)facet;
            PropertySetterFacetWrapTransaction decoratingFacet = new PropertySetterFacetWrapTransaction(decoratedFacet);
            requiredHolder.addFacet((Facet)decoratingFacet);
            return decoratingFacet;
        }
        return facet;
    }
}

