/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.userprofile;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.services.RequestScopedService;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.userprofile.UserProfile;
import org.apache.isis.core.runtime.userprofile.UserProfileLoader;
import org.apache.isis.core.runtime.userprofile.UserProfileStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileLoaderDefault
implements UserProfileLoader,
DebuggableWithTitle {
    private static final String DEFAULT_PERSPECTIVE_NAME = "Apache Isis";
    private static final String EXPLORATION = " Exploration";
    private final Logger LOG = LoggerFactory.getLogger(UserProfile.class);
    private final UserProfileStore store;
    private final Mode mode;
    private UserProfile userProfile;
    private List<Object> serviceList;

    public UserProfileLoaderDefault(UserProfileStore store) {
        this(store, Mode.STRICT);
    }

    public UserProfileLoaderDefault(UserProfileStore store, Mode mode) {
        this.store = store;
        this.mode = mode;
    }

    public void init() {
    }

    public void shutdown() {
    }

    public boolean isFixturesInstalled() {
        return this.store.isFixturesInstalled();
    }

    public void saveAsDefault(UserProfile userProfile) {
        this.store.save("_default", userProfile);
    }

    public void saveForUser(String userName, UserProfile userProfile) {
        this.store.save(userName, userProfile);
    }

    public void saveSession(List<ObjectAdapter> objects) {
        this.loadOrCreateProfile();
        this.userProfile.saveObjects(objects);
        this.save(this.userProfile);
    }

    private void save(UserProfile userProfile) {
        this.saveForUser(UserProfileLoaderDefault.userName(), userProfile);
    }

    public UserProfile getProfile(AuthenticationSession session) {
        String userName = session.getUserName();
        UserProfile profile = this.store.getUserProfile(userName);
        this.userProfile = profile != null ? profile : this.createUserProfile(userName);
        return this.userProfile;
    }

    @Deprecated
    public UserProfile getProfile() {
        this.loadOrCreateProfile();
        return this.userProfile;
    }

    private void loadOrCreateProfile() {
        if (this.userProfile == null) {
            String userName = UserProfileLoaderDefault.userName();
            UserProfile profile = this.store.getUserProfile(userName);
            this.userProfile = profile != null ? profile : this.createUserProfile(userName);
        }
    }

    private UserProfile createUserProfile(String userName) {
        UserProfile template = this.store.getUserProfile("_default");
        if (template == null) {
            return this.createDefaultProfile(userName);
        }
        return this.createProfileFromTemplate(userName, template);
    }

    private UserProfile createDefaultProfile(String userName) {
        UserProfile profile = new UserProfile();
        profile.newPerspective(DEFAULT_PERSPECTIVE_NAME + (IsisContext.getDeploymentType().isExploring() ? EXPLORATION : ""));
        ArrayList singletonServices = Lists.newArrayList((Iterable)Iterables.filter(this.getServices(), (Predicate)Predicates.not(RequestScopedService.Predicates.instanceOf())));
        if (singletonServices.size() == 0 && this.mode == Mode.STRICT) {
            throw new IsisException("No known (singleton) services");
        }
        for (Object service : singletonServices) {
            profile.getPerspective().addToServices(service);
        }
        this.LOG.debug("creating exploration UserProfile for " + userName);
        return profile;
    }

    private UserProfile createProfileFromTemplate(String userName, UserProfile template) {
        UserProfile userProfile = new UserProfile();
        userProfile.copy(template);
        this.LOG.info("creating UserProfile, from template, for " + userName);
        return userProfile;
    }

    public void debugData(DebugBuilder debug) {
        debug.appendln("Store", (Object)this.store.toString());
        debug.appendln("Mode", (Object)this.mode);
        debug.appendln("Store", (Object)this.store);
        debug.appendln("User Profile", (Object)this.userProfile);
    }

    public String debugTitle() {
        return "User Profile Service";
    }

    public List<Object> getServices() {
        return this.serviceList;
    }

    public void setServices(List<Object> serviceList) {
        this.serviceList = serviceList;
    }

    private static AuthenticationSession getAuthenticationSession() {
        return UserProfileLoaderDefault.getSession().getAuthenticationSession();
    }

    private static String userName() {
        return UserProfileLoaderDefault.getAuthenticationSession().getUserName();
    }

    private static IsisSession getSession() {
        return IsisContext.getSession();
    }

    public static enum Mode {
        STRICT,
        RELAXED;

    }
}

