/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.viewer;

import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.authentication.AuthenticationRequestPassword;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.systemdependencyinjector.SystemDependencyInjector;
import org.apache.isis.core.runtime.viewer.IsisViewer;
import org.apache.isis.core.runtime.viewer.web.WebAppSpecification;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class IsisViewerAbstract
implements IsisViewer {
    private DeploymentType deploymentType;
    private SystemDependencyInjector systemDependencyInjector;
    private IsisConfigurationBuilder isisConfigurationBuilder;
    private AuthenticationRequest authenticationRequestViaArgs;

    public void init() {
        this.ensureDependenciesInjected();
        IsisConfiguration configuration = this.isisConfigurationBuilder.getConfiguration();
        this.deploymentType = DeploymentType.lookup(configuration.getString("isis.deploymentType"));
        String user = configuration.getString("isis.user");
        String password = configuration.getString("isis.password");
        if (user != null) {
            this.authenticationRequestViaArgs = new AuthenticationRequestPassword(user, password);
        }
    }

    public void shutdown() {
    }

    public final DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public WebAppSpecification getWebAppSpecification() {
        return null;
    }

    public AuthenticationRequest getAuthenticationRequestViaArgs() {
        return this.authenticationRequestViaArgs;
    }

    protected void clearAuthenticationRequestViaArgs() {
        this.authenticationRequestViaArgs = null;
    }

    public LogonFixture getLogonFixture() {
        return null;
    }

    protected void ensureDependenciesInjected() {
        Ensure.ensureThatState((Object)this.systemDependencyInjector, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState((Object)this.isisConfigurationBuilder, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Override
    public void setSystemDependencyInjector(SystemDependencyInjector dependencyInjector) {
        this.systemDependencyInjector = dependencyInjector;
    }

    protected IsisConfigurationBuilder getConfigurationBuilder() {
        return this.isisConfigurationBuilder;
    }

    public void setConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        this.isisConfigurationBuilder = isisConfigurationBuilder;
    }

    protected static IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }

    public static AuthenticationManager getAuthenticationManager() {
        return IsisContext.getAuthenticationManager();
    }
}

