/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategy;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategyDefault;
import org.apache.isis.core.webapp.content.ResourceCachingFilter;

public class IsisSessionFilter
implements Filter {
    public static final String AUTHENTICATION_SESSION_STRATEGY_KEY = "authenticationSessionStrategy";
    public static final String AUTHENTICATION_SESSION_STRATEGY_DEFAULT = AuthenticationSessionStrategyDefault.class.getName();
    public static final String LOGON_PAGE_KEY = "logonPage";
    public static final String WHEN_NO_SESSION_KEY = "whenNoSession";
    public static final String RESTRICTED_KEY = "restricted";
    public static final String REDIRECT_TO_ON_EXCEPTION_KEY = "redirectToOnException";
    public static final String IGNORE_EXTENSIONS_KEY = "ignoreExtensions";
    private static final Function<String, Pattern> STRING_TO_PATTERN = new Function<String, Pattern>(){

        public Pattern apply(String input) {
            return Pattern.compile(".*\\." + input);
        }
    };
    private static final String SESSION_STATE_KEY = SessionState.class.getName();
    private AuthenticationSessionStrategy authSessionStrategy;
    private List<String> restrictedPaths;
    private WhenNoSession whenNoSession;
    private String redirectToOnException;
    private Collection<Pattern> ignoreExtensions;

    static void redirect(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String redirectTo) throws IOException {
        httpResponse.sendRedirect(StringExtensions.combinePath((String)httpRequest.getContextPath(), (String)redirectTo));
    }

    public void init(FilterConfig config) throws ServletException {
        this.authSessionStrategy = IsisSessionFilter.lookup(config.getInitParameter(AUTHENTICATION_SESSION_STRATEGY_KEY));
        this.lookupWhenNoSession(config);
        this.lookupRedirectToOnException(config);
        this.lookupIgnoreExtensions(config);
    }

    public static AuthenticationSessionStrategy lookup(String authLookupStrategyClassName) {
        if (authLookupStrategyClassName == null) {
            authLookupStrategyClassName = AUTHENTICATION_SESSION_STRATEGY_DEFAULT;
        }
        return (AuthenticationSessionStrategy)InstanceUtil.createInstance((String)authLookupStrategyClassName);
    }

    private void lookupWhenNoSession(FilterConfig config) {
        String whenNoSessionStr = config.getInitParameter(WHEN_NO_SESSION_KEY);
        String logonPage = config.getInitParameter(LOGON_PAGE_KEY);
        if (logonPage != null) {
            if (whenNoSessionStr != null) {
                throw new IllegalStateException("The init-param 'logonPage' is only provided for backwards compatibility; remove if the init-param 'whenNoSession' has been specified");
            }
            this.whenNoSession = WhenNoSession.RESTRICTED;
            this.restrictedPaths = Lists.newArrayList((Object[])new String[]{logonPage});
            return;
        }
        this.whenNoSession = WhenNoSession.lookup(whenNoSessionStr);
        if (this.whenNoSession == WhenNoSession.RESTRICTED) {
            String restrictedPathsStr = config.getInitParameter(RESTRICTED_KEY);
            if (restrictedPathsStr == null) {
                throw new IllegalStateException("Require an init-param of 'restricted' key to be set.");
            }
            this.restrictedPaths = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)restrictedPathsStr));
        }
    }

    private void lookupRedirectToOnException(FilterConfig config) {
        this.redirectToOnException = config.getInitParameter(REDIRECT_TO_ON_EXCEPTION_KEY);
    }

    private void lookupIgnoreExtensions(FilterConfig config) {
        this.ignoreExtensions = Collections.unmodifiableCollection(IsisSessionFilter.parseIgnorePatterns(config));
    }

    private static Collection<Pattern> parseIgnorePatterns(FilterConfig config) {
        String ignoreExtensionsStr = config.getInitParameter(IGNORE_EXTENSIONS_KEY);
        if (ignoreExtensionsStr != null) {
            ArrayList ignoreExtensions = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)ignoreExtensionsStr));
            return Collections2.transform((Collection)ignoreExtensions, STRING_TO_PATTERN);
        }
        return Lists.newArrayList();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SessionState sessionState = SessionState.lookup(request);
        sessionState.handle(this, request, response, chain);
    }

    protected IsisTransactionManager getTransactionManager() {
        return IsisContext.getTransactionManager();
    }

    public static enum SessionState {
        UNDEFINED{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(IsisSessionFilter filter, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                if (this.requestIsIgnoreExtension(filter, httpRequest)) {
                    try {
                        chain.doFilter(request, response);
                        return;
                    }
                    finally {
                        this.closeSession();
                    }
                }
                if (ResourceCachingFilter.isCachedResource((HttpServletRequest)httpRequest)) {
                    try {
                        chain.doFilter(request, response);
                        return;
                    }
                    finally {
                        this.closeSession();
                    }
                }
                AuthenticationSession validSession = filter.authSessionStrategy.lookupValid(request, response);
                if (validSession != null) {
                    filter.authSessionStrategy.bind(request, response, validSession);
                    this.openSession(validSession);
                    SESSION_IN_PROGRESS.setOn(request);
                    try {
                        chain.doFilter(request, response);
                    }
                    finally {
                        UNDEFINED.setOn(request);
                        this.closeSession();
                    }
                    return;
                }
                try {
                    NO_SESSION_SINCE_NOT_AUTHENTICATED.setOn(request);
                    filter.whenNoSession.handle(filter, httpRequest, httpResponse, chain);
                }
                catch (RuntimeException ex) {
                    if (filter.redirectToOnException != null) {
                        IsisSessionFilter.redirect(httpRequest, httpResponse, filter.redirectToOnException);
                        return;
                    }
                    throw ex;
                }
                catch (IOException ex) {
                    if (filter.redirectToOnException != null) {
                        IsisSessionFilter.redirect(httpRequest, httpResponse, filter.redirectToOnException);
                        return;
                    }
                    throw ex;
                }
                catch (ServletException ex) {
                    if (filter.redirectToOnException != null) {
                        IsisSessionFilter.redirect(httpRequest, httpResponse, filter.redirectToOnException);
                        return;
                    }
                    throw ex;
                }
                finally {
                    UNDEFINED.setOn(request);
                }
            }

            private boolean requestIsIgnoreExtension(IsisSessionFilter filter, HttpServletRequest httpRequest) {
                String servletPath = httpRequest.getServletPath();
                for (Pattern extension : filter.ignoreExtensions) {
                    if (!extension.matcher(servletPath).matches()) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        NO_SESSION_SINCE_REDIRECTING_TO_LOGON_PAGE,
        NO_SESSION_SINCE_NOT_AUTHENTICATED,
        SESSION_IN_PROGRESS;


        static SessionState lookup(ServletRequest request) {
            Object state = request.getAttribute(SESSION_STATE_KEY);
            return state != null ? (SessionState)((Object)state) : UNDEFINED;
        }

        boolean isValid(AuthenticationSession authSession) {
            return authSession != null && this.getAuthenticationManager().isSessionValid(authSession);
        }

        void setOn(ServletRequest request) {
            request.setAttribute(SESSION_STATE_KEY, (Object)this);
        }

        public void handle(IsisSessionFilter filter, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            chain.doFilter(request, response);
        }

        AuthenticationManager getAuthenticationManager() {
            return IsisContext.getAuthenticationManager();
        }

        IsisSession openSession(AuthenticationSession authSession) {
            return IsisContext.openSession(authSession);
        }

        void closeSession() {
            IsisContext.closeSession();
        }
    }

    public static enum WhenNoSession {
        UNAUTHORIZED("unauthorized"){

            @Override
            public void handle(IsisSessionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                httpResponse.sendError(401);
            }
        }
        ,
        BASIC_AUTH_CHALLENGE("basicAuthChallenge"){

            @Override
            public void handle(IsisSessionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Apache Isis\"");
                httpResponse.sendError(401);
            }
        }
        ,
        CONTINUE("continue"){

            @Override
            public void handle(IsisSessionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
        }
        ,
        RESTRICTED("restricted"){

            @Override
            public void handle(IsisSessionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                if (filter.restrictedPaths.contains(httpRequest.getServletPath())) {
                    chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                    return;
                }
                IsisSessionFilter.redirect(httpRequest, httpResponse, (String)filter.restrictedPaths.get(0));
            }
        };

        private final String initParamValue;

        private WhenNoSession(String initParamValue) {
            this.initParamValue = initParamValue;
        }

        public static WhenNoSession lookup(String whenNoSessionStr) {
            for (WhenNoSession wns : WhenNoSession.values()) {
                if (!wns.initParamValue.equals(whenNoSessionStr)) continue;
                return wns;
            }
            throw new IllegalStateException("require an init-param of 'whenNoSession', taking a value of " + WhenNoSession.values());
        }

        public abstract void handle(IsisSessionFilter var1, HttpServletRequest var2, HttpServletResponse var3, FilterChain var4) throws IOException, ServletException;
    }
}

