/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.auth;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.authentication.exploration.AuthenticationRequestExploration;
import org.apache.isis.core.runtime.fixtures.authentication.AuthenticationRequestLogonFixture;
import org.apache.isis.core.runtime.system.IsisSystem;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.webapp.WebAppConstants;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategyAbstract;

public class AuthenticationSessionStrategyDefault
extends AuthenticationSessionStrategyAbstract {
    @Override
    public AuthenticationSession lookupValid(ServletRequest servletRequest, ServletResponse servletResponse) {
        boolean loggedInUsingLogonFixture;
        boolean sessionValid;
        AuthenticationManager authenticationManager = this.getAuthenticationManager();
        HttpSession httpSession = this.getHttpSession(servletRequest);
        AuthenticationSession authSession = (AuthenticationSession)httpSession.getAttribute(WebAppConstants.HTTP_SESSION_AUTHENTICATION_SESSION_KEY);
        if (authSession != null && (sessionValid = authenticationManager.isSessionValid(authSession))) {
            return authSession;
        }
        ServletContext servletContext = this.getServletContext(servletRequest);
        IsisSystem system = (IsisSystem)servletContext.getAttribute(WebAppConstants.ISIS_SYSTEM_KEY);
        if (system == null) {
            return null;
        }
        LogonFixture logonFixture = system.getLogonFixture();
        if (system.getDeploymentType().isExploring() && (authSession = authenticationManager.authenticate((AuthenticationRequest)new AuthenticationRequestExploration(logonFixture))) != null) {
            return authSession;
        }
        boolean bl = loggedInUsingLogonFixture = httpSession.getAttribute(WebAppConstants.HTTP_SESSION_LOGGED_ON_PREVIOUSLY_USING_LOGON_FIXTURE_KEY) != null;
        if (logonFixture != null && !loggedInUsingLogonFixture) {
            httpSession.setAttribute(WebAppConstants.HTTP_SESSION_LOGGED_ON_PREVIOUSLY_USING_LOGON_FIXTURE_KEY, (Object)true);
            return authenticationManager.authenticate((AuthenticationRequest)new AuthenticationRequestLogonFixture(logonFixture));
        }
        return null;
    }

    @Override
    public void bind(ServletRequest servletRequest, ServletResponse servletResponse, AuthenticationSession authSession) {
        HttpSession httpSession = this.getHttpSession(servletRequest);
        httpSession.setAttribute(WebAppConstants.HTTP_SESSION_AUTHENTICATION_SESSION_KEY, (Object)authSession);
    }

    protected AuthenticationManager getAuthenticationManager() {
        return IsisContext.getAuthenticationManager();
    }
}

