/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils.jaxbadapters;

import com.sun.org.apache.xerces.internal.jaxp.datatype.XMLGregorianCalendarImpl;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class JodaDateTimeXMLGregorianCalendarAdapter {
    private JodaDateTimeXMLGregorianCalendarAdapter() {
    }

    public static DateTime parse(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return null;
        }
        GregorianCalendar gc = xgc.toGregorianCalendar();
        Date time = gc.getTime();
        TimeZone timeZone = gc.getTimeZone();
        DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)timeZone);
        return new DateTime((Object)time, dateTimeZone);
    }

    public static XMLGregorianCalendar print(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        long millis = dateTime.getMillis();
        DateTimeZone dateTimeZone = dateTime.getZone();
        TimeZone timeZone = dateTimeZone.toTimeZone();
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTimeInMillis(millis);
        return new XMLGregorianCalendarImpl(calendar);
    }
}

