/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.specsupport.specs;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import cucumber.api.Scenario;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.specsupport.scenarios.ScenarioExecution;
import org.apache.isis.core.specsupport.scenarios.ScenarioExecutionScope;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Sequence;
import org.jmock.States;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;

public abstract class CukeGlueAbstract {
    protected ScenarioExecution scenarioExecution() {
        if (ScenarioExecution.current() == null) {
            Assert.fail();
            return null;
        }
        return ScenarioExecution.current();
    }

    protected void nextTransaction() {
        ScenarioExecution scenarioExecution = this.scenarioExecution();
        if (scenarioExecution != null) {
            scenarioExecution.endTran(true);
            scenarioExecution.beginTran();
        }
    }

    public Object getVar(String type, String id) {
        return this.scenarioExecution().getVar(type, id);
    }

    public <X> X getVar(String type, String id, Class<X> cls) {
        return this.scenarioExecution().getVar(type, id, cls);
    }

    public void putVar(String type, String id, Object value) {
        this.scenarioExecution().putVar(type, id, value);
    }

    public void removeVar(String type, String id) {
        this.scenarioExecution().removeVar(type, id);
    }

    protected <T> T service(Class<T> cls) {
        return this.scenarioExecution().service(cls);
    }

    protected DomainObjectContainer container() {
        return this.scenarioExecution().container();
    }

    protected WrapperFactory wrapperFactory() {
        return this.scenarioExecution().wrapperFactory();
    }

    protected <T> T wrap(T obj) {
        return (T)this.wrapperFactory().wrap(obj);
    }

    protected <T> T unwrap(T obj) {
        return (T)this.wrapperFactory().unwrap(obj);
    }

    public boolean supportsMocks() {
        return this.scenarioExecution().supportsMocks();
    }

    public void checking(ExpectationBuilder expectations) {
        this.scenarioExecution().checking(expectations);
    }

    public void assertMocksSatisfied() {
        this.scenarioExecution().assertIsSatisfied();
    }

    public Sequence sequence(String name) {
        return this.scenarioExecution().sequence(name);
    }

    public States states(String name) {
        return this.scenarioExecution().states(name);
    }

    public static void assertTableEquals(List listOfExpecteds, Iterable iterableOfActuals) {
        ArrayList listOfActuals = Lists.newArrayList((Iterable)iterableOfActuals);
        Assert.assertThat((Object)listOfActuals.size(), (Matcher)CoreMatchers.is((Object)listOfExpecteds.size()));
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < listOfActuals.size(); ++i) {
            Field[] expectedFields;
            Object actual = listOfActuals.get(i);
            Object expected = listOfExpecteds.get(i);
            for (Field field : expectedFields = expected.getClass().getDeclaredFields()) {
                Object expectedProp;
                String propertyName = field.getName();
                Object actualProp = CukeGlueAbstract.getProperty(actual, propertyName);
                if (Objects.equal((Object)actualProp, (Object)(expectedProp = CukeGlueAbstract.getProperty(expected, propertyName)))) continue;
                buf.append("#" + i + ": " + propertyName + ": " + expectedProp + " vs " + actualProp).append("\n");
            }
        }
        if (buf.length() != 0) {
            Assert.fail((String)("\n" + buf.toString()));
        }
    }

    private static Object getProperty(Object obj, String propertyName) {
        Method method;
        String methodName;
        if (obj == null) {
            return null;
        }
        Class<?> cls = obj.getClass();
        try {
            methodName = "get" + CukeGlueAbstract.capitalize(propertyName);
            method = cls.getMethod(methodName, new Class[0]);
            if (method != null) {
                return method.invoke(obj, new Object[0]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            methodName = "is" + CukeGlueAbstract.capitalize(propertyName);
            method = cls.getMethod(methodName, new Class[0]);
            if (method != null) {
                return method.invoke(obj, new Object[0]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Field field = cls.getDeclaredField(propertyName);
            if (field != null) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field.get(obj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    protected void before(ScenarioExecutionScope scope) {
        ScenarioExecution scenarioExecution = scope.instantiate();
        scenarioExecution.beginTran();
    }

    public void after(Scenario sc) {
        ScenarioExecution.current().endTran(!sc.isFailed());
    }
}

