/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.specsupport.scenarios;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.specsupport.scenarios.ScenarioExecution;
import org.hamcrest.Description;
import org.jmock.api.Action;
import org.jmock.api.Invocation;

public class InMemoryDB {
    private final ScenarioExecution scenarioExecution;
    private Map<EntityId, Object> objectsById = Maps.newHashMap();

    public InMemoryDB(ScenarioExecution scenarioExecution) {
        this.scenarioExecution = scenarioExecution;
    }

    public <T> T getNoCreate(Class<T> cls, String id) {
        for (Class<T> type = cls; type != null; type = type.getSuperclass()) {
            EntityId entityId = new EntityId(cls, id);
            Object object = this.objectsById.get(entityId);
            if (object == null) continue;
            return (T)object;
        }
        return null;
    }

    public <T> T getElseCreate(Class<T> cls, String id) {
        T object = this.getNoCreate(cls, id);
        if (object != null) {
            return object;
        }
        Object obj = this.instantiateAndInject(cls);
        this.init(obj, id);
        return this.put(cls, id, obj);
    }

    public <T> T put(Class<T> cls, String id, Object obj) {
        for (Class<T> type = cls; type != null; type = type.getSuperclass()) {
            EntityId entityId = new EntityId(cls, id);
            this.objectsById.put(entityId, obj);
        }
        return (T)obj;
    }

    private Object instantiateAndInject(Class<?> cls) {
        try {
            return this.scenarioExecution.injectServices(cls.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Action finds(final Class<?> cls) {
        return new Action(){

            public Object invoke(Invocation invocation) throws Throwable {
                if (invocation.getParameterCount() != 1) {
                    throw new IllegalArgumentException("intended for action of findByXxx");
                }
                Object argObj = invocation.getParameter(0);
                if (!(argObj instanceof String)) {
                    throw new IllegalArgumentException("Argument must be a string");
                }
                String arg = (String)argObj;
                return InMemoryDB.this.getElseCreate(cls, arg);
            }

            public void describeTo(Description description) {
                description.appendText("finds an instance of " + cls.getName());
            }
        };
    }

    public <T> List<T> findAll(Class<T> cls) {
        return this.find(cls, Predicates.alwaysTrue());
    }

    public <T> List<T> find(Class<T> cls, Predicate<T> predicate) {
        ArrayList list = Lists.newArrayList();
        for (EntityId entityId : this.objectsById.keySet()) {
            Object object;
            if (!cls.isAssignableFrom(entityId.getType()) || !predicate.apply(object = this.objectsById.get(entityId))) continue;
            list.add(object);
        }
        return list;
    }

    protected void init(Object obj, String str) {
    }

    public static class EntityId {
        private final Class<?> type;
        private final String id;

        public EntityId(Class<?> type, String id) {
            this.type = type;
            this.id = id;
        }

        Class<?> getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityId other = (EntityId)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "EntityId [type=" + this.type + ", id=" + this.id + "]";
        }
    }
}

