/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.tck.dom;

import java.util.List;
import java.util.Map;
import org.apache.isis.applib.AbstractFactoryAndRepository;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryDefault;

public abstract class AbstractEntityRepository<T>
extends AbstractFactoryAndRepository {
    private final Class<T> entityClass;
    private final String serviceId;

    public AbstractEntityRepository(Class<T> entityClass, String serviceId) {
        this.entityClass = entityClass;
        this.serviceId = serviceId;
    }

    public final String getId() {
        return this.serviceId;
    }

    @ActionSemantics(value=ActionSemantics.Of.SAFE)
    @MemberOrder(sequence="1")
    public List<T> list() {
        return this.allInstances(this.entityClass, new long[0]);
    }

    @MemberOrder(sequence="2")
    public T newEntity() {
        Object entity = this.newTransientInstance(this.entityClass);
        this.persist(entity);
        return (T)entity;
    }

    @Programmatic
    public T findByNamedQueryFirstOnly(String queryName, Map<String, Object> argumentByParameterName) {
        QueryDefault query = new QueryDefault(this.entityClass, queryName, argumentByParameterName);
        return (T)this.firstMatch((Query)query);
    }

    @Programmatic
    public List<T> findByNamedQueryAll(String queryName, Map<String, Object> argumentByParameterName) {
        QueryDefault query = new QueryDefault(this.entityClass, queryName, argumentByParameterName);
        return this.allMatches((Query)query);
    }
}

