/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.tck.dom.actions;

import java.util.List;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.MustSatisfy;
import org.apache.isis.applib.annotation.Named;
import org.apache.isis.applib.annotation.ObjectType;
import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.applib.spec.Specification;
import org.apache.isis.core.tck.dom.AbstractEntityRepository;
import org.apache.isis.core.tck.dom.actions.ActionsEntity;

@Named(value="ActionsEntities")
@ObjectType(value="ActionsEntities")
public class ActionsEntityRepository
extends AbstractEntityRepository<ActionsEntity> {
    public ActionsEntityRepository() {
        super(ActionsEntity.class, "ActionsEntities");
    }

    @ActionSemantics(value=ActionSemantics.Of.SAFE)
    @MemberOrder(sequence="1")
    public ActionsEntity findById(@Named(value="id") int id) {
        return this.findByIdIfAny(id);
    }

    @ActionSemantics(value=ActionSemantics.Of.IDEMPOTENT)
    @MemberOrder(sequence="1")
    public ActionsEntity findByIdIdempotent(@Named(value="id") int id) {
        return this.findByIdIfAny(id);
    }

    @ActionSemantics(value=ActionSemantics.Of.NON_IDEMPOTENT)
    @MemberOrder(sequence="1")
    public ActionsEntity findByIdNotIdempotent(@Named(value="id") int id) {
        return this.findByIdIfAny(id);
    }

    private ActionsEntity findByIdIfAny(int id) {
        List<ActionsEntity> subList = this.subList(id, id + 1);
        return subList.isEmpty() ? null : subList.get(0);
    }

    @ActionSemantics(value=ActionSemantics.Of.SAFE)
    @MemberOrder(sequence="1")
    public List<ActionsEntity> subList(@MustSatisfy(value={IntegerCannotBeNegative.class}) @Named(value="from") int from, @MustSatisfy(value={IntegerCannotBeNegative.class}) @Named(value="to") int to) {
        List list = this.list();
        int toChecked = Math.min(to, list.size());
        int fromChecked = Math.min(from, toChecked);
        return list.subList(fromChecked, toChecked);
    }

    public String validateSubList(int from, int to) {
        if (from > to) {
            return "'from' cannot be larger than 'to'";
        }
        return null;
    }

    @ActionSemantics(value=ActionSemantics.Of.SAFE)
    @MemberOrder(sequence="1")
    public boolean contains(@Named(value="searchFor") ActionsEntity entity, @Named(value="from") int from, @Named(value="to") int to) {
        List<ActionsEntity> list = this.subList(from, to);
        return list.contains((Object)entity);
    }

    @ActionSemantics(value=ActionSemantics.Of.SAFE)
    @MemberOrder(sequence="1")
    public List<ActionsEntity> subListWithOptionalRange(@Optional @MustSatisfy(value={IntegerCannotBeNegative.class}) @Named(value="from") Integer from, @Optional @MustSatisfy(value={IntegerCannotBeNegative.class}) @Named(value="to") Integer to) {
        return this.subList(ActionsEntityRepository.valueElseDefault(from, 0), ActionsEntityRepository.valueElseDefault(to, Integer.MAX_VALUE));
    }

    public String validateSubListWithOptionalRange(Integer from, Integer to) {
        return this.validateSubList(ActionsEntityRepository.valueElseDefault(from, 0), ActionsEntityRepository.valueElseDefault(to, Integer.MAX_VALUE));
    }

    private static int valueElseDefault(Integer value, int i) {
        return value != null ? value : i;
    }

    @ActionSemantics(value=ActionSemantics.Of.IDEMPOTENT)
    @MemberOrder(sequence="90")
    public String concatenate(@Named(value="str1") String str1, @Named(value="str2") String str2) {
        return str1 + str2;
    }

    public static class IntegerCannotBeNegative
    implements Specification {
        public String satisfies(Object obj) {
            if (!(obj instanceof Integer)) {
                return null;
            }
            Integer integer = (Integer)obj;
            return integer < 0 ? "Cannot be less than zero" : null;
        }
    }
}

