/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.tck.dom.refs;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jdo.annotations.DatastoreIdentity;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.ObjectType;
import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.core.tck.dom.refs.BaseEntity;
import org.apache.isis.core.tck.dom.refs.BidirWithSetChildEntity;

@PersistenceCapable(identityType=IdentityType.DATASTORE)
@Discriminator(value="BDSP")
@DatastoreIdentity(strategy=IdGeneratorStrategy.IDENTITY)
@ObjectType(value="BDSP")
public class BidirWithSetParentEntity
extends BaseEntity {
    private String name;
    @Persistent(mappedBy="parent")
    private Set<BidirWithSetChildEntity> children = new HashSet<BidirWithSetChildEntity>();

    @Title
    @MemberOrder(sequence="1")
    @Optional
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @MemberOrder(sequence="1")
    public Set<BidirWithSetChildEntity> getChildren() {
        return this.children;
    }

    public void setChildren(Set<BidirWithSetChildEntity> children) {
        this.children = children;
    }

    public BidirWithSetChildEntity newChild(String name) {
        BidirWithSetChildEntity childEntity = (BidirWithSetChildEntity)((Object)this.newTransientInstance(BidirWithSetChildEntity.class));
        childEntity.setName(name);
        childEntity.setParent(this);
        this.getChildren().add(childEntity);
        this.persistIfNotAlready((Object)childEntity);
        return childEntity;
    }

    public BidirWithSetParentEntity removeChild(BidirWithSetChildEntity childEntity) {
        if (this.getChildren().contains((Object)childEntity)) {
            this.getChildren().remove((Object)childEntity);
            childEntity.setParent(null);
        }
        return this;
    }

    public List<BidirWithSetChildEntity> choices0RemoveChild() {
        return Arrays.asList(this.getChildren().toArray(new BidirWithSetChildEntity[0]));
    }
}

