/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.tck.dom.refs;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jdo.annotations.DatastoreIdentity;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.ObjectType;
import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.core.tck.dom.refs.BaseEntity;
import org.apache.isis.core.tck.dom.refs.PolyClassChildEntity;
import org.apache.isis.core.tck.dom.refs.PolyClassSubtype1Entity;
import org.apache.isis.core.tck.dom.refs.PolyClassSubtype2Entity;
import org.apache.isis.core.tck.dom.refs.PolyClassSubtype3Entity;

@PersistenceCapable(identityType=IdentityType.DATASTORE)
@Discriminator(value="PCPR")
@DatastoreIdentity(strategy=IdGeneratorStrategy.IDENTITY)
@ObjectType(value="PCPR")
public class PolyClassParentEntity
extends BaseEntity {
    private String name;
    @Persistent(mappedBy="parent")
    private Set<PolyClassChildEntity> children = new HashSet<PolyClassChildEntity>();

    @Title
    @MemberOrder(sequence="1")
    @Optional
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @MemberOrder(sequence="1")
    public Set<PolyClassChildEntity> getChildren() {
        return this.children;
    }

    public void setChildren(Set<PolyClassChildEntity> children) {
        this.children = children;
    }

    public PolyClassSubtype1Entity newSubtype1(String name, int foo) {
        PolyClassSubtype1Entity childEntity = (PolyClassSubtype1Entity)((Object)this.newTransientInstance(PolyClassSubtype1Entity.class));
        childEntity.setName(name);
        childEntity.setFoo(foo);
        childEntity.setParent(this);
        this.getChildren().add(childEntity);
        this.persistIfNotAlready((Object)childEntity);
        return childEntity;
    }

    public PolyClassSubtype2Entity newSubtype2(String name, String bar) {
        PolyClassSubtype2Entity childEntity = (PolyClassSubtype2Entity)((Object)this.newTransientInstance(PolyClassSubtype2Entity.class));
        childEntity.setName(name);
        childEntity.setParent(this);
        childEntity.setBar(bar);
        this.getChildren().add(childEntity);
        this.persistIfNotAlready((Object)childEntity);
        return childEntity;
    }

    public PolyClassSubtype3Entity newSubtype3(String name, BigDecimal boz) {
        PolyClassSubtype3Entity childEntity = (PolyClassSubtype3Entity)((Object)this.newTransientInstance(PolyClassSubtype3Entity.class));
        childEntity.setName(name);
        childEntity.setParent(this);
        childEntity.setBoz(boz);
        this.getChildren().add(childEntity);
        this.persistIfNotAlready((Object)childEntity);
        return childEntity;
    }

    public PolyClassParentEntity removeChild(PolyClassChildEntity childEntity) {
        if (this.getChildren().contains((Object)childEntity)) {
            this.getChildren().remove((Object)childEntity);
            childEntity.setParent(null);
        }
        return this;
    }

    public List<PolyClassChildEntity> choices0RemoveChild() {
        return Arrays.asList(this.getChildren().toArray(new PolyClassChildEntity[0]));
    }
}

