/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.unittestsupport.bidir;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Set;
import javax.jdo.annotations.Persistent;
import org.apache.isis.core.unittestsupport.AbstractApplyToAllContractTest;
import org.apache.isis.core.unittestsupport.bidir.Child;
import org.apache.isis.core.unittestsupport.bidir.Instantiator;
import org.apache.isis.core.unittestsupport.bidir.InstantiatorMap;
import org.apache.isis.core.unittestsupport.bidir.InstantiatorSimple;
import org.apache.isis.core.unittestsupport.bidir.Instantiators;
import org.apache.isis.core.unittestsupport.bidir.Parent;
import org.apache.isis.core.unittestsupport.utils.CollectUtils;
import org.apache.isis.core.unittestsupport.utils.ReflectUtils;
import org.apache.isis.core.unittestsupport.utils.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;

public abstract class BidirectionalRelationshipContractTestAbstract
extends AbstractApplyToAllContractTest
implements Instantiators {
    private final InstantiatorMap instantiatorMap;

    protected BidirectionalRelationshipContractTestAbstract(String packagePrefix, ImmutableMap<Class<?>, Instantiator> instantiatorsByClass) {
        super(packagePrefix);
        this.instantiatorMap = new InstantiatorMap(instantiatorsByClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void applyContractTest(Class<?> entityType) {
        Set mappedByFields = Reflections.getAllFields(entityType, ReflectUtils.persistentMappedBy);
        for (Field mappedByField : mappedByFields) {
            Parent p = new Parent();
            p.entityType = entityType;
            p.childField = mappedByField;
            try {
                this.out.println("processing " + p.entityType.getSimpleName() + "#" + p.childField.getName());
                this.out.incrementIndent();
                this.process(p);
            }
            finally {
                this.out.decrementIndent();
            }
        }
    }

    private void process(Parent p) {
        Persistent persistentAnnotation = p.childField.getAnnotation(Persistent.class);
        p.mappedBy = persistentAnnotation.mappedBy();
        String getMethod = StringUtils.methodNamed("get", p.childField);
        Set getMethods = Reflections.getAllMethods(p.entityType, BidirectionalRelationshipContractTestAbstract.withConcreteMethodNamed(getMethod));
        Assert.assertThat((String)(p.desc() + ": no unique getXxx() method:" + getMethods), (Object)getMethods.size(), (Matcher)CoreMatchers.is((Object)1));
        p.getMethod = (Method)CollectUtils.firstIn(getMethods);
        Child c = new Child();
        Class<?> returnType = p.getMethod.getReturnType();
        if (Collection.class.isAssignableFrom(returnType)) {
            String addToMethod = StringUtils.methodNamed("addTo", p.childField);
            Set addToMethods = Reflections.getAllMethods(p.entityType, (Predicate)Predicates.and((Predicate[])new Predicate[]{BidirectionalRelationshipContractTestAbstract.withConcreteMethodNamed(addToMethod), ReflectionUtils.withParametersCount((int)1), ReflectUtils.withEntityParameter()}));
            if (addToMethods.size() != 1) {
                this.out.println("no addToXxx() method in parent");
                return;
            }
            p.addToMethod = (Method)CollectUtils.firstIn(addToMethods);
            String removeFromMethod = StringUtils.methodNamed("removeFrom", p.childField);
            Set removeFromMethods = Reflections.getAllMethods(p.entityType, (Predicate)Predicates.and((Predicate[])new Predicate[]{BidirectionalRelationshipContractTestAbstract.withConcreteMethodNamed(removeFromMethod), ReflectionUtils.withParametersCount((int)1), ReflectUtils.withEntityParameter()}));
            if (removeFromMethods.size() != 1) {
                this.out.println("no removeFromXxx() method in parent");
                return;
            }
            p.removeFromMethod = (Method)CollectUtils.firstIn(removeFromMethods);
            Class<?> addToParameterType = p.addToMethod.getParameterTypes()[0];
            Class<?> removeFromParameterType = p.removeFromMethod.getParameterTypes()[0];
            Assert.assertThat((String)(p.desc() + ": " + p.addToMethod.getName() + " and " + p.removeFromMethod.getName() + " should have the same parameter type"), (Object)(addToParameterType == removeFromParameterType ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            c.entityType = addToParameterType;
        } else {
            String modifyMethod = StringUtils.methodNamed("modify", p.childField);
            Set modifyMethods = Reflections.getAllMethods(p.entityType, (Predicate)Predicates.and((Predicate[])new Predicate[]{BidirectionalRelationshipContractTestAbstract.withConcreteMethodNamed(modifyMethod), ReflectionUtils.withParametersCount((int)1), ReflectUtils.withEntityParameter()}));
            if (modifyMethods.size() != 1) {
                this.out.println("no modifyXxx() method in parent");
                return;
            }
            p.modifyMethod = (Method)CollectUtils.firstIn(modifyMethods);
            String clearMethod = StringUtils.methodNamed("clear", p.childField);
            Set clearMethods = Reflections.getAllMethods(p.entityType, (Predicate)Predicates.and(BidirectionalRelationshipContractTestAbstract.withConcreteMethodNamed(clearMethod), (Predicate)ReflectionUtils.withParametersCount((int)0)));
            if (clearMethods.size() != 1) {
                this.out.println("no clearXxx() method in parent");
                return;
            }
            p.clearMethod = (Method)CollectUtils.firstIn(clearMethods);
            c.entityType = p.modifyMethod.getParameterTypes()[0];
        }
        Instantiator parentInstantiator = this.instantiatorFor(p.entityType);
        if (parentInstantiator == null) {
            this.out.println("no instantiator for " + p.entityType.getName());
            return;
        }
        Instantiator childInstantiator = this.instantiatorFor(c.entityType);
        if (childInstantiator == null) {
            this.out.println("no instantiator for " + c.entityType.getName());
            return;
        }
        this.process(p, c);
    }

    private static Predicate<Method> withConcreteMethodNamed(String getMethod) {
        return Predicates.and((Predicate)ReflectionUtils.withName((String)getMethod), (Predicate)new Predicate<Method>(){

            public boolean apply(Method m) {
                return !m.isSynthetic() && !Modifier.isAbstract(m.getModifiers());
            }
        });
    }

    private Instantiator instantiatorFor(Class<?> cls) {
        Instantiator instantiator = this.instantiatorMap.get(cls);
        if (instantiator != null) {
            return instantiator;
        }
        instantiator = this.doInstantiatorFor(cls);
        return (instantiator = this.instantiatorMap.put(cls, instantiator)) != Instantiator.NOOP ? instantiator : null;
    }

    protected Instantiator doInstantiatorFor(Class<?> cls) {
        return new InstantiatorSimple(cls);
    }

    private void process(Parent p, Child c) {
        Set parentFields = Reflections.getAllFields(c.entityType, (Predicate)Predicates.and((Predicate)ReflectionUtils.withName((String)p.mappedBy), ReflectUtils.withTypeAssignableFrom(p.entityType)));
        Assert.assertThat((String)(c.entityType.getName() + ": could not locate '" + p.mappedBy + "' field, returning supertype of " + p.entityType.getSimpleName() + ", (as per @Persistent(mappedBy=...) in parent " + p.entityType.getSimpleName() + ")"), (Object)parentFields.size(), (Matcher)CoreMatchers.is((Object)1));
        c.parentField = (Field)CollectUtils.firstIn(parentFields);
        String getterMethod = StringUtils.methodNamed("get", c.parentField);
        Set getterMethods = Reflections.getAllMethods(c.entityType, (Predicate)Predicates.and((Predicate[])new Predicate[]{BidirectionalRelationshipContractTestAbstract.withConcreteMethodNamed(getterMethod), ReflectionUtils.withParametersCount((int)0), ReflectUtils.withReturnTypeAssignableFrom(p.entityType)}));
        Assert.assertThat((String)(p.descRel(c) + ": could not locate getter " + getterMethod + "() returning supertype of " + p.entityType.getSimpleName()), (Object)getterMethods.size(), (Matcher)CoreMatchers.is((Object)1));
        c.getMethod = (Method)CollectUtils.firstIn(getterMethods);
        String modifyMethod = StringUtils.methodNamed("modify", c.parentField);
        Set modifyMethods = Reflections.getAllMethods(c.entityType, (Predicate)Predicates.and((Predicate[])new Predicate[]{BidirectionalRelationshipContractTestAbstract.withConcreteMethodNamed(modifyMethod), ReflectionUtils.withParametersCount((int)1), ReflectUtils.withParametersAssignableFrom(p.entityType)}));
        if (modifyMethods.size() != 1) {
            this.out.println("no modifyXxx() method in child");
            return;
        }
        c.modifyMethod = (Method)CollectUtils.firstIn(modifyMethods);
        String clearMethod = StringUtils.methodNamed("clear", c.parentField);
        Set clearMethods = Reflections.getAllMethods(c.entityType, (Predicate)Predicates.and(BidirectionalRelationshipContractTestAbstract.withConcreteMethodNamed(clearMethod), (Predicate)ReflectionUtils.withParametersCount((int)0)));
        if (clearMethods.size() != 1) {
            this.out.println("no clearXxx() method in child");
            return;
        }
        c.clearMethod = (Method)CollectUtils.firstIn(clearMethods);
        this.exercise(p, c);
    }

    @Override
    public Object newInstance(Class<?> entityType) {
        Instantiator instantiator = this.instantiatorFor(entityType);
        return instantiator.instantiate();
    }

    private static String assertDesc(Parent p, Child c, String methodDesc, String testDesc) {
        return p.descRel(c) + ": " + methodDesc + ": " + testDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exercise(Parent p, Child c) {
        this.out.println("exercising " + p.descRel(c));
        this.out.incrementIndent();
        try {
            if (p.addToMethod != null) {
                this.oneToManyParentAddTo(p, c);
                this.oneToManyParentAddToWhenAlreadyChild(p, c);
                this.oneToManyParentAddToWhenNull(p, c);
                this.oneToManyChildModify(p, c);
                this.oneToManyChildModifyWhenAlreadyParent(p, c);
                this.oneToManyChildModifyWhenNull(p, c);
                this.oneToManyChildModifyToNewParent(p, c);
                this.oneToManyChildModifyToExistingParent(p, c);
                this.oneToManyParentRemoveFrom(p, c);
                this.oneToManyParentRemoveFromWhenNotAssociated(p, c);
                this.oneToManyParentRemoveFromWhenNull(p, c);
                this.oneToManyChildClear(p, c);
                this.oneToManyChildClearWhenNotAssociated(p, c);
            } else {
                this.oneToOneParentModify(p, c);
                this.oneToOneParentModifyWhenAlreadyChild(p, c);
                this.oneToOneParentModifyWhenNull(p, c);
                this.oneToOneChildModify(p, c);
                this.oneToOneChildModifyWhenAlreadyParent(p, c);
                this.oneToOneChildModifyWhenNull(p, c);
                this.oneToOneChildModifyToNewParent(p, c);
                this.oneToOneChildModifyToExistingParent(p, c);
                this.oneToOneParentClear(p, c);
                this.oneToOneChildClear(p, c);
                this.oneToOneChildClearWhenNotAssociated(p, c);
            }
        }
        finally {
            this.out.decrementIndent();
        }
    }

    private void oneToManyParentAddTo(Parent p, Child c) {
        String methodDesc = "oneToManyParentAddTo";
        this.out.println("oneToManyParentAddTo");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        p.addToChildren(parent1, child1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyParentAddTo", "parent contains child"), p.getChildren(parent1), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{child1}));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyParentAddTo", "child references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
    }

    private void oneToManyParentAddToWhenAlreadyChild(Parent p, Child c) {
        String methodDesc = "oneToManyParentAddToWhenAlreadyChild";
        this.out.println("oneToManyParentAddToWhenAlreadyChild");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        p.addToChildren(parent1, child1);
        p.addToChildren(parent1, child1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyParentAddToWhenAlreadyChild", "parent still contains child"), p.getChildren(parent1), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{child1}));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyParentAddToWhenAlreadyChild", "child still references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
    }

    private void oneToManyParentAddToWhenNull(Parent p, Child c) {
        String methodDesc = "oneToManyParentAddToWhenNull";
        this.out.println("oneToManyParentAddToWhenNull");
        Object parent1 = p.newParent(this);
        p.addToChildren(parent1, null);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyParentAddToWhenNull", "parent does not have any children"), (Object)p.getChildren(parent1).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void oneToManyChildModify(Parent p, Child c) {
        String methodDesc = "oneToManyChildModify";
        this.out.println("oneToManyChildModify");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        c.modifyParent(child1, parent1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModify", "parent contains child"), p.getChildren(parent1), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{child1}));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModify", "child references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
    }

    private void oneToManyChildModifyWhenAlreadyParent(Parent p, Child c) {
        String methodDesc = "oneToManyChildModifyWhenAlreadyParent";
        this.out.println("oneToManyChildModifyWhenAlreadyParent");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        c.modifyParent(child1, parent1);
        c.modifyParent(child1, parent1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModifyWhenAlreadyParent", "parent still contains child"), p.getChildren(parent1), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{child1}));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModifyWhenAlreadyParent", "child still references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
    }

    private void oneToManyChildModifyWhenNull(Parent p, Child c) {
        String methodDesc = "oneToManyChildModifyWhenNull";
        this.out.println("oneToManyChildModifyWhenNull");
        Object child1 = c.newChild(this);
        c.modifyParent(child1, null);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModifyWhenNull", "child does not reference any parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void oneToManyChildModifyToNewParent(Parent p, Child c) {
        String methodDesc = "oneToManyChildModifyToNewParent";
        this.out.println("oneToManyChildModifyToNewParent");
        Object parent1 = p.newParent(this);
        Object parent2 = p.newParent(this);
        Object child1 = c.newChild(this);
        Object child2 = c.newChild(this);
        p.addToChildren(parent1, child1);
        p.addToChildren(parent2, child2);
        c.modifyParent(child1, parent2);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModifyToNewParent", "parent 1 no longer has any children"), (Object)p.getChildren(parent1).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModifyToNewParent", "parent 2 now has both children"), p.getChildren(parent2), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{child1, child2}));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModifyToNewParent", "child 1 now references parent 2"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent2));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModifyToNewParent", "child 2 still references parent 2"), (Object)c.getParent(child2), (Matcher)CoreMatchers.is((Object)parent2));
    }

    private void oneToManyChildModifyToExistingParent(Parent p, Child c) {
        String methodDesc = "oneToManyChildModifyToExistingParent";
        this.out.println("oneToManyChildModifyToExistingParent");
        Object parent1 = p.newParent(this);
        Object parent2 = p.newParent(this);
        Object child1 = c.newChild(this);
        Object child2 = c.newChild(this);
        p.addToChildren(parent1, child1);
        p.addToChildren(parent2, child2);
        c.modifyParent(child1, parent1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModifyToExistingParent", "parent 1 still contains child 1"), p.getChildren(parent1), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{child1}));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModifyToExistingParent", "parent 2 still contains child 2"), p.getChildren(parent2), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{child2}));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModifyToExistingParent", "child 1 still references parent 1"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildModifyToExistingParent", "child 2 still references parent 2"), (Object)c.getParent(child2), (Matcher)CoreMatchers.is((Object)parent2));
    }

    private void oneToManyParentRemoveFrom(Parent p, Child c) {
        String methodDesc = "oneToManyParentRemoveFrom";
        this.out.println("oneToManyParentRemoveFrom");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        p.addToChildren(parent1, child1);
        p.removeFromChildren(parent1, child1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyParentRemoveFrom", "parent no longer contains child"), (Object)p.getChildren(parent1).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyParentRemoveFrom", "child no longer references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void oneToManyParentRemoveFromWhenNull(Parent p, Child c) {
        String methodDesc = "oneToManyParentRemoveFromWhenNull";
        this.out.println("oneToManyParentRemoveFromWhenNull");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        p.addToChildren(parent1, child1);
        p.removeFromChildren(parent1, null);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyParentRemoveFromWhenNull", "parent still contains child"), p.getChildren(parent1), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{child1}));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyParentRemoveFromWhenNull", "child still references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
    }

    private void oneToManyParentRemoveFromWhenNotAssociated(Parent p, Child c) {
        String methodDesc = "oneToManyParentRemoveFromWhenNotAssociated";
        this.out.println("oneToManyParentRemoveFromWhenNotAssociated");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        Object child2 = c.newChild(this);
        p.addToChildren(parent1, child1);
        p.removeFromChildren(parent1, child2);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyParentRemoveFromWhenNotAssociated", "parent still contains child"), p.getChildren(parent1), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{child1}));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyParentRemoveFromWhenNotAssociated", "child still references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
    }

    private void oneToManyChildClear(Parent p, Child c) {
        String methodDesc = "oneToManyChildClear";
        this.out.println("oneToManyChildClear");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        p.addToChildren(parent1, child1);
        c.clearParent(child1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildClear", "parent no longer contains child"), (Object)p.getChildren(parent1).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildClear", "child no longer references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void oneToManyChildClearWhenNotAssociated(Parent p, Child c) {
        String methodDesc = "oneToManyChildClearWhenNotAssociated";
        this.out.println("oneToManyChildClearWhenNotAssociated");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        c.clearParent(child1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildClearWhenNotAssociated", "parent still does not reference child"), (Object)p.getChildren(parent1).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToManyChildClearWhenNotAssociated", "child still does not reference parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void oneToOneParentModify(Parent p, Child c) {
        String methodDesc = "oneToOneParentModify";
        this.out.println("oneToOneParentModify");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        p.modifyChild(parent1, child1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneParentModify", "parent references child"), (Object)p.getChild(parent1), (Matcher)CoreMatchers.is((Object)child1));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneParentModify", "child references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
    }

    private void oneToOneParentModifyWhenAlreadyChild(Parent p, Child c) {
        String methodDesc = "oneToOneParentModifyWhenAlreadyChild";
        this.out.println("oneToOneParentModifyWhenAlreadyChild");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        p.modifyChild(parent1, child1);
        p.modifyChild(parent1, child1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneParentModifyWhenAlreadyChild", "parent still references child"), (Object)p.getChild(parent1), (Matcher)CoreMatchers.is((Object)child1));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneParentModifyWhenAlreadyChild", "child still references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
    }

    private void oneToOneParentModifyWhenNull(Parent p, Child c) {
        String methodDesc = "oneToOneParentModifyWhenNull";
        this.out.println("oneToOneParentModifyWhenNull");
        Object parent1 = p.newParent(this);
        p.modifyChild(parent1, null);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneParentModifyWhenNull", "parent still references child"), (Object)p.getChild(parent1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void oneToOneChildModify(Parent p, Child c) {
        String methodDesc = "oneToOneChildModify";
        this.out.println("oneToOneChildModify");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        c.modifyParent(child1, parent1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModify", "parent references child"), (Object)p.getChild(parent1), (Matcher)CoreMatchers.is((Object)child1));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModify", "child references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
    }

    private void oneToOneChildModifyWhenAlreadyParent(Parent p, Child c) {
        String methodDesc = "oneToOneChildModifyWhenAlreadyParent";
        this.out.println("oneToOneChildModifyWhenAlreadyParent");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        c.modifyParent(child1, parent1);
        c.modifyParent(child1, parent1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModifyWhenAlreadyParent", "parent still references child"), (Object)p.getChild(parent1), (Matcher)CoreMatchers.is((Object)child1));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModifyWhenAlreadyParent", "child still references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
    }

    private void oneToOneChildModifyWhenNull(Parent p, Child c) {
        String methodDesc = "oneToOneChildModifyWhenNull";
        this.out.println("oneToOneChildModifyWhenNull");
        Object child1 = c.newChild(this);
        c.modifyParent(child1, null);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModifyWhenNull", "child still has no parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void oneToOneChildModifyToNewParent(Parent p, Child c) {
        String methodDesc = "oneToOneChildModifyToNewParent";
        this.out.println("oneToOneChildModifyToNewParent");
        Object parent1 = p.newParent(this);
        Object parent2 = p.newParent(this);
        Object child1 = c.newChild(this);
        Object child2 = c.newChild(this);
        p.modifyChild(parent1, child1);
        p.modifyChild(parent2, child2);
        c.modifyParent(child1, parent2);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModifyToNewParent", "parent 1 no longer references child 1"), (Object)p.getChild(parent1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModifyToNewParent", "parent 2 now references child 1"), (Object)p.getChild(parent2), (Matcher)CoreMatchers.is((Object)child1));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModifyToNewParent", "child 1 now references parent 2"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent2));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModifyToNewParent", "child 2, as a side-effect, no longer references parent 2"), (Object)c.getParent(child2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void oneToOneChildModifyToExistingParent(Parent p, Child c) {
        String methodDesc = "oneToOneChildModifyToExistingParent";
        this.out.println("oneToOneChildModifyToExistingParent");
        Object parent1 = p.newParent(this);
        Object parent2 = p.newParent(this);
        Object child1 = c.newChild(this);
        Object child2 = c.newChild(this);
        p.modifyChild(parent1, child1);
        p.modifyChild(parent2, child2);
        c.modifyParent(child1, parent1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModifyToExistingParent", "parent 1 still references child 1"), (Object)p.getChild(parent1), (Matcher)CoreMatchers.is((Object)child1));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModifyToExistingParent", "parent 2 still references child 2"), (Object)p.getChild(parent2), (Matcher)CoreMatchers.is((Object)child2));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModifyToExistingParent", "child 1 still references parent 1"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Object)parent1));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildModifyToExistingParent", "child 2 still references parent 2"), (Object)c.getParent(child2), (Matcher)CoreMatchers.is((Object)parent2));
    }

    private void oneToOneParentClear(Parent p, Child c) {
        String methodDesc = "oneToOneParentClear";
        this.out.println("oneToOneParentClear");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        p.modifyChild(parent1, child1);
        p.clearChild(parent1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneParentClear", "parent no longer references child"), (Object)p.getChild(parent1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneParentClear", "child no longer references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void oneToOneChildClear(Parent p, Child c) {
        String methodDesc = "oneToOneChildClear";
        this.out.println("oneToOneChildClear");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        p.modifyChild(parent1, child1);
        c.clearParent(child1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildClear", "parent no longer references child"), (Object)p.getChild(parent1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildClear", "child no longer references parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void oneToOneChildClearWhenNotAssociated(Parent p, Child c) {
        String methodDesc = "oneToOneChildClearWhenNotAssociated";
        this.out.println("oneToOneChildClearWhenNotAssociated");
        Object parent1 = p.newParent(this);
        Object child1 = c.newChild(this);
        c.clearParent(child1);
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildClearWhenNotAssociated", "parent still does not reference child"), (Object)p.getChild(parent1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((String)BidirectionalRelationshipContractTestAbstract.assertDesc(p, c, "oneToOneChildClearWhenNotAssociated", "child still does not reference parent"), (Object)c.getParent(child1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

