/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.unittestsupport.inject;

import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.apache.isis.core.unittestsupport.AbstractApplyToAllContractTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;

public abstract class InjectServiceMethodMustBeFinalContractTestAbstract
extends AbstractApplyToAllContractTest {
    protected InjectServiceMethodMustBeFinalContractTestAbstract(String packagePrefix) {
        super(packagePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void applyContractTest(Class<?> entityType) {
        Set injectMethods = Reflections.getAllMethods(entityType, (Predicate)ReflectionUtils.withPrefix((String)"inject"));
        for (Method injectMethod : injectMethods) {
            try {
                String desc = this.desc(entityType, injectMethod);
                this.out.println("processing " + desc);
                this.out.incrementIndent();
                this.process(entityType, injectMethod);
            }
            finally {
                this.out.decrementIndent();
            }
        }
    }

    private void process(Class<?> entityType, Method injectMethod) {
        Assert.assertThat((String)(this.desc(entityType, injectMethod) + " must be final"), (Object)Modifier.isFinal(injectMethod.getModifiers()), (Matcher)CoreMatchers.is((Object)true));
    }

    private String desc(Class<?> entityType, Method injectMethod) {
        return entityType.getSimpleName() + "#" + injectMethod.getName() + "(...)";
    }
}

