/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webserver;

import java.net.URI;
import java.util.Formatter;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderDefault;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.runtime.optionhandler.OptionHandler;
import org.apache.isis.core.runtime.runner.IsisRunner;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerDeploymentType;
import org.apache.isis.core.webserver.WebServerBootstrapper;
import org.apache.isis.core.webserver.internal.OptionHandlerAddress;
import org.apache.isis.core.webserver.internal.OptionHandlerDeploymentTypeWebServer;
import org.apache.isis.core.webserver.internal.OptionHandlerPort;
import org.apache.isis.core.webserver.internal.OptionHandlerResourceBase;
import org.apache.isis.core.webserver.internal.OptionHandlerStartupMode;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

public class WebServer {
    private Server jettyServer;

    public static void main(String[] args) {
        new WebServer().run(ArrayExtensions.append((String[])args, (String[])new String[]{"--nosplash"}));
    }

    public void run(int port) {
        String[] args = new String[]{};
        args = OptionHandlerStartupMode.appendArg(args, StartupMode.BACKGROUND);
        args = OptionHandlerPort.appendArg(args, port);
        this.run(args);
    }

    public void run(String[] args) {
        IsisRunner runner = new IsisRunner(args, (OptionHandlerDeploymentType)new OptionHandlerDeploymentTypeWebServer());
        this.addOptionHandlersAndValidators(runner);
        if (!runner.parseAndValidate()) {
            return;
        }
        runner.setConfigurationBuilder((IsisConfigurationBuilder)new IsisConfigurationBuilderDefault());
        runner.primeConfigurationWithCommandLineOptions();
        runner.loadInitialProperties();
        WebServerBootstrapper bootstrapper = new WebServerBootstrapper(runner);
        bootstrapper.bootstrap(null);
        this.jettyServer = bootstrapper.getJettyServer();
    }

    private void addOptionHandlersAndValidators(IsisRunner runner) {
        runner.addOptionHandler((OptionHandler)new OptionHandlerPort());
        runner.addOptionHandler((OptionHandler)new OptionHandlerAddress());
        runner.addOptionHandler((OptionHandler)new OptionHandlerResourceBase());
        runner.addOptionHandler((OptionHandler)new OptionHandlerStartupMode());
    }

    public void stop() {
        if (this.jettyServer == null) {
            return;
        }
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public URI getBase() {
        return URI.create(this.baseFor(this.jettyServer));
    }

    private String baseFor(Server jettyServer) {
        Connector connector = jettyServer.getConnectors()[0];
        String scheme = "http";
        String host = (String)ArrayExtensions.coalesce((Object[])new String[]{connector.getHost(), "localhost"});
        int port = connector.getPort();
        WebAppContext handler = (WebAppContext)jettyServer.getHandler();
        String contextPath = handler.getContextPath();
        StringBuilder buf = new StringBuilder();
        Formatter formatter = new Formatter(buf);
        formatter.format("%s://%s:%d/%s", "http", host, port, contextPath);
        return WebServer.appendSlashIfRequired(buf).toString();
    }

    private static StringBuilder appendSlashIfRequired(StringBuilder buf) {
        if (buf.charAt(buf.length() - 1) != '/') {
            buf.append('/');
        }
        return buf;
    }

    public static enum StartupMode {
        FOREGROUND,
        BACKGROUND;


        public static StartupMode lookup(String value) {
            if (value == null) {
                return null;
            }
            try {
                return StartupMode.valueOf(value.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean isForeground() {
            return this == FOREGROUND;
        }

        public boolean isBackground() {
            return this == BACKGROUND;
        }
    }
}

