/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webserver;

import com.google.inject.Injector;
import java.util.HashMap;
import java.util.List;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.runtime.runner.IsisBootstrapper;
import org.apache.isis.core.runtime.runner.IsisRunner;
import org.apache.isis.core.webserver.WebServer;
import org.apache.isis.core.webserver.WebServerConstants;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebServerBootstrapper
implements IsisBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(WebServerBootstrapper.class);
    private static final String SRC_MAIN_WEBAPP = "src/main/webapp";
    private final IsisRunner runner;
    private Server jettyServer;

    WebServerBootstrapper(IsisRunner runner) {
        this.runner = runner;
    }

    public void bootstrap(Injector injector) {
        IsisConfigurationBuilder isisConfigurationBuilder = this.runner.getStartupConfiguration();
        IsisConfiguration configuration = isisConfigurationBuilder.getConfiguration();
        int port = configuration.getInteger("isis.embedded-web-server.port", 8080);
        String webappContextPath = configuration.getString("isis.embedded-web-server.webapp", "");
        WebServer.StartupMode startupMode = WebServer.StartupMode.lookup(configuration.getString("isis.embedded-web-server.startupMode", WebServerConstants.EMBEDDED_WEB_SERVER_STARTUP_MODE_DEFAULT));
        this.jettyServer = new Server(port);
        Connector[] connectors = this.jettyServer.getConnectors();
        Connector connector = connectors[0];
        connector.setHeaderBufferSize(8192);
        WebAppContext context = new WebAppContext(SRC_MAIN_WEBAPP, webappContextPath);
        this.copyConfigurationPrimersIntoServletContext(context);
        this.jettyServer.setHandler((Handler)context);
        LOG.info("starting Jetty on port " + port + " to serve webapp");
        try {
            this.jettyServer.start();
            if (startupMode.isForeground()) {
                this.jettyServer.join();
            }
        }
        catch (Exception ex) {
            throw new IsisException("Unable to start Jetty server", (Throwable)ex);
        }
    }

    public Server getJettyServer() {
        return this.jettyServer;
    }

    private void copyConfigurationPrimersIntoServletContext(WebAppContext context) {
        List isisConfigurationBuilderPrimers = this.runner.getOptionHandlers();
        context.setAttribute("isis.configurationPrimers", (Object)isisConfigurationBuilderPrimers);
    }

    private void copyDeploymentTypeIntoInitParams(WebAppContext context) {
        HashMap initParams = (HashMap)ObjectExtensions.asT((Object)context.getInitParams());
        initParams = new HashMap(initParams);
        context.setInitParams(initParams);
    }
}

