/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webserver.internal;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandler;
import org.apache.isis.core.webserver.WebServer;

public final class OptionHandlerStartupMode
implements OptionHandler {
    static final String STARTUP_MODE_LONG_OPT = "startup";
    static final String STARTUP_MODE_BASE_OPT = "a";
    private WebServer.StartupMode startupMode;

    public static String[] appendArg(String[] args, WebServer.StartupMode startupMode) {
        return ArrayExtensions.append((String[])args, (String[])new String[]{"--startup", "" + startupMode.name()});
    }

    public void addOption(Options options) {
        OptionBuilder.withArgName((String)"startup mode");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)STARTUP_MODE_LONG_OPT);
        OptionBuilder.withDescription((String)"start in foreground (sync) or background (async)");
        Option option = OptionBuilder.create((String)STARTUP_MODE_BASE_OPT);
        options.addOption(option);
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.startupMode = WebServer.StartupMode.lookup(commandLine.getOptionValue(STARTUP_MODE_BASE_OPT));
        return true;
    }

    public void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        if (this.startupMode != null) {
            isisConfigurationBuilder.add("isis.embedded-web-server.startupMode", this.startupMode.name());
        }
    }
}

