/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.events.ActionArgumentEvent;
import org.apache.isis.applib.events.ActionInvocationEvent;
import org.apache.isis.applib.events.ActionUsabilityEvent;
import org.apache.isis.applib.events.ActionVisibilityEvent;
import org.apache.isis.applib.events.CollectionAccessEvent;
import org.apache.isis.applib.events.CollectionAddToEvent;
import org.apache.isis.applib.events.CollectionMethodEvent;
import org.apache.isis.applib.events.CollectionRemoveFromEvent;
import org.apache.isis.applib.events.CollectionUsabilityEvent;
import org.apache.isis.applib.events.CollectionVisibilityEvent;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.applib.events.ObjectTitleEvent;
import org.apache.isis.applib.events.ObjectValidityEvent;
import org.apache.isis.applib.events.PropertyAccessEvent;
import org.apache.isis.applib.events.PropertyModifyEvent;
import org.apache.isis.applib.events.PropertyUsabilityEvent;
import org.apache.isis.applib.events.PropertyVisibilityEvent;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.wrapper.WrappingObject;
import org.apache.isis.applib.services.wrapper.listeners.InteractionListener;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.wrapper.dispatchers.InteractionEventDispatcher;
import org.apache.isis.core.wrapper.dispatchers.InteractionEventDispatcherTypeSafe;
import org.apache.isis.core.wrapper.handlers.ProxyContextHandler;
import org.apache.isis.core.wrapper.proxy.ProxyCreator;

@DomainService(nature=NatureOfService.DOMAIN)
public class WrapperFactoryDefault
implements WrapperFactory {
    private final List<InteractionListener> listeners = new ArrayList<InteractionListener>();
    private final Map<Class<? extends InteractionEvent>, InteractionEventDispatcher> dispatchersByEventClass = new HashMap<Class<? extends InteractionEvent>, InteractionEventDispatcher>();
    private final ProxyContextHandler proxyContextHandler;
    @Inject
    AuthenticationSessionProvider authenticationSessionProvider;
    @Inject
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;
    @Inject
    IsisSessionFactory isisSessionFactory;

    public WrapperFactoryDefault() {
        this(new ProxyCreator());
    }

    WrapperFactoryDefault(ProxyCreator proxyCreator) {
        this.proxyContextHandler = new ProxyContextHandler(proxyCreator);
        this.dispatchersByEventClass.put(ObjectTitleEvent.class, new InteractionEventDispatcherTypeSafe<ObjectTitleEvent>(){

            @Override
            public void dispatchTypeSafe(ObjectTitleEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.objectTitleRead(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyVisibilityEvent.class, new InteractionEventDispatcherTypeSafe<PropertyVisibilityEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyVisibilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.propertyVisible(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyUsabilityEvent.class, new InteractionEventDispatcherTypeSafe<PropertyUsabilityEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyUsabilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.propertyUsable(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyAccessEvent.class, new InteractionEventDispatcherTypeSafe<PropertyAccessEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyAccessEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.propertyAccessed(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyModifyEvent.class, new InteractionEventDispatcherTypeSafe<PropertyModifyEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyModifyEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.propertyModified(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionVisibilityEvent.class, new InteractionEventDispatcherTypeSafe<CollectionVisibilityEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionVisibilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionVisible(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionUsabilityEvent.class, new InteractionEventDispatcherTypeSafe<CollectionUsabilityEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionUsabilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionUsable(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionAccessEvent.class, new InteractionEventDispatcherTypeSafe<CollectionAccessEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionAccessEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionAccessed(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionAddToEvent.class, new InteractionEventDispatcherTypeSafe<CollectionAddToEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionAddToEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionAddedTo(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionRemoveFromEvent.class, new InteractionEventDispatcherTypeSafe<CollectionRemoveFromEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionRemoveFromEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionRemovedFrom(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionVisibilityEvent.class, new InteractionEventDispatcherTypeSafe<ActionVisibilityEvent>(){

            @Override
            public void dispatchTypeSafe(ActionVisibilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.actionVisible(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionUsabilityEvent.class, new InteractionEventDispatcherTypeSafe<ActionUsabilityEvent>(){

            @Override
            public void dispatchTypeSafe(ActionUsabilityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.actionUsable(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionArgumentEvent.class, new InteractionEventDispatcherTypeSafe<ActionArgumentEvent>(){

            @Override
            public void dispatchTypeSafe(ActionArgumentEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.actionArgument(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionInvocationEvent.class, new InteractionEventDispatcherTypeSafe<ActionInvocationEvent>(){

            @Override
            public void dispatchTypeSafe(ActionInvocationEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.actionInvoked(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ObjectValidityEvent.class, new InteractionEventDispatcherTypeSafe<ObjectValidityEvent>(){

            @Override
            public void dispatchTypeSafe(ObjectValidityEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.objectPersisted(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionMethodEvent.class, new InteractionEventDispatcherTypeSafe<CollectionMethodEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionMethodEvent interactionEvent) {
                for (InteractionListener l : WrapperFactoryDefault.this.getListeners()) {
                    l.collectionMethodInvoked(interactionEvent);
                }
            }
        });
    }

    public <T> T wrap(T domainObject) {
        return this.wrap(domainObject, WrapperFactory.ExecutionMode.EXECUTE);
    }

    public <T> T wrapNoExecute(T domainObject) {
        return this.wrap(domainObject, WrapperFactory.ExecutionMode.NO_EXECUTE);
    }

    public <T> T wrapSkipRules(T domainObject) {
        return this.wrap(domainObject, WrapperFactory.ExecutionMode.SKIP_RULES);
    }

    public <T> T wrap(T domainObject, WrapperFactory.ExecutionMode mode) {
        if (domainObject instanceof WrappingObject) {
            WrappingObject wrapperObject = (WrappingObject)domainObject;
            WrapperFactory.ExecutionMode wrapperMode = wrapperObject.__isis_executionMode();
            if (wrapperMode != mode) {
                Object underlyingDomainObject = wrapperObject.__isis_wrapped();
                return (T)this.createProxy(underlyingDomainObject, mode, this.isisSessionFactory);
            }
            return domainObject;
        }
        return this.createProxy(domainObject, mode, this.isisSessionFactory);
    }

    protected <T> T createProxy(T domainObject, WrapperFactory.ExecutionMode mode, IsisSessionFactory isisSessionFactory) {
        return this.proxyContextHandler.proxy(domainObject, mode, isisSessionFactory);
    }

    public boolean isWrapper(Object possibleWrappedDomainObject) {
        return possibleWrappedDomainObject instanceof WrappingObject;
    }

    @Programmatic
    public <T> T unwrap(T possibleWrappedDomainObject) {
        if (this.isWrapper(possibleWrappedDomainObject)) {
            WrappingObject wrappingObject = (WrappingObject)possibleWrappedDomainObject;
            return (T)wrappingObject.__isis_wrapped();
        }
        return possibleWrappedDomainObject;
    }

    public List<InteractionListener> getListeners() {
        return this.listeners;
    }

    public boolean addInteractionListener(InteractionListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeInteractionListener(InteractionListener listener) {
        return this.listeners.remove(listener);
    }

    public void notifyListeners(InteractionEvent interactionEvent) {
        InteractionEventDispatcher dispatcher = this.dispatchersByEventClass.get(interactionEvent.getClass());
        if (dispatcher == null) {
            throw new RuntimeException("Unknown InteractionEvent - register into dispatchers map");
        }
        dispatcher.dispatch(interactionEvent);
    }
}

