/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper.handlers;

import java.util.Collection;
import java.util.Map;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.wrapper.handlers.CollectionInvocationHandler;
import org.apache.isis.core.wrapper.handlers.DomainObjectInvocationHandler;
import org.apache.isis.core.wrapper.handlers.MapInvocationHandler;
import org.apache.isis.core.wrapper.proxy.ProxyCreator;

public class ProxyContextHandler {
    private final ProxyCreator proxyCreator;

    public ProxyContextHandler(ProxyCreator proxyCreator) {
        this.proxyCreator = proxyCreator;
    }

    public <T> T proxy(T domainObject, WrapperFactory.ExecutionMode mode, IsisSessionFactory isisSessionFactory) {
        DomainObjectInvocationHandler<T> invocationHandler = new DomainObjectInvocationHandler<T>(domainObject, mode, this, isisSessionFactory);
        return this.proxyCreator.instantiateProxy(invocationHandler);
    }

    public <T, E> Collection<E> proxy(Collection<E> collectionToProxy, String collectionName, DomainObjectInvocationHandler<T> handler, OneToManyAssociation otma) {
        CollectionInvocationHandler<T, Collection<E>> collectionInvocationHandler = new CollectionInvocationHandler<T, Collection<E>>(collectionToProxy, collectionName, handler, otma);
        collectionInvocationHandler.setResolveObjectChangedEnabled(handler.isResolveObjectChangedEnabled());
        return (Collection)this.proxyCreator.instantiateProxy(collectionInvocationHandler);
    }

    public <T, P, Q> Map<P, Q> proxy(Map<P, Q> collectionToProxy, String collectionName, DomainObjectInvocationHandler<T> handler, OneToManyAssociation otma) {
        MapInvocationHandler<T, Map<P, Q>> mapInvocationHandler = new MapInvocationHandler<T, Map<P, Q>>(collectionToProxy, collectionName, handler, otma);
        mapInvocationHandler.setResolveObjectChangedEnabled(handler.isResolveObjectChangedEnabled());
        return (Map)this.proxyCreator.instantiateProxy(mapInvocationHandler);
    }
}

