/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper.internal;

import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import org.apache.isis.applib.services.wrapper.WrapperObject;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.CglibEnhanced;
import org.apache.isis.core.wrapper.internal.CgLibClassProxyFactory;
import org.apache.isis.core.wrapper.internal.DelegatingInvocationHandler;
import org.apache.isis.core.wrapper.internal.IProxyFactory;
import org.apache.isis.core.wrapper.internal.InvocationHandlerMethodInterceptor;
import org.apache.isis.core.wrapper.internal.JavaProxyFactory;
import org.apache.isis.core.wrapper.internal.RuntimeExceptionWrapper;

public class CgLibProxy<T> {
    private final DelegatingInvocationHandler<T> handler;

    public CgLibProxy(DelegatingInvocationHandler<T> handler) {
        this.handler = handler;
    }

    public T proxy() {
        T toProxy = this.handler.getDelegate();
        if (CglibEnhanced.class.isAssignableFrom(toProxy.getClass())) {
            this.handler.setResolveObjectChangedEnabled(true);
            Class<?> enhancedClass = toProxy.getClass();
            Class<?> origSuperclass = toProxy.getClass().getSuperclass();
            ArrayList interfaces = new ArrayList();
            interfaces.addAll(Arrays.asList(enhancedClass.getInterfaces()));
            interfaces.remove(Factory.class);
            interfaces.add(WrapperObject.class);
            InvocationHandlerMethodInterceptor interceptor = new InvocationHandlerMethodInterceptor(this.handler);
            return (T)Enhancer.create(origSuperclass, (Class[])interfaces.toArray(new Class[0]), (Callback)interceptor);
        }
        Class<?> clazz = toProxy.getClass();
        Class<?> proxy = null;
        try {
            IProxyFactory<Class<?>> proxyFactory = clazz.isInterface() ? new JavaProxyFactory() : new CgLibClassProxyFactory();
            proxy = proxyFactory.createProxy(clazz, (InvocationHandler)this.handler);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
        return (T)proxy;
    }
}

