/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.persistence.container.DomainObjectContainerObjectChanged;
import org.apache.isis.core.runtime.persistence.container.DomainObjectContainerResolve;
import org.apache.isis.core.wrapper.internal.DelegatingInvocationHandler;

public class DelegatingInvocationHandlerDefault<T>
implements DelegatingInvocationHandler<T> {
    private final T delegate;
    protected final WrapperFactory wrapperFactory;
    private final WrapperFactory.ExecutionMode executionMode;
    protected final Method equalsMethod;
    protected final Method hashCodeMethod;
    protected final Method toStringMethod;
    private final DomainObjectContainerObjectChanged domainObjectContainerObjectChanged;
    private final DomainObjectContainerResolve domainObjectContainerResolve;
    private boolean resolveObjectChangedEnabled;

    public DelegatingInvocationHandlerDefault(T delegate, WrapperFactory headlessViewer, WrapperFactory.ExecutionMode executionMode) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.delegate = delegate;
        this.wrapperFactory = headlessViewer;
        this.executionMode = executionMode;
        this.domainObjectContainerResolve = new DomainObjectContainerResolve();
        this.domainObjectContainerObjectChanged = new DomainObjectContainerObjectChanged();
        try {
            this.equalsMethod = delegate.getClass().getMethod("equals", Object.class);
            this.hashCodeMethod = delegate.getClass().getMethod("hashCode", new Class[0]);
            this.toStringMethod = delegate.getClass().getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("An Object method could not be found: " + e.getMessage());
        }
    }

    @Override
    public boolean isResolveObjectChangedEnabled() {
        return this.resolveObjectChangedEnabled;
    }

    @Override
    public void setResolveObjectChangedEnabled(boolean resolveObjectChangedEnabled) {
        this.resolveObjectChangedEnabled = resolveObjectChangedEnabled;
    }

    protected void resolveIfRequired(ObjectAdapter targetAdapter) {
        this.resolveIfRequired(targetAdapter.getObject());
    }

    protected void resolveIfRequired(Object domainObject) {
        if (this.resolveObjectChangedEnabled) {
            this.domainObjectContainerResolve.resolve(domainObject);
        }
    }

    protected void objectChangedIfRequired(ObjectAdapter targetAdapter) {
        this.objectChangedIfRequired(targetAdapter.getObject());
    }

    protected void objectChangedIfRequired(Object domainObject) {
        if (this.resolveObjectChangedEnabled) {
            this.domainObjectContainerObjectChanged.objectChanged(domainObject);
        }
    }

    public WrapperFactory getHeadlessViewer() {
        return this.wrapperFactory;
    }

    @Override
    public T getDelegate() {
        return this.delegate;
    }

    public WrapperFactory.ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    protected Object delegate(Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return method.invoke(this.getDelegate(), args);
    }

    protected boolean isObjectMethod(Method method) {
        return this.toStringMethod.equals(method) || this.hashCodeMethod.equals(method) || this.equalsMethod.equals(method);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] args) throws Throwable {
        return method.invoke(object, args);
    }

    protected InteractionEvent notifyListeners(InteractionEvent interactionEvent) {
        this.wrapperFactory.notifyListeners(interactionEvent);
        return interactionEvent;
    }
}

